/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.extension.IChildrenProvider;
import org.eclipse.ptp.remotetools.environment.extension.INode;
import org.eclipse.ptp.utils.core.extensionpoints.IProcessMemberVisitor;
import org.eclipse.ptp.utils.core.extensionpoints.ProcessExtensions;

public class ChildrenProviderManager {
    private static final String EXT_PROVIDER_ID = "org.eclipse.ptp.remotetools.environment.core.childrenProvider";
    private List<IChildrenProvider> providers;

    public ChildrenProviderManager() {
        this.processChildrenProviders();
    }

    public INode[] getChildren(ITargetElement targetElement) {
        ArrayList<INode> children = new ArrayList<INode>();
        for (IChildrenProvider provider : this.providers) {
            INode[] objs = provider.getChildren(targetElement);
            int i = 0;
            while (i < objs.length) {
                children.add(objs[i]);
                ++i;
            }
        }
        return children.toArray(new INode[0]);
    }

    private void processChildrenProviders() {
        this.providers = new ArrayList<IChildrenProvider>();
        ProcessExtensions.process((String)EXT_PROVIDER_ID, (IProcessMemberVisitor)new IProcessMemberVisitor(){

            public Object process(IExtension extension, IConfigurationElement member) {
                Object mprovider;
                try {
                    mprovider = member.createExecutableExtension("class");
                    if (IChildrenProvider.class.isAssignableFrom(mprovider.getClass())) {
                        ChildrenProviderManager.this.providers.add((IChildrenProvider)mprovider);
                    }
                }
                catch (CoreException coreException) {
                    mprovider = null;
                }
                return mprovider;
            }
        });
    }
}

