/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

class FileImageDescriptor
extends ImageDescriptor {
    private Class location;
    private String name;

    FileImageDescriptor(Class clazz, String filename) {
        this.location = clazz;
        this.name = filename;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileImageDescriptor)) {
            return false;
        }
        FileImageDescriptor other = (FileImageDescriptor)o;
        if (this.location != null ? !this.location.equals(other.location) : other.location != null) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public Image createImage(boolean returnMissingImageOnError, Device device) {
        String path = this.location.getPackage().getName().replace('.', '/');
        return Graphics.getImage((String)(String.valueOf(path) + "/" + this.name), (InputStream)this.getStream());
    }

    private InputStream getStream() {
        InputStream is = null;
        if (this.location != null) {
            is = this.location.getResourceAsStream(this.name);
        } else {
            try {
                is = new FileInputStream(this.name);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        if (is == null) {
            return null;
        }
        return new BufferedInputStream(is);
    }

    public int hashCode() {
        int code = this.name.hashCode();
        if (this.location != null) {
            code += this.location.hashCode();
        }
        return code;
    }

    public String toString() {
        return "FileImageDescriptor(location=" + this.location + ", name=" + this.name + ")";
    }
}

