/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.analysis.symtab;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rephraserengine.core.util.TwoKeyHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolTable<N, S> {
    protected final Settings<S> settings;
    protected final SymbolTable<N, S> parent;
    protected final TwoKeyHashMap<N, String, S> entries;
    protected final Map<String, SymbolTable<N, S>> namedScopes;

    public SymbolTable() {
        this.settings = new Settings();
        this.entries = new TwoKeyHashMap();
        this.namedScopes = new HashMap<String, SymbolTable<N, S>>();
        this.parent = null;
    }

    public SymbolTable(Settings<S> settings) {
        assert (settings != null);
        this.settings = settings;
        this.entries = new TwoKeyHashMap();
        this.namedScopes = new HashMap<String, SymbolTable<N, S>>();
        this.parent = null;
    }

    public SymbolTable(SymbolTable<N, S> parent) {
        assert (parent != null);
        this.settings = parent.settings;
        this.entries = new TwoKeyHashMap();
        this.namedScopes = new HashMap<String, SymbolTable<N, S>>();
        this.parent = parent;
    }

    protected String canonicalize(String name) {
        assert (name != null);
        if (this.settings.caseSensitive) {
            return name;
        }
        return name.toLowerCase();
    }

    public S lookup(N namespace, String name) {
        assert (namespace != null && name != null);
        if (this.entries.containsEntry(namespace, name = this.canonicalize(name))) {
            return this.entries.getEntry(namespace, name);
        }
        if (this.parent != null && this.settings.resolveInOuterScopeIfLookupFails) {
            return this.parent.lookup(namespace, name);
        }
        return this.settings.errorEntry;
    }

    public boolean contains(N namespace, String name) {
        assert (namespace != null && name != null);
        return this.lookup(namespace, name) != this.settings.errorEntry;
    }

    public S enter(N namespace, String name, S symbol) {
        assert (namespace != null && name != null && symbol != null);
        if (!this.canEnter(namespace, name = this.canonicalize(name))) {
            return null;
        }
        return this.entries.put(namespace, name, symbol);
    }

    public S ensure(N namespace, String name, S symbol) {
        assert (namespace != null && name != null && symbol != null);
        if (!this.canEnter(namespace, name = this.canonicalize(name))) {
            return this.lookup(namespace, name);
        }
        return this.entries.put(namespace, name, symbol);
    }

    public boolean canEnter(N namespace, String name) {
        assert (namespace != null && name != null);
        if (this.entries.containsEntry(namespace, name = this.canonicalize(name))) {
            return false;
        }
        if (this.parent != null && this.settings.resolveInOuterScopeIfLookupFails) {
            return this.settings.allowShadowing || this.parent.lookup(namespace, name) == this.settings.errorEntry;
        }
        return true;
    }

    public SymbolTable<N, S> enterScope() {
        return new SymbolTable<N, S>(this);
    }

    public SymbolTable<N, S> enterNamedScope(String name) {
        SymbolTable<N, S> namedScope = this.enterScope();
        this.namedScopes.put(name, namedScope);
        return namedScope;
    }

    public SymbolTable<N, S> exitScope() {
        return this.parent;
    }

    public SymbolTable<N, S> outermostScope() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.outermostScope();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (N namespace : this.entries.keySet()) {
            sb.append(String.valueOf(namespace.toString().toUpperCase()) + " NAMESPACE:\n");
            for (String name : this.entries.getAllEntriesFor(namespace).keySet()) {
                sb.append("    " + name + " -> " + this.entries.getEntry(namespace, name) + "\n");
            }
            sb.append("\n");
        }
        if (!this.namedScopes.isEmpty()) {
            sb.append("This symbol table contains the following named scopes:\n");
            for (String name : this.namedScopes.keySet()) {
                sb.append("    ");
                sb.append(name);
                sb.append("\n");
            }
        }
        if (this.parent != null) {
            sb.append("\n\n==================== PARENT ====================\n");
            sb.append(this.parent.toString());
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Settings<S> {
        public final S errorEntry;
        public boolean resolveInOuterScopeIfLookupFails = true;
        public boolean allowShadowing = true;
        public boolean caseSensitive = true;

        public Settings() {
            this.errorEntry = null;
        }

        public Settings(S errorEntry) {
            this.errorEntry = errorEntry;
        }
    }
}

