/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.engine;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.AdapterFactoryRegistry;
import org.eclipse.rwt.internal.branding.BrandingManager;
import org.eclipse.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rwt.internal.lifecycle.PhaseListenerRegistry;
import org.eclipse.rwt.internal.lifecycle.PreserveWidgetsPhaseListener;
import org.eclipse.rwt.internal.lifecycle.UICallBackServiceHandler;
import org.eclipse.rwt.internal.resources.DefaultResourceManagerFactory;
import org.eclipse.rwt.internal.resources.ResourceManager;
import org.eclipse.rwt.internal.resources.ResourceRegistry;
import org.eclipse.rwt.internal.resources.ResourceUtil;
import org.eclipse.rwt.internal.service.BrowserSurvey;
import org.eclipse.rwt.internal.service.JSLibraryServiceHandler;
import org.eclipse.rwt.internal.service.RWTStartupPageConfigurer;
import org.eclipse.rwt.internal.service.ServiceManager;
import org.eclipse.rwt.internal.service.SettingStoreManager;
import org.eclipse.rwt.internal.theme.ResourceLoader;
import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.rwt.resources.IResource;
import org.eclipse.rwt.resources.IResourceManagerFactory;
import org.eclipse.rwt.service.ISettingStoreFactory;
import org.eclipse.rwt.service.RWTFileSettingStoreFactory;

public final class RWTServletContextListener
implements ServletContextListener {
    private static final String PREFIX = "org.eclipse.rwt.";
    public static final String ENTRY_POINTS_PARAM = "org.eclipse.rwt.entryPoints";
    public static final String THEMES_PARAM = "org.eclipse.rwt.themes";
    public static final String RESOURCE_MANAGER_FACTORY_PARAM = "org.eclipse.rwt.resourceManagerFactory";
    public static final String SETTING_STORE_FACTORY_PARAM = "org.eclipse.rwt.settingStoreFactory";
    public static final String ADAPTER_FACTORIES_PARAM = "org.eclipse.rwt.adapterFactories";
    public static final String PHASE_LISTENERS_PARAM = "org.eclipse.rwt.phaseListeners";
    public static final String RESOURCES_PARAM = "org.eclipse.rwt.resources";
    public static final String BRANDINGS_PARAM = "org.eclipse.rwt.brandings";
    private static final String SEPARATOR = ",";
    private static final String REGISTERED_ENTRY_POINTS;
    private static final String REGISTERED_PHASE_LISTENERS;
    private static final String REGISTERED_RESOURCES;
    private static final String REGISTERED_BRANDINGS;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.engine.RWTServletContextListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REGISTERED_ENTRY_POINTS = String.valueOf(clazz.getName()) + "registeredEntryPoints";
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.rwt.internal.engine.RWTServletContextListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REGISTERED_PHASE_LISTENERS = String.valueOf(clazz2.getName()) + "registeredPhaseListeners";
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.rwt.internal.engine.RWTServletContextListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REGISTERED_RESOURCES = String.valueOf(clazz3.getName()) + "registeredResources";
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("org.eclipse.rwt.internal.engine.RWTServletContextListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REGISTERED_BRANDINGS = String.valueOf(clazz4.getName()) + "registeredBrandings";
    }

    public void contextInitialized(ServletContextEvent evt) {
        RWTServletContextListener.registerThemes(evt.getServletContext());
        RWTServletContextListener.registerBrandings(evt.getServletContext());
        RWTServletContextListener.registerEntryPoints(evt.getServletContext());
        RWTServletContextListener.registerResourceManagerFactory(evt.getServletContext());
        RWTServletContextListener.registerSettingStoreFactory(evt.getServletContext());
        RWTServletContextListener.registerAdapterFactories(evt.getServletContext());
        RWTServletContextListener.registerPhaseListener(evt.getServletContext());
        RWTServletContextListener.registerResources(evt.getServletContext());
        RWTServletContextListener.registerUICallBackServiceHandler();
        RWTServletContextListener.registerJSLibraryServiceHandler();
        BrowserSurvey.configurer = new RWTStartupPageConfigurer();
        ResourceUtil.startJsConcatenation();
    }

    public void contextDestroyed(ServletContextEvent evt) {
        RWTServletContextListener.deregisterThemes(evt.getServletContext());
        RWTServletContextListener.deregisterBrandings(evt.getServletContext());
        RWTServletContextListener.deregisterEntryPoints(evt.getServletContext());
        RWTServletContextListener.deregisterPhaseListeners(evt.getServletContext());
        RWTServletContextListener.deregisterResources(evt.getServletContext());
        RWTServletContextListener.deregisterUICallBackServiceHandler();
        RWTServletContextListener.deregisterJSLibraryServiceHandler();
        LifeCycleFactory.destroy();
    }

    private static void registerEntryPoints(ServletContext context) {
        HashSet<String> registeredEntryPoints = new HashSet<String>();
        String value = context.getInitParameter(ENTRY_POINTS_PARAM);
        if (value != null) {
            String[] entryPoints = value.split(SEPARATOR);
            int i = 0;
            while (i < entryPoints.length) {
                String entryPoint = entryPoints[i];
                String[] parts = entryPoint.trim().split("#");
                String className = parts[0];
                String entryPointName = "default";
                if (parts.length > 1) {
                    entryPointName = parts[1];
                }
                try {
                    Class<?> clazz = Class.forName(className);
                    EntryPointManager.register(entryPointName, clazz);
                    registeredEntryPoints.add(entryPointName);
                }
                catch (Exception ex) {
                    String text = "Failed to register entry point ''{0}''.";
                    Object[] args = new Object[]{entryPoint};
                    String msg = MessageFormat.format(text, args);
                    context.log(msg, (Throwable)ex);
                }
                ++i;
            }
        }
        RWTServletContextListener.setRegisteredEntryPoints(context, registeredEntryPoints);
    }

    private static void deregisterEntryPoints(ServletContext context) {
        String[] entryPoints = RWTServletContextListener.getRegisteredEntryPoints(context);
        if (entryPoints != null) {
            int i = 0;
            while (i < entryPoints.length) {
                EntryPointManager.deregister(entryPoints[i]);
                ++i;
            }
        }
    }

    private static void setRegisteredEntryPoints(ServletContext ctx, Set entryPoints) {
        String[] value = new String[entryPoints.size()];
        entryPoints.toArray(value);
        ctx.setAttribute(REGISTERED_ENTRY_POINTS, (Object)value);
    }

    private static String[] getRegisteredEntryPoints(ServletContext ctx) {
        return (String[])ctx.getAttribute(REGISTERED_ENTRY_POINTS);
    }

    private static void registerResourceManagerFactory(ServletContext context) {
        String factoryName = context.getInitParameter(RESOURCE_MANAGER_FACTORY_PARAM);
        if (factoryName != null) {
            try {
                Class<?> clazz = Class.forName(factoryName);
                IResourceManagerFactory factory = (IResourceManagerFactory)clazz.newInstance();
                ResourceManager.register(factory);
            }
            catch (Exception ex) {
                String text = "Failed to register resource manager factory ''{0}''.";
                String msg = MessageFormat.format(text, factoryName);
                context.log(msg, (Throwable)ex);
            }
        } else {
            ResourceManager.register(new DefaultResourceManagerFactory());
        }
    }

    private static void registerSettingStoreFactory(ServletContext context) {
        if (!SettingStoreManager.hasFactory()) {
            String factoryName = context.getInitParameter(SETTING_STORE_FACTORY_PARAM);
            if (factoryName != null) {
                try {
                    Class<?> clazz = Class.forName(factoryName);
                    ISettingStoreFactory factory = (ISettingStoreFactory)clazz.newInstance();
                    SettingStoreManager.register(factory);
                }
                catch (Exception ex) {
                    String text = "Failed to register setting store factory ''{0}''.";
                    String msg = MessageFormat.format(text, factoryName);
                    context.log(msg, (Throwable)ex);
                }
            } else {
                SettingStoreManager.register(new RWTFileSettingStoreFactory());
            }
        }
    }

    private static void registerAdapterFactories(ServletContext context) {
        String initParam = context.getInitParameter(ADAPTER_FACTORIES_PARAM);
        if (initParam != null) {
            String[] factoryParams = initParam.split(SEPARATOR);
            int i = 0;
            while (i < factoryParams.length) {
                String[] classNames = factoryParams[i].trim().split("#");
                if (classNames.length != 2) {
                    Object[] param = new Object[]{factoryParams[i]};
                    String text = "''{0}'' is not a valid factory-adaptable pair.";
                    String msg = MessageFormat.format(text, param);
                    context.log(msg);
                } else {
                    try {
                        Class<?> factoryClass = Class.forName(classNames[0]);
                        Class<?> adaptableClass = Class.forName(classNames[1]);
                        AdapterFactoryRegistry.add(factoryClass, adaptableClass);
                    }
                    catch (Throwable thr) {
                        Object[] param = new Object[]{factoryParams[i]};
                        String text = "Could not register the factory-adaptable ''{0}'' pair.";
                        String msg = MessageFormat.format(text, param);
                        context.log(msg, thr);
                    }
                }
                ++i;
            }
        } else {
            Class<?> clazz;
            Class<?> clazz2;
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.rwt.internal.lifecycle.LifeCycleAdapterFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz2 = class$2) == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.swt.widgets.Widget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            AdapterFactoryRegistry.add(clazz3, clazz2);
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("org.eclipse.rwt.internal.lifecycle.LifeCycleAdapterFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz = class$3) == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.swt.widgets.Display");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            AdapterFactoryRegistry.add(clazz4, clazz);
        }
    }

    private static void registerPhaseListener(ServletContext context) {
        int i;
        ArrayList<PhaseListener> phaseListeners = new ArrayList<PhaseListener>();
        String initParam = context.getInitParameter(PHASE_LISTENERS_PARAM);
        if (initParam != null) {
            String[] listenerNames = initParam.split(SEPARATOR);
            i = 0;
            while (i < listenerNames.length) {
                String className = listenerNames[i].trim();
                try {
                    Class<?> clazz = Class.forName(className);
                    PhaseListener listener = (PhaseListener)clazz.newInstance();
                    phaseListeners.add(listener);
                }
                catch (Throwable thr) {
                    String text = "Failed to register phase listener ''{0}''.";
                    String msg = MessageFormat.format(text, className);
                    context.log(msg, thr);
                }
                ++i;
            }
        } else {
            phaseListeners.add(new PreserveWidgetsPhaseListener());
            phaseListeners.add(new CurrentPhase.Listener());
        }
        PhaseListener[] registeredListeners = new PhaseListener[phaseListeners.size()];
        phaseListeners.toArray(registeredListeners);
        i = 0;
        while (i < registeredListeners.length) {
            PhaseListenerRegistry.add(registeredListeners[i]);
            ++i;
        }
        context.setAttribute(REGISTERED_PHASE_LISTENERS, (Object)registeredListeners);
    }

    private static void deregisterPhaseListeners(ServletContext context) {
        PhaseListener[] listeners = RWTServletContextListener.getRegisteredPhaseListeners(context);
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                PhaseListenerRegistry.remove(listeners[i]);
                ++i;
            }
        }
    }

    private static PhaseListener[] getRegisteredPhaseListeners(ServletContext ctx) {
        return (PhaseListener[])ctx.getAttribute(REGISTERED_PHASE_LISTENERS);
    }

    private static void registerResources(ServletContext context) {
        int i;
        ArrayList<IResource> resources = new ArrayList<IResource>();
        String initParam = context.getInitParameter(RESOURCES_PARAM);
        if (initParam != null) {
            String[] resourceClassNames = initParam.split(SEPARATOR);
            i = 0;
            while (i < resourceClassNames.length) {
                String className = resourceClassNames[i].trim();
                try {
                    Class<?> clazz = Class.forName(className);
                    IResource resource = (IResource)clazz.newInstance();
                    resources.add(resource);
                }
                catch (Throwable thr) {
                    String text = "Failed to register resource ''{0}''.";
                    String msg = MessageFormat.format(text, className);
                    context.log(msg, thr);
                }
                ++i;
            }
        }
        IResource[] registeredResources = new IResource[resources.size()];
        resources.toArray(registeredResources);
        i = 0;
        while (i < registeredResources.length) {
            ResourceRegistry.add(registeredResources[i]);
            ++i;
        }
        context.setAttribute(REGISTERED_RESOURCES, (Object)registeredResources);
    }

    private static void deregisterResources(ServletContext context) {
        ResourceRegistry.clear();
    }

    private static void registerThemes(ServletContext context) {
        ThemeManager manager = ThemeManager.getInstance();
        manager.initialize();
        String value = context.getInitParameter(THEMES_PARAM);
        ResourceLoader loader = new ResourceLoader(){

            public InputStream getResourceAsStream(String resourceName) throws IOException {
                return this.getClass().getClassLoader().getResourceAsStream(resourceName);
            }
        };
        if (value != null) {
            String[] themes = value.split(SEPARATOR);
            int i = 0;
            while (i < themes.length) {
                String[] parts = themes[i].trim().split("#");
                if (parts.length >= 2) {
                    String themeId = parts[0];
                    String fileName = parts[1];
                    try {
                        String themeName = "Unnamed Theme: " + themeId;
                        manager.registerTheme(themeId, themeName, fileName, loader);
                    }
                    catch (Exception e) {
                        String text = "Failed to register custom theme ''{0}'' from resource ''{1}''";
                        Object[] args = new Object[]{themeId, fileName};
                        String msg = MessageFormat.format(text, args);
                        context.log(msg, (Throwable)e);
                    }
                }
                ++i;
            }
        }
    }

    private static void deregisterThemes(ServletContext servletContext) {
        ThemeManager.getInstance().reset();
    }

    private static void registerUICallBackServiceHandler() {
        ServiceManager.registerServiceHandler(UICallBackServiceHandler.HANDLER_ID, new UICallBackServiceHandler());
    }

    private static void deregisterUICallBackServiceHandler() {
        String id = UICallBackServiceHandler.HANDLER_ID;
        ServiceManager.unregisterServiceHandler(id);
    }

    private static void registerBrandings(ServletContext servletContext) {
        String value = servletContext.getInitParameter(BRANDINGS_PARAM);
        if (value != null) {
            ArrayList<AbstractBranding> registeredBrandings = new ArrayList<AbstractBranding>();
            String[] brandings = value.split(SEPARATOR);
            int i = 0;
            while (i < brandings.length) {
                String className = brandings[i].trim();
                try {
                    Object newInstance = Class.forName(className).newInstance();
                    AbstractBranding branding = (AbstractBranding)newInstance;
                    BrandingManager.register(branding);
                    registeredBrandings.add(branding);
                }
                catch (Exception e) {
                    String text = "Failed to register branding ''{0}''.";
                    String msg = MessageFormat.format(text, className);
                    servletContext.log(msg, (Throwable)e);
                }
                ++i;
            }
            RWTServletContextListener.setRegisteredBrandings(servletContext, registeredBrandings);
        }
    }

    private static void setRegisteredBrandings(ServletContext context, List brandings) {
        AbstractBranding[] registeredBrandings = new AbstractBranding[brandings.size()];
        brandings.toArray(registeredBrandings);
        context.setAttribute(REGISTERED_BRANDINGS, (Object)registeredBrandings);
    }

    private static void deregisterBrandings(ServletContext context) {
        AbstractBranding[] brandings = (AbstractBranding[])context.getAttribute(REGISTERED_BRANDINGS);
        if (brandings != null) {
            int i = 0;
            while (i < brandings.length) {
                BrandingManager.deregister(brandings[i]);
                ++i;
            }
        }
    }

    private static void registerJSLibraryServiceHandler() {
        ServiceManager.registerServiceHandler(JSLibraryServiceHandler.HANDLER_ID, new JSLibraryServiceHandler());
    }

    private static void deregisterJSLibraryServiceHandler() {
        String id = JSLibraryServiceHandler.HANDLER_ID;
        ServiceManager.unregisterServiceHandler(id);
    }
}

