/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.events;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rwt.internal.events.IEventAdapter;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.swt.SWT;

public class EventAdapter
implements IEventAdapter {
    private static final Object[] EMPTY_RESULT = new Object[0];
    private Map listenerSets;
    static /* synthetic */ Class class$0;

    public Object[] getListener(Class listenerType) {
        ParamCheck.notNull(listenerType, "listenerType");
        Set listenerSet = this.getListenerSet(listenerType);
        int size = listenerSet.size();
        Object[] result = (Object[])Array.newInstance(listenerType, size);
        listenerSet.toArray(result);
        return result;
    }

    public boolean hasListener(Class listenerType) {
        ParamCheck.notNull(listenerType, "listenerType");
        EventAdapter.checkListenerType(listenerType);
        boolean result = false;
        if (this.listenerSets != null && this.listenerSets.containsKey(listenerType)) {
            result = !this.getListenerSet(listenerType).isEmpty();
        }
        return result;
    }

    public void addListener(Class listenerType, Object listener) {
        if (listenerType == null) {
            SWT.error(4);
        }
        if (listener == null) {
            SWT.error(4);
        }
        this.checkTypeCompatibility(listenerType, listener);
        this.getListenerSet(listenerType).add(listener);
    }

    public void removeListener(Class listenerType, Object listener) {
        if (listenerType == null) {
            SWT.error(4);
        }
        if (listener == null) {
            SWT.error(4);
        }
        this.checkTypeCompatibility(listenerType, listener);
        if (this.hasListener(listenerType)) {
            this.getListenerSet(listenerType).remove(listener);
        }
    }

    private Set getListenerSet(Class listenerType) {
        EventAdapter.checkListenerType(listenerType);
        if (this.listenerSets == null) {
            this.listenerSets = new HashMap(4, 1.0f);
        }
        if (!this.listenerSets.containsKey(listenerType)) {
            this.listenerSets.put(listenerType, new ListenerSet());
        }
        return (Set)this.listenerSets.get(listenerType);
    }

    public Object[] getListener() {
        Object[] result = EMPTY_RESULT;
        if (this.listenerSets != null) {
            HashSet<Object> buffer = new HashSet<Object>();
            Object[] sets = this.listenerSets.values().toArray();
            int i = 0;
            while (i < sets.length) {
                Set set = (Set)sets[i];
                Object[] listeners = set.toArray();
                int j = 0;
                while (j < listeners.length) {
                    buffer.add(listeners[j]);
                    ++j;
                }
                ++i;
            }
            result = buffer.toArray();
        }
        return result;
    }

    private void checkTypeCompatibility(Class listenerType, Object listener) {
        if (!listenerType.isAssignableFrom(listener.getClass())) {
            String msg = "Parameter 'listener' must be of type '" + listenerType.getName() + "'.";
            throw new IllegalArgumentException(msg);
        }
    }

    private static void checkListenerType(Class listenerType) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.EventListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(listenerType)) {
            StringBuffer stringBuffer = new StringBuffer("Parameter 'listenerType' must implement '");
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.util.EventListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String msg = stringBuffer.append(clazz2.getName()).append("'").toString();
            throw new IllegalArgumentException(msg);
        }
    }

    private static final class ListenerSet
    implements Set {
        private final List list = new ArrayList(3);

        private ListenerSet() {
        }

        public int size() {
            return this.list.size();
        }

        public void clear() {
            this.list.clear();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public Object[] toArray() {
            return this.list.toArray();
        }

        public boolean add(Object o) {
            boolean result;
            boolean bl = result = !this.contains(o);
            if (result) {
                this.list.add(o);
            }
            return result;
        }

        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        public boolean remove(Object o) {
            return this.list.remove(o);
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            throw new UnsupportedOperationException();
        }

        public Object[] toArray(Object[] a) {
            return this.list.toArray(a);
        }
    }
}

