/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriterUtil;
import org.eclipse.rwt.internal.util.Assert;
import org.eclipse.rwt.internal.util.CssClass;
import org.eclipse.rwt.internal.util.ParamCheck;

public class HtmlResponseWriter
extends Writer {
    public static final String CLASS_PREFIX = "w4tCss";
    private List head = new ArrayList();
    private List body = new ArrayList();
    private List layers = new ArrayList();
    private List foot = new ArrayList();
    private String elementStarted;
    private boolean closed;
    private boolean avoidEscape;
    private Hashtable registeredCssClasses = new Hashtable();
    private Hashtable namedCssClasses = new Hashtable();
    private List jsLibraries = new ArrayList();

    public void appendHead(StringBuffer token) {
        this.head.add(token.toString());
    }

    public void appendHead(String token) {
        this.head.add(token);
    }

    public void append(String token) {
        this.body.add(token);
    }

    public void append(HtmlResponseWriter responseWriter) {
        int i = 0;
        while (i < responseWriter.getBodySize()) {
            this.body.add(responseWriter.getBodyToken(i));
            ++i;
        }
    }

    public void appendFoot(StringBuffer token) {
        this.foot.add(token.toString());
    }

    public void appendFoot(String token) {
        this.foot.add(token);
    }

    public void appendLayer(StringBuffer token) {
        this.appendLayer(token.toString());
    }

    public void appendLayer(String token) {
        this.layers.add(token);
    }

    public void concatLayers() {
        int i = 0;
        while (i < this.layers.size()) {
            this.append(this.layers.get(i).toString());
            ++i;
        }
        this.layers.clear();
    }

    public void clearHead() {
        this.head.clear();
    }

    public void clearBody() {
        this.body.clear();
    }

    public void clearFoot() {
        this.foot.clear();
    }

    public int getHeadSize() {
        return this.head.size();
    }

    public int getBodySize() {
        return this.body.size();
    }

    public int getFootSize() {
        return this.foot.size();
    }

    public String getHeadToken(int index) {
        return this.head.get(index).toString();
    }

    public String getBodyToken(int index) {
        return this.body.get(index).toString();
    }

    public Iterator bodyTokens() {
        return this.body.iterator();
    }

    public String getFootToken(int index) {
        return this.foot.get(index).toString();
    }

    public void equalize(HtmlResponseWriter tokenBuffer) {
        this.foot.clear();
        this.body.clear();
        this.layers.clear();
        this.head.clear();
        this.jsLibraries.clear();
        this.foot = tokenBuffer.foot;
        this.body = tokenBuffer.body;
        this.layers = tokenBuffer.layers;
        this.head = tokenBuffer.head;
        this.jsLibraries = tokenBuffer.jsLibraries;
        this.registeredCssClasses = tokenBuffer.registeredCssClasses;
        this.namedCssClasses = tokenBuffer.namedCssClasses;
    }

    public String[] getJSLibraries() {
        String[] result = new String[this.jsLibraries.size()];
        this.jsLibraries.toArray(result);
        return result;
    }

    public void useJSLibrary(String libraryName) {
        ParamCheck.notNull(libraryName, "libraryName");
        if (!this.jsLibraries.contains(libraryName)) {
            this.jsLibraries.add(libraryName);
        }
    }

    public void removeJSLibraries(String libraryName) {
        this.jsLibraries.remove(libraryName);
    }

    public int getJSLibrariesCount() {
        return this.jsLibraries.size();
    }

    public String registerCssClass(String style) {
        String result = "";
        if (this.registeredCssClasses.containsKey(style)) {
            result = (String)this.registeredCssClasses.get(style);
        } else {
            result = HtmlResponseWriter.createClassName(style);
            this.registeredCssClasses.put(style, result);
        }
        return result;
    }

    public void addNamedCssClass(CssClass cssClass) {
        List<String> allNames;
        Assert.isNotNull(cssClass);
        String content = cssClass.getContent();
        if (this.namedCssClasses.containsKey(content)) {
            allNames = (List)this.namedCssClasses.get(content);
        } else {
            allNames = new ArrayList();
            this.namedCssClasses.put(content, allNames);
        }
        if (!allNames.contains(cssClass.getClassName())) {
            allNames.add(cssClass.getClassName());
        }
    }

    public void mergeRegisteredCssClasses(CssClass[] classes) {
        int i = 0;
        while (i < classes.length) {
            Assert.isNotNull(classes[i]);
            this.registeredCssClasses.put(classes[i].getContent(), classes[i].getClassName());
            ++i;
        }
    }

    public CssClass[] getCssClasses() {
        String content;
        ArrayList<CssClass> alResult = new ArrayList<CssClass>();
        Enumeration keys = this.registeredCssClasses.keys();
        while (keys.hasMoreElements()) {
            content = (String)keys.nextElement();
            String className = (String)this.registeredCssClasses.get(content);
            if (!className.startsWith(".")) {
                className = "." + className;
            }
            alResult.add(new CssClass(className, content));
        }
        keys = this.namedCssClasses.keys();
        while (keys.hasMoreElements()) {
            content = (String)keys.nextElement();
            ArrayList alNames = (ArrayList)this.namedCssClasses.get(content);
            String className = HtmlResponseWriter.getCompoundName(alNames);
            alResult.add(new CssClass(className, content));
        }
        CssClass[] result = new CssClass[alResult.size()];
        alResult.toArray(result);
        return result;
    }

    public int getCssClassCount() {
        return this.registeredCssClasses.size() + this.namedCssClasses.size();
    }

    public void removeCssClass(String content) {
        this.registeredCssClasses.remove(content);
    }

    public void close() throws IOException {
        this.checkIfWriterClosed();
        this.closeElementIfStarted();
        this.closed = true;
    }

    public void flush() throws IOException {
        this.checkIfWriterClosed();
        this.closeElementIfStarted();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.checkIfWriterClosed();
        this.closeElementIfStarted();
        this.doWrite(cbuf, off, len);
    }

    public void write(char character) throws IOException {
        this.checkIfWriterClosed();
        this.append(new String(new char[]{character}));
    }

    public void write(int c) throws IOException {
        this.checkIfWriterClosed();
        this.append(new String(new char[]{(char)c}));
    }

    public void write(String content) throws IOException {
        this.checkIfWriterClosed();
        this.closeElementIfStarted();
        this.doWrite(content);
    }

    public void write(String str, int off, int len) throws IOException {
        this.checkIfWriterClosed();
        this.append(str.substring(off, off + len));
    }

    public void startElement(String name, Object component) throws IOException {
        this.checkIfWriterClosed();
        ParamCheck.notNull(name, "name");
        this.closeElementIfStarted();
        char firstChar = name.charAt(0);
        if ((firstChar == 's' || firstChar == 'S') && ("script".equalsIgnoreCase(name) || "style".equalsIgnoreCase(name))) {
            this.avoidEscape = true;
        }
        this.doWrite("<");
        this.doWrite(name);
        this.elementStarted = name;
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        this.checkIfWriterClosed();
        ParamCheck.notNull(name, "name");
        if (this.elementStarted == null) {
            String msg = "There is no started element to add an attribute.";
            throw new IllegalStateException(msg);
        }
        if (value == null) {
            this.doWrite(" ");
            this.doWrite(name);
            this.doWrite("=\"");
            this.doWrite(name);
            this.doWrite("\"");
        } else {
            this.doWrite(" ");
            this.doWrite(name);
            this.doWrite("=\"");
            this.doWrite(HtmlResponseWriterUtil.encode(value.toString()));
            this.doWrite("\"");
        }
    }

    public void endElement(String name) throws IOException {
        this.checkIfWriterClosed();
        ParamCheck.notNull(name, "name");
        this.closeElementIfStarted();
        this.avoidEscape = false;
        if (!HtmlResponseWriterUtil.isEmptyTag(name)) {
            this.doWrite("</");
            this.doWrite(name);
            this.doWrite(">");
        }
    }

    public void endDocument() throws IOException {
        this.checkIfWriterClosed();
        this.closeElementIfStarted();
    }

    public void writeText(Object text, String property) throws IOException {
        this.checkIfWriterClosed();
        ParamCheck.notNull(text, "text");
        this.closeElementIfStarted();
        if (this.avoidEscape) {
            this.doWrite(text.toString());
        } else {
            this.doWrite(HtmlResponseWriterUtil.encode(text.toString()));
        }
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.checkIfWriterClosed();
        ParamCheck.notNull(text, "text");
        this.closeElementIfStarted();
        if (this.avoidEscape) {
            this.doWrite(text, off, len);
        } else {
            char[] content = new char[len];
            System.arraycopy(text, off, content, 0, len);
            StringBuffer buffer = new StringBuffer();
            buffer.append(HtmlResponseWriterUtil.encode(new String(content)));
            char[] encoded = buffer.toString().toCharArray();
            this.write(encoded);
        }
    }

    public void writeComment(Object comment) throws IOException {
        this.checkIfWriterClosed();
        ParamCheck.notNull(comment, "comment");
        this.closeElementIfStarted();
        this.doWrite("<!-- ");
        this.doWrite(HtmlResponseWriterUtil.encode(comment.toString()));
        this.doWrite(" -->");
    }

    public void writeNBSP() throws IOException {
        this.checkIfWriterClosed();
        this.closeElementIfStarted();
        this.doWrite("&nbsp;");
    }

    public void startDocument() throws IOException {
        this.checkIfWriterClosed();
    }

    public void closeElementIfStarted() {
        if (this.elementStarted != null) {
            if (HtmlResponseWriterUtil.isEmptyTag(this.elementStarted)) {
                this.doWrite(" />");
            } else {
                this.doWrite(">");
            }
            this.elementStarted = null;
        }
    }

    protected void doWrite(String content) {
        this.append(content);
    }

    private void doWrite(char[] cbuf, int off, int len) {
        this.append(String.valueOf(cbuf, off, len));
    }

    private static String getCompoundName(List allNames) {
        Assert.isTrue(allNames.size() > 0);
        String result = "." + (String)allNames.get(0);
        int i = 1;
        while (i < allNames.size()) {
            result = String.valueOf(result) + ", ." + (String)allNames.get(i);
            ++i;
        }
        return result;
    }

    private static String createClassName(String key) {
        return CLASS_PREFIX + Integer.toHexString(key.hashCode());
    }

    private void checkIfWriterClosed() throws IOException {
        if (this.closed) {
            String msg = "Operation is not allowed since the writer was closed.";
            throw new IOException(msg);
        }
    }
}

