/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import org.eclipse.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rwt.internal.lifecycle.ISessionShutdownAdapter;
import org.eclipse.rwt.internal.lifecycle.IUIThreadHolder;
import org.eclipse.rwt.internal.lifecycle.RWTLifeCycle;
import org.eclipse.rwt.internal.lifecycle.UICallBackServiceHandler;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.ServiceContext;
import org.eclipse.rwt.internal.service.ServiceStateInfo;
import org.eclipse.rwt.internal.service.ServletLog;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.widgets.Display;

final class UIThread
extends Thread
implements IUIThreadHolder,
ISessionShutdownAdapter {
    private ServiceContext serviceContext;
    private ISessionStore sessionStore;
    private Runnable shutdownCallback;
    private boolean uiThreadTerminating;

    public UIThread(Runnable runnable) {
        super(runnable);
    }

    public void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public void updateServiceContext() {
        if (ContextProvider.hasContext()) {
            ContextProvider.releaseContextHolder();
        }
        ContextProvider.setContext(this.serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchThread() throws InterruptedException {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            if (!this.getThread().isAlive()) {
                String msg = "Thread '" + Thread.currentThread() + "' is waiting for already terminated UIThread";
                RuntimeException e = new RuntimeException(msg);
                ServletLog.log("", e);
            }
            lock.notifyAll();
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                if (this.uiThreadTerminating) {
                    this.updateServiceContext();
                    CurrentPhase.set(PhaseId.PROCESS_ACTION);
                    this.uiThreadTerminating = false;
                }
                throw e;
            }
        }
    }

    public void run() {
        super.run();
    }

    public void terminateThread() {
        ServiceContext serviceContext = this.createServiceContext();
        this.setServiceContext(serviceContext);
        this.uiThreadTerminating = true;
        this.getThread().interrupt();
        try {
            this.getThread().join();
        }
        catch (InterruptedException e) {
            String msg = "Received InterruptedException while terminating UIThread";
            ServletLog.log(msg, e);
        }
        this.uiThreadTerminating = false;
    }

    public Thread getThread() {
        return this;
    }

    public Object getLock() {
        return this;
    }

    public void setSessionStore(ISessionStore sessionStore) {
        this.sessionStore = sessionStore;
    }

    public void setShutdownCallback(Runnable shutdownCallback) {
        this.shutdownCallback = shutdownCallback;
    }

    public void interceptShutdown() {
        this.terminateThread();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processShutdown() {
        this.updateServiceContext();
        try {
            CurrentPhase.set(PhaseId.PROCESS_ACTION);
            Display display = RWTLifeCycle.getSessionDisplay();
            if (display != null) {
                display.dispose();
            }
            this.shutdownCallback.run();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            ContextProvider.disposeContext();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        ContextProvider.disposeContext();
    }

    private ServiceContext createServiceContext() {
        ServiceContext result = UICallBackServiceHandler.getFakeContext(this.sessionStore);
        result.setStateInfo(new ServiceStateInfo());
        return result;
    }
}

