/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.branding.BrandingUtil;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriter;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.service.RWTStartupPageConfigurer;
import org.eclipse.rwt.internal.service.TemplateHolder;
import org.eclipse.rwt.internal.theme.QxImage;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.SimpleSelector;
import org.eclipse.rwt.internal.theme.ThemeUtil;
import org.eclipse.rwt.internal.util.EntitiesUtil;

public final class BrowserSurvey {
    public static IStartupPageConfigurer configurer = new RWTStartupPageConfigurer();

    static void sendBrowserSurvey() throws IOException {
        if (configurer.isModifiedSince()) {
            BrowserSurvey.render();
        } else {
            AbstractBranding branding = BrandingUtil.findBranding();
            if (branding.getThemeId() != null) {
                ThemeUtil.setCurrentThemeId(branding.getThemeId());
            }
        }
    }

    private static String getBgImage() {
        QxImage image;
        String resourceName;
        String result = "";
        QxType cssValue = ThemeUtil.getCssValue("Display", "background-image", SimpleSelector.DEFAULT);
        if (cssValue instanceof QxImage && (resourceName = (image = (QxImage)cssValue).getResourceName()) != null) {
            result = RWT.getResourceManager().getLocation(resourceName);
        }
        return result;
    }

    public static String getSerlvetName() {
        String result = ContextProvider.getRequest().getServletPath();
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    private static void render() throws IOException {
        ContextProvider.getResponse().setContentType("text/html");
        TemplateHolder template = configurer.getTemplate();
        template.replace(TemplateHolder.VAR_BACKGROUND_IMAGE, BrowserSurvey.getBgImage());
        template.replace(TemplateHolder.VAR_SERVLET, BrowserSurvey.getSerlvetName());
        template.replace(TemplateHolder.VAR_ENTRY_POINT, EntitiesUtil.encodeHTMLEntities(BrowserSurvey.getEntryPoint()));
        String[] tokens = template.getTokens();
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i] != null) {
                BrowserSurvey.getResponseWriter().append(tokens[i]);
            }
            ++i;
        }
    }

    private static String getEntryPoint() {
        HttpServletRequest request = ContextProvider.getRequest();
        String result = request.getParameter("startup");
        if (result == null) {
            result = "default";
        }
        return result;
    }

    private static HtmlResponseWriter getResponseWriter() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        return stateInfo.getResponseWriter();
    }

    public static interface IStartupPageConfigurer {
        public TemplateHolder getTemplate() throws IOException;

        public boolean isModifiedSince();
    }
}

