/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.ConfigurationReader;
import org.eclipse.rwt.internal.IConfiguration;
import org.eclipse.rwt.internal.IInitialization;
import org.eclipse.rwt.internal.resources.JsConcatenator;
import org.eclipse.rwt.internal.resources.ResourceManager;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.rwt.service.IServiceHandler;

public class JSLibraryServiceHandler
implements IServiceHandler {
    public static final String HANDLER_ID;
    static final String EXPIRES_NEVER = "Sun, 17 Jan 2038 19:14:07 GMT";
    private static final String REQUEST_PATTERN = "{0}?{1}={2}&hash={3}";
    private static String hashCode;
    private static byte[] unCompressed;
    private static byte[] compressed;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.service.JSLibraryServiceHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HANDLER_ID = clazz.getName();
    }

    public static String getRequestURL() throws IOException {
        JSLibraryServiceHandler.initializeOutput();
        Object[] param = new Object[]{RWT.getRequest().getServletPath().substring(1), "custom_service_handler", HANDLER_ID, hashCode};
        return MessageFormat.format(REQUEST_PATTERN, param);
    }

    public void service() throws IOException, ServletException {
        JSLibraryServiceHandler.initializeOutput();
        HttpServletResponse response = RWT.getResponse();
        response.setHeader("Content-Type", "text/javascript");
        response.setHeader("Expires", EXPIRES_NEVER);
        response.setCharacterEncoding("UTF-8");
        if (JSLibraryServiceHandler.isAcceptEncoding() && JSLibraryServiceHandler.getInitProps().isCompression()) {
            JSLibraryServiceHandler.writeCompressedOutput();
        } else {
            JSLibraryServiceHandler.writeUnCompressedOutput();
        }
    }

    private static void writeCompressedOutput() throws IOException {
        RWT.getResponse().setHeader("Content-Encoding", "gzip");
        HttpServletResponse response = RWT.getResponse();
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        JSLibraryServiceHandler.write(out, compressed);
    }

    private static void writeUnCompressedOutput() throws IOException {
        HttpServletResponse response = RWT.getResponse();
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        JSLibraryServiceHandler.write(out, unCompressed);
    }

    private static void write(OutputStream out, byte[] content) throws IOException {
        int i = 0;
        while (i < content.length) {
            out.write(content[i]);
            ++i;
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeOutput() throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.service.JSLibraryServiceHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (unCompressed == null) {
                String content = JSLibraryServiceHandler.getJsConcatenator().getContent();
                unCompressed = content.getBytes("UTF-8");
                hashCode = "H" + content.hashCode();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzipStream = new GZIPOutputStream(baos);
                JSLibraryServiceHandler.write(gzipStream, unCompressed);
                gzipStream.close();
                compressed = baos.toByteArray();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static boolean isAcceptEncoding() {
        String encodings = RWT.getRequest().getHeader("Accept-Encoding");
        return encodings != null && encodings.indexOf("gzip") != -1;
    }

    private static IInitialization getInitProps() {
        IConfiguration configuration = ConfigurationReader.getConfiguration();
        return configuration.getInitialization();
    }

    private static JsConcatenator getJsConcatenator() {
        IResourceManager manager = ResourceManager.getInstance();
        Adaptable adaptable = (Adaptable)((Object)manager);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rwt.internal.resources.JsConcatenator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = adaptable.getAdapter(clazz);
        return (JsConcatenator)adapter;
    }
}

