/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.internal.RWTMessages;
import org.eclipse.rwt.internal.browser.Browser;
import org.eclipse.rwt.internal.browser.BrowserLoader;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriter;
import org.eclipse.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rwt.internal.lifecycle.RWTRequestVersionControl;
import org.eclipse.rwt.internal.service.AbstractServiceHandler;
import org.eclipse.rwt.internal.service.BrowserSurvey;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.service.RequestParameterBuffer;
import org.eclipse.rwt.internal.service.ServiceStateInfo;
import org.eclipse.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rwt.service.ISessionStore;

public class LifeCycleServiceHandler
extends AbstractServiceHandler {
    private static final String PATTERN_RELOAD = "qx.core.Init.getInstance().getApplication().reload( \"{0}\" )";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service() throws IOException, ServletException {
        ISessionStore iSessionStore = ContextProvider.getSession();
        synchronized (iSessionStore) {
            this.synchronizedService();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void synchronizedService() throws ServletException, IOException {
        LifeCycleServiceHandler.initializeStateInfo();
        RWTRequestVersionControl.beforeService();
        try {
            if (RWTRequestVersionControl.isValid() || LifeCycleServiceHandler.isSessionRestart() || ContextProvider.getRequest().getSession().isNew()) {
                LifeCycleServiceHandler.runLifeCycle();
            } else {
                LifeCycleServiceHandler.handleInvalidRequestCounter();
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            RWTRequestVersionControl.afterService();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        RWTRequestVersionControl.afterService();
    }

    private static void runLifeCycle() throws ServletException, IOException {
        LifeCycleServiceHandler.checkRequest();
        LifeCycleServiceHandler.detectBrowser();
        if (LifeCycleServiceHandler.isBrowserDetected()) {
            RequestParameterBuffer.merge();
            LifeCycle lifeCycle = (LifeCycle)LifeCycleFactory.getLifeCycle();
            lifeCycle.execute();
        } else {
            Map parameters = ContextProvider.getRequest().getParameterMap();
            RequestParameterBuffer.store(parameters);
            BrowserSurvey.sendBrowserSurvey();
        }
        LifeCycleServiceHandler.writeOutput();
    }

    private static boolean isSessionRestart() {
        HttpServletRequest request = LifeCycleServiceHandler.getRequest();
        boolean startup = request.getParameter("startup") != null;
        String uiRoot = request.getParameter("uiRoot");
        HttpSession session = request.getSession();
        return !session.isNew() && !startup && uiRoot == null || startup && LifeCycleServiceHandler.isBrowserDetected();
    }

    private static void initializeStateInfo() {
        if (ContextProvider.getStateInfo() == null) {
            ServiceStateInfo stateInfo = new ServiceStateInfo();
            ContextProvider.getContext().setStateInfo(stateInfo);
        }
        if (ContextProvider.getStateInfo().getResponseWriter() == null) {
            HtmlResponseWriter htmlResponseWriter = new HtmlResponseWriter();
            ContextProvider.getStateInfo().setResponseWriter(htmlResponseWriter);
        }
    }

    private static void handleInvalidRequestCounter() throws IOException {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        HtmlResponseWriter out = stateInfo.getResponseWriter();
        String message = RWTMessages.getMessage("RWT_MultipleInstancesError");
        Object[] args = new Object[]{message};
        out.write(MessageFormat.format(PATTERN_RELOAD, args));
        HttpServletResponse response = ContextProvider.getResponse();
        response.setContentType("text/javascript; charset=UTF-8");
        LifeCycleServiceHandler.writeOutput();
    }

    private static boolean isBrowserDetected() {
        return LifeCycleServiceHandler.getBrowser() != null;
    }

    private static Browser getBrowser() {
        String id = "com_w4t_detected_session_browser";
        return (Browser)ContextProvider.getSession().getAttribute(id);
    }

    private static void detectBrowser() {
        if (!LifeCycleServiceHandler.isBrowserDetected() && LifeCycleServiceHandler.getRequest().getParameter("w4t_scriptEnabled") != null && LifeCycleServiceHandler.getRequest().getParameter("w4t_ajaxEnabled") != null) {
            Browser browser = BrowserLoader.load();
            String id = "com_w4t_detected_session_browser";
            ContextProvider.getSession().setAttribute(id, browser);
        }
        if (LifeCycleServiceHandler.isBrowserDetected()) {
            ContextProvider.getStateInfo().setDetectedBrowser(LifeCycleServiceHandler.getBrowser());
        }
    }

    private static void checkRequest() {
        if (LifeCycleServiceHandler.isSessionRestart()) {
            LifeCycleServiceHandler.clearSession(LifeCycleServiceHandler.getRequest().getSession());
        }
    }

    private static void clearSession(HttpSession session) {
        Enumeration keys = session.getAttributeNames();
        ArrayList keyBuffer = new ArrayList();
        while (keys.hasMoreElements()) {
            keyBuffer.add(keys.nextElement());
        }
        Object[] attributeNames = keyBuffer.toArray();
        int i = 0;
        while (i < attributeNames.length) {
            String idSessionStore = SessionStoreImpl.ID_SESSION_STORE;
            if (!idSessionStore.equals(attributeNames[i])) {
                session.removeAttribute((String)attributeNames[i]);
            } else {
                SessionStoreImpl sessionStore = (SessionStoreImpl)session.getAttribute(idSessionStore);
                sessionStore.valueUnbound(null);
                sessionStore.valueBound(null);
                sessionStore.setAttribute(SessionSingletonBase.LOCK, new Object());
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeOutput() throws IOException {
        if (ContextProvider.getContext().isDisposed()) return;
        HtmlResponseWriter content = ContextProvider.getStateInfo().getResponseWriter();
        PrintWriter out = LifeCycleServiceHandler.getOutputWriter();
        try {
            int i = 0;
            while (true) {
                if (i >= content.getHeadSize()) break;
                out.print(content.getHeadToken(i));
                ++i;
            }
            i = 0;
            while (true) {
                if (i >= content.getBodySize()) {
                    i = 0;
                    break;
                }
                out.print(content.getBodyToken(i));
                ++i;
            }
            while (i < content.getFootSize()) {
                out.print(content.getFootToken(i));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            out.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
            out.close();
            return;
        }
    }
}

