/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import javax.servlet.http.Cookie;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.rwt.service.ISettingStore;
import org.eclipse.rwt.service.ISettingStoreFactory;

public final class SettingStoreManager {
    private static final String COOKIE_NAME = "settingStore";
    private static final int COOKIE_MAX_AGE_SEC = 7776000;
    private static long last = System.currentTimeMillis();
    private static int instanceCount;
    private static ISettingStoreFactory factory;

    static {
        factory = null;
    }

    public static synchronized ISettingStore getStore() {
        String storeId;
        ISessionStore session = ContextProvider.getSession();
        ISettingStore result = (ISettingStore)session.getAttribute(storeId = SettingStoreManager.getStoreId());
        if (result == null) {
            result = factory.createSettingStore(storeId);
            session.setAttribute(storeId, result);
        }
        return result;
    }

    public static synchronized void register(ISettingStoreFactory factory) {
        ParamCheck.notNull(factory, "factory");
        if (factory != null && SettingStoreManager.factory != null) {
            String msg = "There is already an ISettingStoreFactory registered.";
            throw new IllegalStateException(msg);
        }
        SettingStoreManager.factory = factory;
    }

    public static synchronized boolean hasFactory() {
        return factory != null;
    }

    private static synchronized String createUniqueStoreId() {
        long now = System.currentTimeMillis();
        if (last == now) {
            ++instanceCount;
        } else {
            last = now;
            instanceCount = 0;
        }
        return String.valueOf(String.valueOf(now)) + "_" + String.valueOf(instanceCount);
    }

    private static String getStoreId() {
        ISessionStore session = ContextProvider.getSession();
        String result = (String)session.getAttribute(COOKIE_NAME);
        if (result == null) {
            result = SettingStoreManager.getStoreIdFromCookie();
            if (result == null) {
                result = SettingStoreManager.createUniqueStoreId();
            }
            Cookie cookie = new Cookie(COOKIE_NAME, result);
            cookie.setSecure(RWT.getRequest().isSecure());
            cookie.setMaxAge(7776000);
            ContextProvider.getResponse().addCookie(cookie);
            session.setAttribute(COOKIE_NAME, result);
        }
        return result;
    }

    private static String getStoreIdFromCookie() {
        String result = null;
        Cookie[] cookies = ContextProvider.getRequest().getCookies();
        if (cookies != null) {
            int i = 0;
            while (result == null && i < cookies.length) {
                String value;
                Cookie cookie = cookies[i];
                if (COOKIE_NAME.equals(cookie.getName()) && SettingStoreManager.isValidCookieValue(value = cookie.getValue())) {
                    result = value;
                }
                ++i;
            }
        }
        return result;
    }

    static boolean isValidCookieValue(String value) {
        boolean result = false;
        try {
            int index = value.indexOf(95);
            if (index != -1) {
                Long.parseLong(value.substring(0, index));
                Integer.parseInt(value.substring(index + 1));
                result = true;
            }
        }
        catch (Exception exception) {}
        return result;
    }
}

