/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import org.eclipse.rwt.internal.theme.QxBoolean;
import org.eclipse.rwt.internal.theme.QxIdentifier;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.ThemeCssValuesMap;
import org.eclipse.rwt.internal.theme.ThemeableWidget;
import org.eclipse.rwt.internal.theme.css.StyleSheet;

public final class Theme {
    private final String jsId;
    private final String name;
    private ThemeCssValuesMap valuesMap;

    public Theme(String jsId, String name, StyleSheet styleSheet, ThemeableWidget[] themeableWidgets) {
        if (jsId == null) {
            throw new NullPointerException("jsId");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (styleSheet == null) {
            throw new NullPointerException("stylesheet");
        }
        if (themeableWidgets == null) {
            throw new NullPointerException("themeableWidgets");
        }
        this.jsId = jsId;
        this.name = name;
        this.valuesMap = new ThemeCssValuesMap(styleSheet, themeableWidgets);
    }

    public String getJsId() {
        return this.jsId;
    }

    public String getName() {
        return this.name;
    }

    public ThemeCssValuesMap getValuesMap() {
        return this.valuesMap;
    }

    public static String createCssKey(QxType value) {
        String result = value instanceof QxIdentifier || value instanceof QxBoolean ? value.toDefaultString() : Integer.toHexString(value.hashCode());
        return result;
    }
}

