/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme.css;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.css.parser.ParseException;
import org.apache.batik.css.parser.Parser;
import org.eclipse.rwt.internal.theme.ResourceLoader;
import org.eclipse.rwt.internal.theme.css.ConditionFactoryImpl;
import org.eclipse.rwt.internal.theme.css.DocumentHandlerImpl;
import org.eclipse.rwt.internal.theme.css.SelectorFactoryImpl;
import org.eclipse.rwt.internal.theme.css.StyleSheet;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;

public class CssFileReader {
    private static final String CSS_ENCODING = "UTF-8";
    private List problems;
    private org.w3c.css.sac.Parser parser;

    public CssFileReader() {
        try {
            this.parser = new Parser();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate CSS parser", e);
        }
        this.problems = new ArrayList();
    }

    public StyleSheet parse(InputStream inputStream, String uri, ResourceLoader loader) throws CSSException, IOException {
        InputSource source = new InputSource();
        source.setByteStream(inputStream);
        source.setEncoding(CSS_ENCODING);
        source.setURI(uri);
        this.parser.setConditionFactory(new ConditionFactoryImpl(this));
        this.parser.setSelectorFactory(new SelectorFactoryImpl(this));
        DocumentHandlerImpl documentHandler = new DocumentHandlerImpl(this, loader);
        this.parser.setDocumentHandler(documentHandler);
        this.parser.setErrorHandler(new ErrorHandlerImpl(this));
        try {
            this.parser.parseStyleSheet(source);
        }
        catch (ParseException e) {
            throw new CSSException(e);
        }
        return documentHandler.getStyleSheet();
    }

    public CSSException[] getProblems() {
        CSSException[] result = new CSSException[this.problems.size()];
        this.problems.toArray(result);
        return result;
    }

    void addProblem(CSSException exception) {
        System.err.println(exception);
        this.problems.add(exception);
    }

    private static String createProblemDescription(String type, CSSParseException exception) {
        String pattern = "{0}: {1} in {2} at pos [{3}:{4}]";
        Object[] arguments = new Object[]{type, exception.getMessage(), exception.getURI(), String.valueOf(exception.getLineNumber()), String.valueOf(exception.getColumnNumber())};
        return MessageFormat.format(pattern, arguments);
    }

    private static class ErrorHandlerImpl
    implements ErrorHandler {
        private final List problems;

        public ErrorHandlerImpl(CssFileReader reader) {
            this.problems = reader.problems;
        }

        public void warning(CSSParseException exception) throws CSSException {
            String problem = CssFileReader.createProblemDescription("WARNING: ", exception);
            System.err.println(problem);
            this.problems.add(exception);
        }

        public void error(CSSParseException exception) throws CSSException {
            String problem = CssFileReader.createProblemDescription("ERROR: ", exception);
            System.err.println(problem);
            this.problems.add(exception);
        }

        public void fatalError(CSSParseException exception) throws CSSException {
            String problem = CssFileReader.createProblemDescription("FATAL ERROR: ", exception);
            System.err.println(problem);
            this.problems.add(exception);
            throw exception;
        }
    }
}

