/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.events;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class TypedEvent
extends org.eclipse.rwt.internal.events.Event {
    private static final long serialVersionUID = 1L;
    private static final String ATTR_SCHEDULED_EVENT_LIST;
    private static final Class[] EVENT_ORDER;
    public Display display;
    public Widget widget;
    public Object data;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.events.TypedEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ATTR_SCHEDULED_EVENT_LIST = String.valueOf(clazz.getName()) + "_scheduledEventList";
        Class[] classArray = new Class[22];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.swt.events.ControlEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.swt.internal.events.ActivateEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.swt.internal.events.ShowEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.swt.events.DisposeEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz5;
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.swt.internal.events.SetDataEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[4] = clazz6;
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.eclipse.swt.events.FocusEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[5] = clazz7;
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("org.eclipse.swt.events.MouseEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[6] = clazz8;
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("org.eclipse.swt.events.VerifyEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[7] = clazz9;
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("org.eclipse.swt.events.ModifyEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[8] = clazz10;
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("org.eclipse.swt.events.TreeEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[9] = clazz11;
        Class<?> clazz12 = class$11;
        if (clazz12 == null) {
            try {
                clazz12 = class$11 = Class.forName("org.eclipse.swt.custom.CTabFolderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[10] = clazz12;
        Class<?> clazz13 = class$12;
        if (clazz13 == null) {
            try {
                clazz13 = class$12 = Class.forName("org.eclipse.swt.events.ExpandEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[11] = clazz13;
        Class<?> clazz14 = class$13;
        if (clazz14 == null) {
            try {
                clazz14 = class$13 = Class.forName("org.eclipse.swt.internal.events.DeselectionEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[12] = clazz14;
        Class<?> clazz15 = class$14;
        if (clazz15 == null) {
            try {
                clazz15 = class$14 = Class.forName("org.eclipse.swt.events.SelectionEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[13] = clazz15;
        Class<?> clazz16 = class$15;
        if (clazz16 == null) {
            try {
                clazz16 = class$15 = Class.forName("org.eclipse.swt.browser.LocationEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[14] = clazz16;
        Class<?> clazz17 = class$16;
        if (clazz17 == null) {
            try {
                clazz17 = class$16 = Class.forName("org.eclipse.swt.events.ShellEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[15] = clazz17;
        Class<?> clazz18 = class$17;
        if (clazz18 == null) {
            try {
                clazz18 = class$17 = Class.forName("org.eclipse.swt.events.MenuEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[16] = clazz18;
        Class<?> clazz19 = class$18;
        if (clazz19 == null) {
            try {
                clazz19 = class$18 = Class.forName("org.eclipse.swt.events.KeyEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[17] = clazz19;
        Class<?> clazz20 = class$19;
        if (clazz20 == null) {
            try {
                clazz20 = class$19 = Class.forName("org.eclipse.swt.events.DragDetectEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[18] = clazz20;
        Class<?> clazz21 = class$20;
        if (clazz21 == null) {
            try {
                clazz21 = class$20 = Class.forName("org.eclipse.swt.dnd.DragSourceEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[19] = clazz21;
        Class<?> clazz22 = class$21;
        if (clazz22 == null) {
            try {
                clazz22 = class$21 = Class.forName("org.eclipse.swt.dnd.DropTargetEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[20] = clazz22;
        Class<?> clazz23 = class$22;
        if (clazz23 == null) {
            try {
                clazz23 = class$22 = Class.forName("org.eclipse.swt.events.HelpEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[21] = clazz23;
        EVENT_ORDER = classArray;
    }

    public TypedEvent(Event e) {
        super(e.widget, e.type);
        this.display = e.display;
        this.widget = e.widget;
        this.data = e.data;
    }

    public TypedEvent(Object source, int id) {
        super(source, id);
        this.widget = (Widget)source;
        this.display = this.widget.getDisplay();
    }

    public Object getSource() {
        return super.getSource();
    }

    public final void processEvent() {
        PhaseId currentPhase = CurrentPhase.get();
        if (currentPhase != null) {
            if (PhaseId.PREPARE_UI_ROOT.equals(currentPhase) || PhaseId.PROCESS_ACTION.equals(currentPhase)) {
                if (!this.isFiltered(this.processFilters())) {
                    super.processEvent();
                }
            } else {
                TypedEvent.addToScheduledEvents(this);
            }
        }
    }

    public static void processScheduledEvents() {
        TypedEvent[] events = TypedEvent.getScheduledEvents();
        int i = 0;
        while (i < events.length) {
            TypedEvent event = events[i];
            if (event.allowProcessing()) {
                event.processEvent();
            }
            ++i;
        }
        TypedEvent.clearScheduledEventList();
    }

    public static boolean executeNext() {
        boolean result = false;
        TypedEvent[] events = TypedEvent.getScheduledEvents();
        while (!result && events.length > 0) {
            TypedEvent event = events[0];
            TypedEvent.getScheduledEventList().remove(event);
            if (event.allowProcessing()) {
                event.processEvent();
                result = true;
            }
            events = TypedEvent.getScheduledEvents();
        }
        return result;
    }

    private Event processFilters() {
        IDisplayAdapter.IFilterEntry[] filters = this.getFilterEntries();
        Event result = new Event();
        result.widget = this.widget;
        result.type = this.getID();
        int i = 0;
        while (!this.isFiltered(result) && i < filters.length) {
            if (filters[i].getType() == result.type) {
                filters[i].getListener().handleEvent(result);
            }
            ++i;
        }
        return result;
    }

    private boolean isFiltered(Event event) {
        return event.type == 0;
    }

    private IDisplayAdapter.IFilterEntry[] getFilterEntries() {
        Display display = Display.getCurrent();
        Class<?> clazz = class$23;
        if (clazz == null) {
            try {
                clazz = class$23 = Class.forName("org.eclipse.swt.internal.widgets.IDisplayAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDisplayAdapter adapter = (IDisplayAdapter)display.getAdapter(clazz);
        return adapter.getFilters();
    }

    private static void addToScheduledEvents(TypedEvent event) {
        TypedEvent.getScheduledEventList().add(event);
    }

    private static TypedEvent[] getScheduledEvents() {
        List list = TypedEvent.getScheduledEventList();
        ArrayList sortedEvents = new ArrayList();
        int i = 0;
        while (i < EVENT_ORDER.length) {
            int k = 0;
            while (k < list.size()) {
                Object event = list.get(k);
                if (EVENT_ORDER[i].equals(event.getClass())) {
                    sortedEvents.add(event);
                }
                ++k;
            }
            ++i;
        }
        TypedEvent[] result = new TypedEvent[sortedEvents.size()];
        sortedEvents.toArray(result);
        return result;
    }

    private static List getScheduledEventList() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        ArrayList result = (ArrayList)stateInfo.getAttribute(ATTR_SCHEDULED_EVENT_LIST);
        if (result == null) {
            result = new ArrayList();
            stateInfo.setAttribute(ATTR_SCHEDULED_EVENT_LIST, result);
        }
        return result;
    }

    private static void clearScheduledEventList() {
        TypedEvent.getScheduledEventList().clear();
    }

    protected boolean allowProcessing() {
        String msg = "Derived classes must override allowProcessing.";
        throw new UnsupportedOperationException(msg);
    }

    protected void dispatchToObserver(Object listener) {
        String msg = "Derived classes must override dispatchToObserver.";
        throw new UnsupportedOperationException(msg);
    }

    protected Class getListenerType() {
        String msg = "Derived classes must override getListenerType.";
        throw new UnsupportedOperationException(msg);
    }

    public String toString() {
        return String.valueOf(this.getName()) + "{" + this.widget + " data=" + this.data + "}";
    }

    private String getName() {
        String result = this.getClass().getName();
        int index = result.lastIndexOf(46);
        if (index != -1) {
            result = result.substring(index + 1, result.length());
        }
        return result;
    }
}

