/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.graphics.DefaultTextSizeStorage;
import org.eclipse.swt.internal.graphics.ITextSizeStorage;
import org.eclipse.swt.internal.graphics.TextSizeDeterminationFacade;
import org.eclipse.swt.internal.graphics.TextSizeStorageRegistry;
import org.eclipse.swt.widgets.Display;

final class TextSizeProbeStore
extends SessionSingletonBase {
    static String DEFAULT_PROBE;
    private static final String PROBE_REQUESTS;
    private static Map probes;
    private Map probeResults = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        StringBuffer result = new StringBuffer();
        int i = 33;
        while (i < 122) {
            if (i != 34 && i != 39) {
                result.append((char)i);
            }
            ++i;
        }
        DEFAULT_PROBE = result.toString();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.graphics.TextSizeProbeStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PROBE_REQUESTS = String.valueOf(clazz.getName()) + ".ProbeRequests";
        probes = new HashMap();
    }

    private TextSizeProbeStore() {
    }

    static TextSizeProbeStore getInstance() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.graphics.TextSizeProbeStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TextSizeProbeStore)TextSizeProbeStore.getInstance(clazz);
    }

    IProbeResult getProbeResult(FontData fontData) {
        return (IProbeResult)this.probeResults.get(fontData);
    }

    boolean containsProbeResult(FontData fontData) {
        return this.getProbeResult(fontData) != null;
    }

    IProbeResult createProbeResult(final IProbe probe, final Point size) {
        FontData fontData = probe.getFontData();
        IProbeResult result = new IProbeResult(){
            private float avgCharWidth;

            public IProbe getProbe() {
                return probe;
            }

            public Point getSize() {
                return size;
            }

            public float getAvgCharWidth() {
                if (this.avgCharWidth == 0.0f) {
                    BigDecimal width = new BigDecimal((double)this.getSize().x);
                    BigDecimal charCount = new BigDecimal((double)this.getProbe().getString().length());
                    int roundingMethod = 4;
                    this.avgCharWidth = width.divide(charCount, 2, roundingMethod).floatValue();
                }
                return this.avgCharWidth;
            }
        };
        this.probeResults.put(fontData, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IProbe[] getProbeList() {
        IProbe[] result;
        Map map = probes;
        synchronized (map) {
            if (probes.isEmpty()) {
                FontData[] fontList = TextSizeStorageRegistry.obtain().getFontList();
                int i = 0;
                while (i < fontList.length) {
                    TextSizeProbeStore.createProbe(fontList[i], TextSizeProbeStore.getProbeString(fontList[i]));
                    ++i;
                }
            }
            result = new IProbe[probes.size()];
            probes.values().toArray(result);
        }
        return result;
    }

    private static String getProbeString(FontData fontData) {
        return DEFAULT_PROBE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IProbe getProbe(FontData font) {
        IProbe result;
        Map map = probes;
        synchronized (map) {
            result = (IProbe)probes.get(font);
        }
        return result;
    }

    static boolean containsProbe(FontData fontData) {
        return TextSizeProbeStore.getProbe(fontData) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IProbe createProbe(FontData fontData, String probeText) {
        ProbeImpl result = new ProbeImpl(probeText, fontData);
        Map map = probes;
        synchronized (map) {
            probes.put(fontData, result);
        }
        TextSizeStorageRegistry.obtain().storeFont(fontData);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        Map map = probes;
        synchronized (map) {
            ITextSizeStorage registry = TextSizeStorageRegistry.obtain();
            if (registry instanceof DefaultTextSizeStorage) {
                ((DefaultTextSizeStorage)registry).resetFontList();
            }
            probes.clear();
        }
    }

    static void addProbeRequest(FontData font) {
        IProbe probe = TextSizeProbeStore.getProbe(font);
        if (probe == null) {
            FontData fontData = font;
            probe = TextSizeProbeStore.createProbe(fontData, TextSizeProbeStore.getProbeString(fontData));
        }
        TextSizeProbeStore.getProbeRequestsInternal().add(probe);
    }

    static IProbe[] getProbeRequests() {
        Set probeRequests = TextSizeProbeStore.getProbeRequestsInternal();
        IProbe[] result = new IProbe[probeRequests.size()];
        probeRequests.toArray(result);
        return result;
    }

    private static String createProbeParam(IProbe probe) {
        StringBuffer result = new StringBuffer();
        Display display = Display.getCurrent();
        if (display != null) {
            result.append("[ ");
            result.append(probe.getFontData().hashCode());
            result.append(", ");
            result.append("\"");
            result.append(probe.getString());
            result.append("\", ");
            result.append(TextSizeDeterminationFacade.createFontParam(probe.getFontData()));
            result.append(" ]");
        }
        return result.toString();
    }

    private static Set getProbeRequestsInternal() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        HashSet result = (HashSet)stateInfo.getAttribute(PROBE_REQUESTS);
        if (result == null) {
            result = new HashSet();
            stateInfo.setAttribute(PROBE_REQUESTS, result);
        }
        return result;
    }

    public static interface IProbe {
        public FontData getFontData();

        public String getString();

        public String getJSProbeParam();
    }

    public static interface IProbeResult {
        public IProbe getProbe();

        public Point getSize();

        public float getAvgCharWidth();
    }

    private static final class ProbeImpl
    implements IProbe {
        private final String probeText;
        private final FontData fontData;
        private String jsProbeParam;

        private ProbeImpl(String probeText, FontData fontData) {
            this.probeText = probeText;
            this.fontData = fontData;
            this.jsProbeParam = TextSizeProbeStore.createProbeParam(this);
        }

        public FontData getFontData() {
            return this.fontData;
        }

        public String getString() {
            return this.probeText;
        }

        public String getJSProbeParam() {
            if ("".equals(this.jsProbeParam)) {
                this.jsProbeParam = TextSizeProbeStore.createProbeParam(this);
            }
            return this.jsProbeParam;
        }
    }
}

