/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.groupkit;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.internal.widgets.controlkit.ControlThemeAdapter;
import org.eclipse.swt.widgets.Group;

public final class GroupThemeAdapter
extends ControlThemeAdapter {
    public Rectangle getPadding(Group group) {
        return this.getCssBoxDimensions("Group-Frame", "padding", group);
    }

    public Rectangle getMargin(Group group) {
        return this.getCssBoxDimensions("Group-Frame", "margin", group);
    }

    public Rectangle getTrimmingSize(Group group) {
        Rectangle margin = this.getMargin(group);
        Rectangle padding = this.getPadding(group);
        int frameWidth = this.getCssBorderWidth("Group-Frame", "border", group);
        int left = margin.x + padding.x + frameWidth;
        int top = margin.y + padding.y + frameWidth;
        Font font = group.getFont();
        top = Math.max(top, TextSizeDetermination.getCharHeight(font));
        int width = margin.width + padding.width + frameWidth * 2;
        int height = margin.height + padding.height + frameWidth * 2;
        return new Rectangle(left, top, width, height);
    }

    public Rectangle getHeaderTrimmingSize(Group group) {
        Rectangle margin = this.getCssBoxDimensions("Group-Label", "margin", group);
        Rectangle padding = this.getCssBoxDimensions("Group-Label", "padding", group);
        int left = margin.x + padding.x;
        int top = margin.y + padding.y;
        int width = margin.width + padding.width;
        int height = margin.height + padding.height;
        return new Rectangle(left, top, width, height);
    }
}

