/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.internal.widgets.buttonkit.ButtonThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Button
extends Control {
    private String text = "";
    private boolean selected;
    private boolean grayed;
    private Image image;
    private boolean isDefault;
    static /* synthetic */ Class class$0;

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
    }

    void initState() {
        if ((this.style & 0xA) == 0) {
            this.state |= 0x100;
        }
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error(4);
        }
        if ((this.style & 4) == 0) {
            this.text = text;
        }
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getSelection() {
        this.checkWidget();
        boolean result = false;
        if ((this.style & 0x32) != 0) {
            result = this.selected;
        }
        return result;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) != 0) {
            this.selected = selected;
        }
    }

    public boolean getGrayed() {
        this.checkWidget();
        boolean result = false;
        if ((this.style & 0x20) != 0) {
            result = this.grayed;
        }
        return result;
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.style & 0x20) != 0) {
            this.grayed = grayed;
        }
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 4) == 0) {
            this.image = image;
        }
    }

    public int getAlignment() {
        this.checkWidget();
        int result = (this.style & 4) != 0 ? ((this.style & 0x80) != 0 ? 128 : ((this.style & 0x400) != 0 ? 1024 : ((this.style & 0x4000) != 0 ? 16384 : ((this.style & 0x20000) != 0 ? 131072 : 128)))) : ((this.style & 0x4000) != 0 ? 16384 : ((this.style & 0x1000000) != 0 ? 0x1000000 : ((this.style & 0x20000) != 0 ? 131072 : 16384)));
        return result;
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) != 0) {
                this.style &= 0xFFFDBB7F;
                this.style |= alignment & 0x24480;
            }
        } else if ((alignment & 0x1024000) != 0) {
            this.style &= 0xFEFDBFFF;
            this.style |= alignment & 0x1024000;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Class<?> clazz;
        boolean hasText;
        this.checkWidget();
        int width = 0;
        int height = 0;
        boolean hasImage = this.image != null;
        boolean bl = hasText = this.text.length() > 0;
        if (hasImage) {
            Rectangle imageBounds = this.image.getBounds();
            width = imageBounds.width;
            height = imageBounds.height;
        }
        if (hasText) {
            Point extent = TextSizeDetermination.stringExtent(this.getFont(), this.text);
            width += extent.x;
            height = Math.max(height, extent.y);
        }
        if (width == 0) {
            width = 1;
        }
        if (height == 0) {
            height = 10;
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.theme.IThemeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ButtonThemeAdapter themeAdapter = (ButtonThemeAdapter)this.getAdapter(clazz);
        if (hasText && hasImage) {
            int spacing = themeAdapter.getSpacing(this);
            width += spacing;
        }
        if ((this.style & 0x30) != 0) {
            Point checkSize = themeAdapter.getCheckSize(this);
            width += checkSize.x + themeAdapter.getCheckSpacing(this);
            height = Math.max(height, checkSize.y);
        }
        Rectangle padding = themeAdapter.getPadding(this);
        width += padding.width;
        height += padding.height;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    boolean getDefault() {
        return this.isDefault;
    }

    boolean isTabGroup() {
        return true;
    }

    String getNameText() {
        return this.getText();
    }

    private static int checkStyle(int style) {
        int result = Button.checkBits(style, 8, 4, 32, 16, 2, 0);
        if ((result & 0xA) != 0) {
            result = Button.checkBits(result, 0x1000000, 16384, 131072, 0, 0, 0);
        } else if ((result & 0x30) != 0) {
            result = Button.checkBits(result, 16384, 131072, 0x1000000, 0, 0, 0);
        } else if ((result & 4) != 0) {
            result |= 0x80000;
            result = Button.checkBits(result, 128, 1024, 16384, 131072, 0, 0);
        }
        return result;
    }
}

