/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.ActivateEvent;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.IShellAdapter;
import org.eclipse.swt.internal.widgets.shellkit.ShellThemeAdapter;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;

public class Shell
extends Decorations {
    private static final int MODE_NONE = 0;
    private static final int MODE_MAXIMIZED = 1;
    private static final int MODE_MINIMIZED = 2;
    private static final int INITIAL_SIZE_PERCENT = 60;
    private static final int MIN_WIDTH_LIMIT = 80;
    private Control lastActive;
    private IShellAdapter shellAdapter;
    private String text;
    private int alpha;
    private Button defaultButton;
    private Button saveDefault;
    private Control savedFocus;
    private int mode;
    private boolean modified;
    private int minWidth;
    private int minHeight;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private Shell(Display display, Shell parent, int style, int handle) {
        super(Shell.checkParent(parent));
        if (display != null) {
            this.display = display;
        } else {
            this.display = Display.getCurrent();
            if (this.display == null) {
                this.display = Display.getDefault();
            }
        }
        this.text = "";
        this.alpha = 255;
        this.mode = 0;
        this.style = Shell.checkStyle(style);
        this.state |= 0x10;
        this.minWidth = 80;
        this.minHeight = this.getMinHeightLimit();
        this.display.addShell(this);
        this.reskinWidget();
        this.createWidget();
        this.setInitialSize();
    }

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style, 0);
    }

    public Shell(Shell parent) {
        this(parent, 2144);
    }

    public Shell(Shell parent, int style) {
        this(parent != null ? parent.display : null, parent, style, 0);
    }

    Shell internalGetShell() {
        return this;
    }

    public Shell[] getShells() {
        this.checkWidget();
        return this.internalGetShells();
    }

    private Shell[] internalGetShells() {
        int count = 0;
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Composite shell = shells[i];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Composite shell = shells[i2];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                result[index++] = shells[i2];
            }
            ++i2;
        }
        return result;
    }

    public void setActive() {
        this.checkWidget();
        if (this.isVisible()) {
            this.display.setActiveShell(this);
        }
    }

    public void forceActive() {
        this.checkWidget();
        this.setActive();
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle bounds = this.getBounds();
        Rectangle padding = this.getPadding();
        int hTopTrim = this.getTitleBarMargin().height;
        hTopTrim += this.getTitleBarHeight();
        int border = this.getBorderWidth();
        return new Rectangle(padding.x, (hTopTrim += this.getMenuBarHeight()) + padding.y, bounds.width - padding.width - border * 2, bounds.height - hTopTrim - padding.height - border * 2);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int hTopTrim = this.getTitleBarMargin().height;
        hTopTrim += this.getTitleBarHeight();
        Rectangle padding = this.getPadding();
        int border = this.getBorderWidth();
        Rectangle rect = new Rectangle(x - padding.x - border, y - (hTopTrim += this.getMenuBarHeight()) - padding.y - border, width + padding.width + border * 2, height + hTopTrim + padding.height + border * 2);
        return rect;
    }

    private void setInitialSize() {
        int width = this.display.getBounds().width * 60 / 100;
        int height = this.display.getBounds().height * 60 / 100;
        this.bounds = new Rectangle(0, 0, width, height);
    }

    private int getMinHeightLimit() {
        int result = this.getTitleBarMargin().height;
        result += this.getTitleBarHeight();
        return result += 2 * this.getBorderWidth();
    }

    private Rectangle getMenuBounds() {
        Rectangle result = null;
        if (this.getMenuBar() != null) {
            Rectangle bounds = this.getBounds();
            int hTop = (this.style & 0x20) != 0 ? 1 : 0;
            Rectangle padding = this.getPadding();
            int border = this.getBorderWidth();
            result = new Rectangle(padding.x, (hTop += this.getTitleBarHeight()) + padding.y, bounds.width - padding.width - border * 2, this.getMenuBarHeight());
        }
        return result;
    }

    private int getTitleBarHeight() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.theme.IThemeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ShellThemeAdapter themeAdapter = (ShellThemeAdapter)this.getAdapter(clazz);
        return themeAdapter.getTitleBarHeight(this);
    }

    private Rectangle getTitleBarMargin() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.theme.IThemeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ShellThemeAdapter themeAdapter = (ShellThemeAdapter)this.getAdapter(clazz);
        return themeAdapter.getTitleBarMargin(this);
    }

    private int getMenuBarHeight() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.theme.IThemeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ShellThemeAdapter themeAdapter = (ShellThemeAdapter)this.getAdapter(clazz);
        return themeAdapter.getMenuBarHeight(this);
    }

    private Rectangle getPadding() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.theme.IThemeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ShellThemeAdapter themeAdapter = (ShellThemeAdapter)this.getAdapter(clazz);
        return themeAdapter.getPadding(this);
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    void updateMode() {
        this.mode &= 0xFFFFFFFE;
        this.mode &= 0xFFFFFFFD;
    }

    public Object getAdapter(Class adapter) {
        Object result;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IShellAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            if (this.shellAdapter == null) {
                this.shellAdapter = new IShellAdapter(){

                    public Control getActiveControl() {
                        return Shell.this.lastActive;
                    }

                    public void setActiveControl(Control control) {
                        Shell.this.setActiveControl(control);
                    }

                    public Rectangle getMenuBounds() {
                        return Shell.this.getMenuBounds();
                    }

                    public void setBounds(Rectangle bounds) {
                        Shell.this.setBounds(bounds, false);
                    }
                };
            }
            result = this.shellAdapter;
        } else {
            result = super.getAdapter(adapter);
        }
        return result;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (this.getEnabled() != enabled) {
            super.setEnabled(enabled);
            if (enabled && !this.restoreFocus()) {
                this.traverseGroup(true);
            }
        }
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        boolean wasVisible = this.getVisible();
        super.setVisible(visible);
        if (visible && !wasVisible && !this.isDisposed()) {
            this.changed(this.getChildren());
            this.layout(true, true);
        }
    }

    public void open() {
        this.checkWidget();
        this.display.setActiveShell(this);
        this.bringToTop();
        this.setVisible(true);
        if (!this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus();
        }
    }

    public void close() {
        this.checkWidget();
        ProcessActionRunner.add(new Runnable(){

            public void run() {
                ShellEvent event = new ShellEvent(Shell.this, 21);
                event.processEvent();
                if (event.doit) {
                    Shell.this.dispose();
                }
            }
        });
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            this.error(4);
        }
        this.text = text;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            if (button.getShell() != this) {
                this.error(32);
            }
        }
        this.setDefaultButton(button, true);
    }

    void setDefaultButton(Button button, boolean save) {
        if (button == null) {
            if (this.defaultButton == this.saveDefault) {
                if (save) {
                    this.saveDefault = null;
                }
                return;
            }
        } else {
            if ((button.getStyle() & 8) == 0) {
                return;
            }
            if (button == this.defaultButton) {
                return;
            }
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(false);
        }
        this.defaultButton = button;
        if (this.defaultButton == null) {
            this.defaultButton = this.saveDefault;
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(true);
        }
        if (save) {
            this.saveDefault = this.defaultButton;
        }
        if (this.saveDefault != null && this.saveDefault.isDisposed()) {
            this.saveDefault = null;
        }
    }

    public Button getDefaultButton() {
        this.checkWidget();
        return this.defaultButton;
    }

    public void setAlpha(int alpha) {
        this.checkWidget();
        this.alpha = alpha & 0xFF;
    }

    public int getAlpha() {
        this.checkWidget();
        return this.alpha;
    }

    public void setModified(boolean modified) {
        this.checkWidget();
        this.modified = modified;
    }

    public boolean getModified() {
        this.checkWidget();
        return this.modified;
    }

    public void setMinimumSize(int width, int height) {
        this.checkWidget();
        this.minWidth = Math.max(80, width);
        this.minHeight = Math.max(this.getMinHeightLimit(), height);
        Point size = this.getSize();
        int newWidth = Math.max(size.x, this.minWidth);
        int newHeight = Math.max(size.y, this.minHeight);
        if (newWidth != size.x || newHeight != size.y) {
            this.setSize(newWidth, newHeight);
        }
    }

    public void setMinimumSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setMinimumSize(size.x, size.y);
    }

    public Point getMinimumSize() {
        this.checkWidget();
        return new Point(this.minWidth, this.minHeight);
    }

    public void setBounds(Rectangle bounds) {
        int newWidth = Math.max(bounds.width, this.minWidth);
        int newHeight = Math.max(bounds.height, this.minHeight);
        super.setBounds(new Rectangle(bounds.x, bounds.y, newWidth, newHeight));
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        ShellEvent.addListener(this, listener);
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        ShellEvent.removeListener(this, listener);
    }

    void releaseChildren() {
        super.releaseChildren();
        Shell[] dialogShells = this.internalGetShells();
        int i = 0;
        while (i < dialogShells.length) {
            dialogShells[i].dispose();
            ++i;
        }
    }

    void releaseParent() {
        this.display.removeShell(this);
    }

    void setActiveControl(Control activateControl) {
        Control control = activateControl;
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive != control) {
            ActivateEvent evt;
            Control[] activate = control == null ? new Control[]{} : control.getPath();
            Control[] deactivate = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
            this.lastActive = control;
            int index = 0;
            int length = Math.min(activate.length, deactivate.length);
            while (index < length && activate[index] == deactivate[index]) {
                ++index;
            }
            int i = deactivate.length - 1;
            while (i >= index) {
                if (!deactivate[i].isDisposed()) {
                    evt = new ActivateEvent(deactivate[i], 27);
                    evt.processEvent();
                }
                --i;
            }
            i = activate.length - 1;
            while (i >= index) {
                if (!activate[i].isDisposed()) {
                    evt = new ActivateEvent(activate[i], 26);
                    evt.processEvent();
                }
                --i;
            }
        }
    }

    final void setSavedFocus(Control control) {
        this.savedFocus = control;
    }

    final Control getSavedFocus() {
        return this.savedFocus;
    }

    final void saveFocus() {
        Control control = this.display.getFocusControl();
        if (control != null && control != this && this == control.getShell()) {
            this.setSavedFocus(control);
        }
    }

    final boolean restoreFocus() {
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        boolean result = false;
        if (this.savedFocus != null && this.savedFocus.setSavedFocus()) {
            result = true;
        }
        return result;
    }

    private void bringToTop() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.swt.internal.widgets.IDisplayAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = this.display.getAdapter(clazz);
        IDisplayAdapter displayAdapter = (IDisplayAdapter)adapter;
        displayAdapter.setFocusControl(this);
        displayAdapter.invalidateFocus();
    }

    private boolean traverseGroup(boolean next) {
        boolean result = false;
        if (this.getChildren().length > 0) {
            result = this.getChildren()[0].forceFocus();
        }
        return result;
    }

    public void setMinimized(boolean minimized) {
        if (minimized) {
            this.mode |= 2;
        } else {
            if ((this.mode & 2) != 0) {
                this.setActive();
            }
            this.mode &= 0xFFFFFFFD;
        }
    }

    public void setMaximized(boolean maximized) {
        if (maximized) {
            if (this.mode != 1) {
                this.setActive();
                this.setBounds(this.display.getBounds());
            }
            this.mode |= 1;
            this.mode &= 0xFFFFFFFD;
        } else {
            this.mode &= 0xFFFFFFFE;
        }
    }

    public boolean getMinimized() {
        return (this.mode & 2) != 0;
    }

    public boolean getMaximized() {
        return this.mode == 1;
    }

    String getNameText() {
        return this.getText();
    }

    static int Decorations_checkStyle(int style) {
        int result = style;
        if ((result & 8) != 0) {
            int trim = 3312;
            result &= ~trim;
        }
        if ((result & 0x4C0) != 0) {
            result |= 0x20;
        }
        if ((result & 0x480) != 0) {
            result |= 0x40;
        }
        return result;
    }

    private static int checkStyle(int style) {
        return Shell.Decorations_checkStyle(style);
    }

    private static Shell checkParent(Shell parent) {
        if (parent != null && parent.isDisposed()) {
            SWT.error(5);
        }
        return parent;
    }

    void reskinChildren(int flags) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (shell != null) {
                shell.reskin(flags);
            }
            ++i;
        }
        super.reskinChildren(flags);
    }
}

