/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.internal.widgets.spinnerkit.SpinnerThemeAdapter;
import org.eclipse.swt.widgets.Composite;

public class Spinner
extends Composite {
    public static final int LIMIT = Integer.MAX_VALUE;
    private static final int UP_DOWN_MIN_HEIGHT = 18;
    private int digits = 0;
    private int increment = 1;
    private int maximum = 100;
    private int minimum = 0;
    private int pageIncrement = 10;
    private int selection = 0;
    private int textLimit = Integer.MAX_VALUE;
    static /* synthetic */ Class class$0;

    public Spinner(Composite parent, int style) {
        super(parent, Spinner.checkStyle(style));
    }

    void initState() {
        this.state &= 0xFFFFFEFF;
    }

    public int getDigits() {
        this.checkWidget();
        return this.digits;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value >= 1) {
            this.increment = value;
        }
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value >= 0 && value <= this.maximum) {
            this.minimum = value;
            if (this.selection < this.minimum) {
                this.selection = this.minimum;
            }
        }
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value >= 0 && value >= this.minimum) {
            this.maximum = value;
            if (this.selection > this.maximum) {
                this.selection = this.maximum;
            }
        }
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value >= 1) {
            this.pageIncrement = value;
        }
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void setSelection(int value) {
        this.checkWidget();
        this.selection = Math.min(Math.max(this.minimum, value), this.maximum);
        ModifyEvent modifyEvent = new ModifyEvent(this);
        modifyEvent.processEvent();
    }

    public void setValues(int selection, int minimum, int maximum, int digits, int increment, int pageIncrement) {
        this.setMinimum(minimum);
        this.setMaximum(maximum);
        this.setIncrement(increment);
        this.setPageIncrement(pageIncrement);
        this.setSelection(selection);
    }

    public String getText() {
        this.checkWidget();
        return String.valueOf(this.selection);
    }

    public void setTextLimit(int textLimit) {
        this.checkWidget();
        if (textLimit == 0) {
            this.error(7);
        }
        this.textLimit = textLimit;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (wHint == -1 || hHint == -1) {
            String string = String.valueOf(this.maximum);
            if (this.digits > 0) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(string);
                buffer.append(",");
                int count = this.digits - string.length();
                while (count >= 0) {
                    buffer.append("0");
                    --count;
                }
                string = buffer.toString();
            }
            Point textSize = TextSizeDetermination.stringExtent(this.getFont(), string);
            Rectangle padding = this.getPadding();
            int buttonWidth = this.getButtonWidth();
            width = textSize.x + buttonWidth + padding.width;
            height = textSize.y + padding.height;
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        if (hHint == -1) {
            int upDownHeight = 18 + 2 * this.getBorderWidth();
            trim.height = Math.max(trim.height, upDownHeight);
        }
        return new Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle result = new Rectangle(x, y, width, height);
        if ((this.style & 0x800) != 0) {
            int border = this.getBorderWidth();
            result.x -= border;
            result.y -= border;
            result.width += 2 * border;
            result.height += 2 * border;
        }
        int buttonWidth = this.getButtonWidth();
        result.width += buttonWidth;
        return result;
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        ModifyEvent.addListener(this, listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        ModifyEvent.removeListener(this, listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    private Rectangle getPadding() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.theme.IThemeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SpinnerThemeAdapter themeAdapter = (SpinnerThemeAdapter)this.getAdapter(clazz);
        return themeAdapter.getPadding(this);
    }

    private int getButtonWidth() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.theme.IThemeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SpinnerThemeAdapter themeAdapter = (SpinnerThemeAdapter)this.getAdapter(clazz);
        return themeAdapter.getButtonWidth(this);
    }

    private static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }
}

