/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.SetDataEvent;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.internal.widgets.ICellToolTipProvider;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.internal.widgets.ITableAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.tablekit.TableThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class Table
extends Composite {
    public static final String HIDE_SELECTION;
    public static final String ENABLE_CELL_TOOLTIP;
    private static final int GRID_WIDTH = 1;
    private static final int[] EMPTY_SELECTION;
    private final CompositeItemHolder itemHolder;
    private final ITableAdapter tableAdapter = new TableAdapter();
    private final ResizeListener resizeListener;
    private int itemCount;
    private TableItem[] items;
    private final ItemHolder columnHolder;
    private int[] columnImageCount;
    private int[] columnOrder;
    private int[] selection;
    private boolean linesVisible;
    private boolean headerVisible;
    private boolean hasVScrollBar;
    private boolean hasHScrollBar;
    private ScrollBar verticalBar;
    private ScrollBar horizontalBar;
    private int topIndex;
    int leftOffset;
    private int focusIndex = -1;
    private TableColumn sortColumn;
    private int sortDirection = 0;
    private Point itemImageSize;
    private Rectangle bufferedCellPadding = null;
    private int bufferedCellSpacing = -1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Table");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HIDE_SELECTION = String.valueOf(clazz.getName()) + "#hideSelection";
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.widgets.Table");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ENABLE_CELL_TOOLTIP = String.valueOf(clazz2.getName()) + "#enableCellToolTip";
        EMPTY_SELECTION = new int[0];
    }

    public Table(Composite parent, int style) {
        super(parent, Table.checkStyle(style));
        this.itemHolder = new CompositeItemHolder();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.widgets.TableColumn");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.columnHolder = new ItemHolder(clazz);
        this.setTableEmpty();
        this.createScrollBars();
        this.selection = EMPTY_SELECTION;
        this.resizeListener = new ResizeListener();
        this.addControlListener(this.resizeListener);
    }

    void initState() {
        this.state &= 0xFFFFFEFF;
    }

    public Object getAdapter(Class adapter) {
        Object result;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.swt.internal.widgets.IItemHolderAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            result = this.itemHolder;
        } else {
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            result = adapter == clazz2 ? this.tableAdapter : super.getAdapter(adapter);
        }
        return result;
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnHolder.size();
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        return (TableColumn[])this.columnHolder.getItems();
    }

    public TableColumn getColumn(int index) {
        this.checkWidget();
        return (TableColumn)this.columnHolder.getItem(index);
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            SWT.error(4);
        }
        return this.columnHolder.indexOf(tableColumn);
    }

    public void setColumnOrder(int[] order) {
        int columnCount;
        this.checkWidget();
        if (order == null) {
            SWT.error(4);
        }
        if (order.length != (columnCount = this.getColumnCount())) {
            SWT.error(5);
        }
        if (columnCount > 0) {
            int[] oldOrder = new int[columnCount];
            System.arraycopy(this.columnOrder, 0, oldOrder, 0, this.columnOrder.length);
            boolean reorder = false;
            boolean[] seen = new boolean[columnCount];
            int i = 0;
            while (i < order.length) {
                int index = order[i];
                if (index < 0 || index >= columnCount) {
                    SWT.error(6);
                }
                if (seen[index]) {
                    SWT.error(5);
                }
                seen[index] = true;
                if (index != oldOrder[i]) {
                    reorder = true;
                }
                ++i;
            }
            if (reorder) {
                System.arraycopy(order, 0, this.columnOrder, 0, this.columnOrder.length);
                i = 0;
                while (i < seen.length) {
                    if (oldOrder[i] != this.columnOrder[i]) {
                        TableColumn column = this.getColumn(this.columnOrder[i]);
                        int controlMoved = 10;
                        ControlEvent controlEvent = new ControlEvent(column, controlMoved);
                        controlEvent.processEvent();
                    }
                    ++i;
                }
            }
        }
    }

    public int[] getColumnOrder() {
        int[] result;
        this.checkWidget();
        if (this.columnHolder.size() == 0) {
            result = new int[]{};
        } else {
            result = new int[this.columnOrder.length];
            System.arraycopy(this.columnOrder, 0, result, 0, this.columnOrder.length);
        }
        return result;
    }

    public void setItemCount(int newCount) {
        this.checkWidget();
        int count = Math.max(0, newCount);
        if (count != this.itemCount) {
            while (count < this.itemCount) {
                TableItem item = this.items[count];
                if (item != null && !item.isDisposed()) {
                    item.dispose();
                    continue;
                }
                this.destroyItem(null, count);
            }
            int length = Math.max(4, (count + 3) / 4 * 4);
            TableItem[] newItems = new TableItem[length];
            System.arraycopy(this.items, 0, newItems, 0, Math.min(count, this.itemCount));
            this.items = newItems;
            if ((this.style & 0x10000000) == 0) {
                int i = this.itemCount;
                while (i < count) {
                    this.items[i] = new TableItem(this, 0, i, true);
                    ++i;
                }
            }
            this.itemCount = count;
            this.adjustTopIndex();
            if (this.focusIndex > this.itemCount - 1) {
                this.adjustFocusIndex();
            }
            if ((this.style & 0x10000000) != 0) {
                this.updateScrollBars();
            }
        }
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] result = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            int i = 0;
            while (i < this.itemCount) {
                result[i] = this._getItem(i);
                ++i;
            }
        } else {
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    public TableItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            SWT.error(6);
        }
        return this._getItem(index);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        TableItem result = null;
        int headerHeight = this.getHeaderHeight();
        Rectangle itemArea = this.getClientArea();
        itemArea.y += headerHeight;
        if (itemArea.contains(point)) {
            int itemHeight = this.getItemHeight();
            int index = (point.y - headerHeight) / itemHeight - 1;
            if (point.y == headerHeight || point.y % itemHeight != 0) {
                ++index;
            }
            if ((index += this.topIndex) >= 0 && index < this.itemCount) {
                result = this._getItem(index);
            }
        }
        return result;
    }

    public int indexOf(TableItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        return item.parent == this ? item.index : -1;
    }

    public void removeAll() {
        this.checkWidget();
        while (this.itemCount > 0) {
            this.removeItem(0);
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start <= end) {
            if (start < 0 || start > end || end >= this.itemCount) {
                this.error(6);
            }
            int i = end;
            while (i >= start) {
                this.removeItem(i);
                --i;
            }
        }
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            SWT.error(15);
        }
        this.removeItem(index);
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length > 0) {
            int[] sortedIndices = new int[indices.length];
            System.arraycopy(indices, 0, sortedIndices, 0, indices.length);
            Table.sort(sortedIndices);
            int start = sortedIndices[sortedIndices.length - 1];
            int end = sortedIndices[0];
            if (start < 0 || start > end || end >= this.itemCount) {
                SWT.error(6);
            }
            int lastValue = -1;
            int i = 0;
            while (i < sortedIndices.length) {
                if (sortedIndices[i] != lastValue) {
                    lastValue = sortedIndices[i];
                    this.removeItem(sortedIndices[i]);
                }
                ++i;
            }
            if (this.itemCount == 0) {
                this.setTableEmpty();
            }
        }
    }

    public void clear(int index) {
        TableItem item;
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            SWT.error(6);
        }
        if ((item = this.items[index]) != null) {
            item.clear();
        }
    }

    public void clear(int start, int end) {
        this.checkWidget();
        if (start <= end) {
            if (start < 0 || start > end || end >= this.itemCount) {
                SWT.error(6);
            }
            if (start == 0 && end == this.itemCount - 1) {
                this.clearAll();
            } else {
                int i = start;
                while (i <= end) {
                    TableItem item = this.items[i];
                    if (item != null) {
                        item.clear();
                    }
                    ++i;
                }
            }
        }
    }

    public void clearAll() {
        this.checkWidget();
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.items[i];
            if (item != null) {
                item.clear();
            }
            ++i;
        }
    }

    public void clear(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error(4);
        }
        if (indices.length > 0) {
            int i = 0;
            while (i < indices.length) {
                if (indices[i] < 0 || indices[i] >= this.itemCount) {
                    SWT.error(6);
                }
                ++i;
            }
            i = 0;
            while (i < indices.length) {
                TableItem item = this.items[indices[i]];
                if (item != null) {
                    item.clear();
                }
                ++i;
            }
        }
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int result = -1;
        int topSelectedIndex = -1;
        int i = 0;
        while (i < this.selection.length) {
            if (this.focusIndex == this.selection[i]) {
                result = this.selection[i];
            }
            topSelectedIndex = topSelectedIndex == -1 ? this.selection[i] : Math.min(topSelectedIndex, this.selection[i]);
            ++i;
        }
        if (result == -1) {
            result = topSelectedIndex;
        }
        return result;
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.deselectAll();
        this.select(index);
        if (index < this.itemCount) {
            this.setFocusIndex(index);
        }
        this.showSelection();
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.selection.length;
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        this.select(start, end);
        if (end >= 0 && start <= end && ((this.style & 4) == 0 || start == end) && this.itemCount != 0 && start < this.itemCount) {
            this.setFocusIndex(Math.max(0, start));
        }
        this.showSelection();
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        int length = this.selection.length;
        TableItem[] result = new TableItem[length];
        int i = 0;
        while (i < this.selection.length) {
            result[i] = this._getItem(this.selection[i]);
            ++i;
        }
        return result;
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error(4);
        }
        this.deselectAll();
        this.select(indices);
        int length = indices.length;
        if (length != 0 && ((this.style & 4) == 0 || length <= 1)) {
            this.setFocusIndex(indices[0]);
        }
        this.showSelection();
    }

    public void setSelection(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{item});
    }

    public void setSelection(TableItem[] items) {
        this.checkWidget();
        if (items == null) {
            SWT.error(4);
        }
        int[] indices = new int[items.length];
        int i = 0;
        while (i < items.length) {
            indices[i] = this.indexOf(items[i]);
            ++i;
        }
        this.setSelection(indices);
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        TableItem[] currentSelection = this.getSelection();
        int[] result = new int[currentSelection.length];
        int i = 0;
        while (i < currentSelection.length) {
            result[i] = this.indexOf(currentSelection[i]);
            ++i;
        }
        return result;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        boolean result = false;
        if (index >= 0 && index < this.itemCount) {
            int i = 0;
            while (!result && i < this.selection.length) {
                result = this.selection[i] == index;
                ++i;
            }
        }
        return result;
    }

    public void select(int index) {
        this.checkWidget();
        if (index >= 0 && index < this.itemCount) {
            if ((this.style & 4) != 0) {
                this.selection = new int[]{index};
            } else if (!this.isSelected(index)) {
                int length = this.selection.length;
                int[] newSelection = new int[length + 1];
                System.arraycopy(this.selection, 0, newSelection, 0, length);
                newSelection[length] = index;
                this.selection = newSelection;
            }
        }
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end >= 0 && start <= end && ((this.style & 4) == 0 || start == end) && this.itemCount != 0 && start < this.itemCount) {
            int adjustedStart = Math.max(0, start);
            int adjustedEnd = Math.min(end, this.itemCount - 1);
            if (adjustedStart == 0 && adjustedEnd == this.itemCount - 1) {
                this.selectAll();
            } else {
                int i = adjustedStart;
                while (i <= adjustedEnd) {
                    this.select(i);
                    ++i;
                }
            }
        }
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) != 0 && ((this.style & 4) == 0 || length <= 1)) {
            int i = length - 1;
            while (i >= 0) {
                this.select(indices[i]);
                --i;
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) == 0) {
            this.setSelection(this.getItems());
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        this.removeFromSelection(index);
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start == 0 && end == this.itemCount - 1) {
            this.deselectAll();
        } else {
            int actualStart;
            int i = actualStart = Math.max(0, start);
            while (i <= end) {
                this.removeFromSelection(i);
                ++i;
            }
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        int i = 0;
        while (i < indices.length) {
            this.removeFromSelection(indices[i]);
            ++i;
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.selection = EMPTY_SELECTION;
    }

    public void setTopIndex(int topIndex) {
        this.checkWidget();
        if (this.topIndex != topIndex && topIndex >= 0 && topIndex < this.itemCount) {
            this.topIndex = topIndex;
            if ((this.style & 0x10000000) != 0) {
                this.redraw();
            }
        }
    }

    public int getTopIndex() {
        this.checkWidget();
        return this.topIndex;
    }

    public void showItem(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int itemIndex = this.indexOf(item);
        int itemCount = this.getVisibleItemCount(false);
        if (itemIndex < this.topIndex) {
            this.setTopIndex(itemIndex);
        } else if (itemCount > 0 && itemIndex >= this.topIndex + itemCount) {
            this.setTopIndex(itemIndex - itemCount + 1);
        }
    }

    public void showColumn(TableColumn column) {
        int index;
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.getParent() == this && (index = this.indexOf(column)) >= 0 && index < this.getColumnCount()) {
            int leftColumnsWidth = 0;
            int columnWidth = column.getWidth();
            int clientWidth = this.getClientArea().width - this.getVScrollBarWidth();
            int[] columnOrder = this.getColumnOrder();
            boolean found = false;
            int i = 0;
            while (i < columnOrder.length && !found) {
                boolean bl = found = index == columnOrder[i];
                if (!found) {
                    leftColumnsWidth += this.getColumn(columnOrder[i]).getWidth();
                }
                ++i;
            }
            if (this.leftOffset > leftColumnsWidth) {
                this.leftOffset = leftColumnsWidth;
            } else if (this.leftOffset < leftColumnsWidth + columnWidth - clientWidth) {
                this.leftOffset = leftColumnsWidth + columnWidth - clientWidth;
            }
        }
    }

    public void showSelection() {
        this.checkWidget();
        int index = this.getSelectionIndex();
        if (index != -1) {
            this.showItem(this._getItem(index));
        }
    }

    public void setHeaderVisible(boolean headerVisible) {
        this.checkWidget();
        boolean changed = headerVisible ^ this.headerVisible;
        this.headerVisible = headerVisible;
        if (changed) {
            this.updateScrollBars();
        }
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return this.headerVisible;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this.linesVisible;
    }

    public void setLinesVisible(boolean linesVisible) {
        this.checkWidget();
        this.linesVisible = linesVisible;
    }

    public void setSortColumn(TableColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
        this.sortColumn = column;
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if ((direction & 0x480) != 0 || direction == 0) {
            this.sortDirection = direction;
        }
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int getItemHeight() {
        this.checkWidget();
        int textHeight = TextSizeDetermination.getCharHeight(this.getFont());
        int paddingHeight = this.getCellPadding().height;
        int itemImageHeight = this.getItemImageSize().y + paddingHeight;
        int result = Math.max(itemImageHeight, textHeight += Math.max(paddingHeight, 4));
        if ((this.style & 0x20) != 0) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.rwt.internal.theme.IThemeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            TableThemeAdapter adapter = (TableThemeAdapter)this.getAdapter(clazz);
            result = Math.max(adapter.getCheckBoxImageSize((Control)this).y, result);
        }
        return result;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        int result = 0;
        if (this.headerVisible) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.rwt.internal.theme.IThemeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            TableThemeAdapter themeAdapter = (TableThemeAdapter)this.getAdapter(clazz);
            Font headerFont = themeAdapter.getHeaderFont(this);
            int textHeight = TextSizeDetermination.getCharHeight(headerFont);
            int imageHeight = 0;
            int i = 0;
            while (i < this.getColumnCount()) {
                int height;
                Image image = this.getColumn(i).getImage();
                int n = height = image == null ? 0 : image.getBounds().height;
                if (height > imageHeight) {
                    imageHeight = height;
                }
                ++i;
            }
            result = Math.max(textHeight, imageHeight);
            result += themeAdapter.getHeaderBorderBottomWidth(this);
            result += themeAdapter.getHeaderPadding((Control)this).height;
        }
        return result;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateScrollBars();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (this.getColumnCount() > 0) {
            int i = 0;
            while (i < this.getColumnCount()) {
                width += this.getColumn(i).getWidth();
                ++i;
            }
        } else {
            width = this.getItemsPreferredWidth(0);
        }
        height += this.getHeaderHeight();
        height += this.getItemCount() * this.getItemHeight();
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        width += border * 2;
        height += border * 2;
        if ((this.style & 0x200) != 0) {
            width += this.getScrollBarSize();
        }
        if ((this.style & 0x100) != 0) {
            height += this.getScrollBarSize();
        }
        return new Point(width, height);
    }

    final int getItemsPreferredWidth(int columnIndex) {
        int width = this.getCheckWidth(columnIndex) + 12;
        TableItem[] items = this.getCachedItems();
        int i = 0;
        while (i < items.length) {
            int itemWidth = items[i].getCheckWidth(columnIndex) + items[i].getPackWidth(columnIndex);
            if (itemWidth > width) {
                width = itemWidth;
            }
            ++i;
        }
        return width;
    }

    final void createColumn(TableColumn column, int index) {
        int length;
        this.columnHolder.insert(column, index);
        if (this.columnOrder == null) {
            this.columnOrder = new int[]{index};
        } else {
            length = this.columnOrder.length;
            int i = index;
            while (i < length) {
                int n = i++;
                this.columnOrder[n] = this.columnOrder[n] + 1;
            }
            int[] newColumnOrder = new int[length + 1];
            System.arraycopy(this.columnOrder, 0, newColumnOrder, 0, index);
            System.arraycopy(this.columnOrder, index, newColumnOrder, index + 1, length - index);
            this.columnOrder = newColumnOrder;
            this.columnOrder[index] = index;
        }
        if (this.columnImageCount == null) {
            this.columnImageCount = new int[1];
        } else if (this.getColumnCount() > 1) {
            length = this.columnImageCount.length;
            int[] newColumnImageCount = new int[length + 1];
            System.arraycopy(this.columnImageCount, 0, newColumnImageCount, 0, index);
            System.arraycopy(this.columnImageCount, index, newColumnImageCount, index + 1, length - index);
            this.columnImageCount = newColumnImageCount;
        }
        this.updateScrollBars();
    }

    final void destroyColumn(TableColumn column) {
        int index = this.indexOf(column);
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] != null) {
                this.items[i].removeData(index);
            }
            ++i;
        }
        if (column == this.sortColumn) {
            this.sortColumn = null;
        }
        this.columnHolder.remove(column);
        int length = this.columnOrder.length;
        int[] newColumnOrder = new int[length - 1];
        int count = 0;
        int i2 = 0;
        while (i2 < length) {
            if (this.columnOrder[i2] != index) {
                int newOrder = this.columnOrder[i2];
                if (index < newOrder) {
                    // empty if block
                }
                newColumnOrder[count] = --newOrder;
                ++count;
            }
            ++i2;
        }
        this.columnOrder = newColumnOrder;
        if (this.columnImageCount.length == 1) {
            this.columnImageCount = null;
        } else {
            count = 0;
            int[] newColumnImageCount = new int[this.columnImageCount.length - 1];
            int i3 = 0;
            while (i3 < this.columnImageCount.length) {
                if (i3 != index) {
                    newColumnImageCount[count] = this.columnImageCount[i3];
                    ++count;
                }
                ++i3;
            }
            this.columnImageCount = newColumnImageCount;
        }
        this.updateScrollBars();
    }

    final void createItem(TableItem item, int index) {
        int count = this.itemCount;
        if (index < 0 || index > count) {
            this.error(6);
        }
        if (count == this.items.length) {
            boolean small = this.isVisible();
            int length = small ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] newItems = new TableItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, count - index);
        this.items[index] = item;
        ++this.itemCount;
        this.adjustItemIndices(index);
        int i = 0;
        while (i < this.selection.length) {
            if (this.selection[i] >= index) {
                this.selection[i] = this.selection[i] + 1;
            }
            ++i;
        }
        if (index <= this.focusIndex) {
            ++this.focusIndex;
        }
        this.updateScrollBars();
    }

    final void destroyItem(TableItem item, int index) {
        this.removeFromSelection(index);
        this.adjustSelectionIdices(index);
        if (item != null) {
            int columnCount = Math.max(1, this.columnHolder.size());
            int i = 0;
            while (i < columnCount) {
                this.updateColumnImageCount(i, item.getImageInternal(i), null);
                ++i;
            }
        }
        --this.itemCount;
        if (item != null) {
            item.index = -1;
        }
        if (this.itemCount == 0) {
            this.setTableEmpty();
        } else {
            System.arraycopy(this.items, index + 1, this.items, index, this.itemCount - index);
            this.items[this.itemCount] = null;
            this.adjustItemIndices(index);
        }
        this.adjustTopIndex();
        if (index == this.focusIndex || this.focusIndex > this.itemCount - 1) {
            this.adjustFocusIndex();
        }
        this.updateScrollBars();
        if ((this.style & 0x10000000) != 0) {
            this.redraw();
        }
    }

    void releaseChildren() {
        TableItem[] tableItems = new TableItem[this.items.length];
        System.arraycopy(this.items, 0, tableItems, 0, this.items.length);
        int i = 0;
        while (i < tableItems.length) {
            if (tableItems[i] != null) {
                tableItems[i].dispose();
            }
            ++i;
        }
        Item[] tableColumns = this.columnHolder.getItems();
        int i2 = 0;
        while (i2 < tableColumns.length) {
            tableColumns[i2].dispose();
            ++i2;
        }
    }

    void releaseWidget() {
        this.removeControlListener(this.resizeListener);
        super.releaseWidget();
    }

    private TableItem _getItem(int index) {
        if ((this.style & 0x10000000) != 0 && this.items[index] == null) {
            this.items[index] = new TableItem(this, 0, index, false);
        }
        return this.items[index];
    }

    final TableItem[] getCachedItems() {
        TableItem[] result;
        if ((this.style & 0x10000000) != 0) {
            int count = 0;
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null && this.items[i].cached) {
                    ++count;
                }
                ++i;
            }
            result = new TableItem[count];
            count = 0;
            i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null && this.items[i].cached) {
                    result[count] = this.items[i];
                    ++count;
                }
                ++i;
            }
        } else {
            result = new TableItem[this.itemCount];
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    final TableItem[] getCreatedItems() {
        TableItem[] result;
        if ((this.style & 0x10000000) != 0) {
            int count = 0;
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null) {
                    ++count;
                }
                ++i;
            }
            result = new TableItem[count];
            count = 0;
            i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null) {
                    result[count] = this.items[i];
                    ++count;
                }
                ++i;
            }
        } else {
            result = new TableItem[this.itemCount];
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    private void checkData() {
        boolean visible = true;
        int index = Math.max(0, this.topIndex);
        while (visible && index < this.itemCount) {
            visible = this.isItemVisible(index);
            if (visible) {
                TableItem item = this._getItem(index);
                this.checkData(item, index);
            }
            ++index;
        }
    }

    final boolean checkData(TableItem item, int index) {
        boolean virtual;
        boolean result = true;
        boolean bl = virtual = (this.style & 0x10000000) != 0;
        if (virtual && !item.cached && index >= 0 && index < this.itemCount) {
            item.cached = true;
            SetDataEvent event = new SetDataEvent(this, item, index);
            event.processEvent();
            if (this.isDisposed() || item.isDisposed()) {
                result = false;
            }
        }
        return result;
    }

    final void updateColumnImageCount(int columnIndex, Image oldImage, Image newImage) {
        int delta = 0;
        if (oldImage == null && newImage != null) {
            delta = 1;
        } else if (oldImage != null && newImage == null) {
            delta = -1;
        }
        if (delta != 0) {
            if (this.columnImageCount == null) {
                int columnCount = Math.max(1, this.columnHolder.size());
                this.columnImageCount = new int[columnCount];
            }
            int n = columnIndex;
            this.columnImageCount[n] = this.columnImageCount[n] + delta;
        }
    }

    final boolean hasColumnImages(int columnIndex) {
        return this.columnImageCount == null ? false : this.columnImageCount[columnIndex] > 0;
    }

    final void updateItemImageSize(Image image) {
        if (image != null && this.itemImageSize == null) {
            Rectangle imageBounds = image.getBounds();
            this.itemImageSize = new Point(imageBounds.width, imageBounds.height);
        }
    }

    final Point getItemImageSize() {
        return this.itemImageSize == null ? new Point(0, 0) : this.itemImageSize;
    }

    Rectangle getCellPadding() {
        if (this.bufferedCellPadding == null) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.rwt.internal.theme.IThemeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            TableThemeAdapter themeAdapter = (TableThemeAdapter)this.getAdapter(clazz);
            this.bufferedCellPadding = themeAdapter.getCellPadding(this);
        }
        return this.bufferedCellPadding;
    }

    int getCellSpacing() {
        if (this.bufferedCellSpacing < 0) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.rwt.internal.theme.IThemeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            TableThemeAdapter themeAdapter = (TableThemeAdapter)this.getAdapter(clazz);
            this.bufferedCellSpacing = themeAdapter.getCellSpacing(this.parent);
        }
        return this.bufferedCellSpacing;
    }

    private void createScrollBars() {
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = new ScrollBar(this, 256);
            this.horizontalBar.setVisible(false);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = new ScrollBar(this, 512);
            this.verticalBar.setVisible(false);
        }
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    boolean hasVScrollBar() {
        return this.hasVScrollBar;
    }

    boolean hasHScrollBar() {
        return this.hasHScrollBar;
    }

    int getVScrollBarWidth() {
        int result = 0;
        if (this.hasVScrollBar()) {
            result = this.getScrollBarSize();
        }
        return result;
    }

    int getHScrollBarHeight() {
        int result = 0;
        if (this.hasHScrollBar()) {
            result = this.getScrollBarSize();
        }
        return result;
    }

    void updateScrollBars() {
        if ((this.style & 0x10) == 0) {
            this.hasVScrollBar = false;
            this.hasHScrollBar = this.needsHScrollBar();
            if (this.needsVScrollBar()) {
                this.hasVScrollBar = true;
                this.hasHScrollBar = this.needsHScrollBar();
            }
            this.horizontalBar.setVisible(this.hasHScrollBar);
            this.verticalBar.setVisible(this.hasVScrollBar);
        }
    }

    private int getScrollBarSize() {
        Display display = this.getDisplay();
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.swt.internal.widgets.IDisplayAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object object = display.getAdapter(clazz);
        IDisplayAdapter adapter = (IDisplayAdapter)object;
        return adapter.getScrollBarSize();
    }

    final int getCheckWidth() {
        int result = 0;
        if ((this.style & 0x20) != 0) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.rwt.internal.theme.IThemeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            TableThemeAdapter themeAdapter = (TableThemeAdapter)this.getAdapter(clazz);
            result = themeAdapter.getCheckBoxWidth(this);
        }
        return result;
    }

    final int getCheckWidth(int index) {
        int result = 0;
        if (index == 0 && this.getColumnCount() == 0) {
            result = this.getCheckWidth();
        } else {
            int[] columnOrder = this.getColumnOrder();
            if (columnOrder[0] == index) {
                result = this.getCheckWidth();
            }
        }
        return result;
    }

    final int getVisibleItemCount(boolean includePartlyVisible) {
        int clientHeight = this.getBounds().height - this.getHeaderHeight() - this.getHScrollBarHeight();
        int result = 0;
        if (clientHeight >= 0) {
            int itemHeight = this.getItemHeight();
            result = clientHeight / itemHeight;
            if (includePartlyVisible && clientHeight % itemHeight != 0) {
                ++result;
            }
        }
        return result;
    }

    private void setFocusIndex(int focusIndex) {
        if (focusIndex >= 0) {
            this.focusIndex = focusIndex;
        }
    }

    private void removeItem(int index) {
        TableItem item = this.items[index];
        if (item != null && !item.isDisposed()) {
            item.dispose();
        } else {
            this.destroyItem(null, index);
        }
    }

    private void removeFromSelection(int index) {
        if (index >= 0 && index < this.itemCount) {
            boolean found = false;
            int i = 0;
            while (!found && i < this.selection.length) {
                if (index == this.selection[i]) {
                    int length = this.selection.length;
                    int[] newSel = new int[length - 1];
                    System.arraycopy(this.selection, 0, newSel, 0, i);
                    if (i < length - 1) {
                        System.arraycopy(this.selection, i + 1, newSel, i, length - i - 1);
                    }
                    this.selection = newSel;
                    found = true;
                }
                ++i;
            }
        }
    }

    private void adjustSelectionIdices(int removedIndex) {
        int i = 0;
        while (i < this.selection.length) {
            if (this.selection[i] >= removedIndex) {
                this.selection[i] = this.selection[i] - 1;
            }
            ++i;
        }
    }

    private void adjustTopIndex() {
        int visibleItemCount = this.getVisibleItemCount(false);
        if (this.topIndex > this.itemCount - visibleItemCount - 1) {
            this.topIndex = Math.max(0, this.itemCount - visibleItemCount - 1);
        }
    }

    private void adjustFocusIndex() {
        this.focusIndex = -1;
        this.focusIndex = this.getSelectionIndex();
    }

    private void adjustItemIndices(int start) {
        int i = start;
        while (i < this.itemCount) {
            if (this.items[i] != null) {
                this.items[i].index = i;
            }
            ++i;
        }
    }

    private boolean isItemVisible(int index) {
        boolean result = false;
        int visibleItemCount = this.getVisibleItemCount(true);
        if (visibleItemCount > 0) {
            result = index >= this.topIndex && index < this.topIndex + visibleItemCount;
        }
        return result;
    }

    private static void sort(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] <= items[j + gap]) {
                        int swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    private void setTableEmpty() {
        this.items = new TableItem[4];
    }

    private static int checkStyle(int style) {
        int result = style;
        if ((style & 0x10) == 0) {
            result |= 0x300;
        }
        return Table.checkBits(result, 4, 2, 0, 0, 0, 0);
    }

    boolean needsVScrollBar() {
        int availableHeight = this.getClientArea().height - this.getHScrollBarHeight();
        int height = this.getHeaderHeight();
        return (height += this.getItemCount() * this.getItemHeight()) > availableHeight;
    }

    boolean needsHScrollBar() {
        boolean result = false;
        int availableWidth = this.getClientArea().width - this.getVScrollBarWidth();
        int columnCount = this.getColumnCount();
        if (columnCount > 0) {
            int totalWidth = 0;
            int i = 0;
            while (i < columnCount) {
                TableColumn column = this.getColumn(i);
                totalWidth += column.getWidth();
                ++i;
            }
            result = totalWidth > availableWidth;
        } else {
            TableItem measureItem = this.getMeasureItem();
            if (measureItem != null) {
                int itemWidth = measureItem.getBounds().width;
                result = itemWidth > availableWidth;
            }
        }
        return result;
    }

    TableItem getMeasureItem() {
        TableItem[] items = this.tableAdapter.getCachedItems();
        TableItem result = null;
        if (this.getColumnCount() == 0) {
            int i = 0;
            while (i < items.length) {
                result = result == null ? items[i] : Table.max(result, items[i]);
                ++i;
            }
        } else if (items.length > 0) {
            result = items[0];
        }
        return result;
    }

    private static TableItem max(TableItem item1, TableItem item2) {
        TableItem result = item1.getText(0).length() > item2.getText(0).length() ? item1 : item2;
        return result;
    }

    void reskinChildren(int flags) {
        TableColumn[] columns;
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                TableItem item = this.items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        if ((columns = this.getColumns()) != null) {
            int i = 0;
            while (i < columns.length) {
                TableColumn column = columns[i];
                if (!column.isDisposed()) {
                    column.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    static /* synthetic */ int access$4(Table table) {
        return table.itemCount;
    }

    static /* synthetic */ TableItem access$5(Table table, int n) {
        return table._getItem(n);
    }

    private final class CompositeItemHolder
    implements IItemHolderAdapter {
        private CompositeItemHolder() {
        }

        public void add(Item item) {
            if (!(item instanceof TableColumn)) {
                String msg = "Only TableColumns may be added to CompositeItemHolder";
                throw new IllegalArgumentException(msg);
            }
            Table.this.columnHolder.add(item);
        }

        public void insert(Item item, int index) {
            if (!(item instanceof TableColumn)) {
                String msg = "Only TableColumns may be inserted to CompositeItemHolder";
                throw new IllegalArgumentException(msg);
            }
            Table.this.columnHolder.insert(item, index);
        }

        public void remove(Item item) {
            if (!(item instanceof TableColumn)) {
                String msg = "Only TableColumns may be removed from CompositeItemHolder";
                throw new IllegalArgumentException(msg);
            }
            Table.this.columnHolder.remove(item);
        }

        public Item[] getItems() {
            TableItem[] items = Table.this.getCreatedItems();
            Item[] columns = Table.this.columnHolder.getItems();
            Item[] result = new Item[columns.length + items.length];
            System.arraycopy(columns, 0, result, 0, columns.length);
            System.arraycopy(items, 0, result, columns.length, items.length);
            return result;
        }
    }

    private final class ResizeListener
    extends ControlAdapter {
        private ResizeListener() {
        }

        public void controlResized(ControlEvent event) {
            if ((Table.this.style & 0x10000000) != 0) {
                Table.this.checkData();
            }
            Table.this.updateScrollBars();
        }
    }

    private final class TableAdapter
    implements ITableAdapter {
        private String toolTipText;
        private ICellToolTipProvider provider;

        private TableAdapter() {
        }

        public int getCheckWidth() {
            return Table.this.getCheckWidth();
        }

        public int getItemImageWidth(int columnIndex) {
            int result = 0;
            if (Table.this.hasColumnImages(columnIndex)) {
                result = Table.this.getItemImageSize().x;
            }
            return result;
        }

        public int getFocusIndex() {
            return Table.this.focusIndex;
        }

        public void setFocusIndex(int focusIndex) {
            Table.this.setFocusIndex(focusIndex);
        }

        public int getLeftOffset() {
            return Table.this.leftOffset;
        }

        public void setLeftOffset(int leftOffset) {
            Table.this.leftOffset = leftOffset;
        }

        public void checkData() {
            Table.this.checkData();
        }

        public void checkData(int index) {
            if ((Table.this.style & 0x10000000) != 0) {
                ProcessActionRunner.add(new Runnable(this, index){
                    final /* synthetic */ TableAdapter this$1;
                    private final /* synthetic */ int val$index;
                    {
                        this.this$1 = tableAdapter;
                        this.val$index = n;
                    }

                    public void run() {
                        TableItem item;
                        if (this.val$index >= 0 && this.val$index < Table.access$4(TableAdapter.access$1(this.this$1)) && !(item = Table.access$5(TableAdapter.access$1(this.this$1), this.val$index)).isDisposed()) {
                            TableAdapter.access$1(this.this$1).checkData(item, this.val$index);
                        }
                    }
                });
            }
        }

        public int getDefaultColumnWidth() {
            int result = 0;
            TableItem[] items = Table.this.getCachedItems();
            int i = 0;
            while (i < items.length) {
                result = Math.max(result, items[i].getPackWidth(0));
                ++i;
            }
            return result;
        }

        public int getColumnLeft(TableColumn column) {
            int index = Table.this.indexOf(column);
            return Table.this.getColumn(index).getLeft();
        }

        public boolean isItemVisible(TableItem item) {
            int index = Table.this.indexOf(item);
            return index != -1 && Table.this.isItemVisible(index);
        }

        public boolean isItemVirtual(int index) {
            boolean result = false;
            if ((Table.this.style & 0x10000000) != 0) {
                TableItem item = Table.this.items[index];
                result = item == null || !item.cached;
            }
            return result;
        }

        public TableItem[] getCachedItems() {
            return Table.this.getCachedItems();
        }

        public TableItem[] getCreatedItems() {
            return Table.this.getCreatedItems();
        }

        public boolean hasHScrollBar() {
            return Table.this.hasHScrollBar();
        }

        public boolean hasVScrollBar() {
            return Table.this.hasVScrollBar();
        }

        public TableItem getMeasureItem() {
            return Table.this.getMeasureItem();
        }

        public ICellToolTipProvider getCellToolTipProvider() {
            return this.provider;
        }

        public void setCellToolTipProvider(ICellToolTipProvider provider) {
            this.provider = provider;
        }

        public String getToolTipText() {
            return this.toolTipText;
        }

        public void setToolTipText(String toolTipText) {
            this.toolTipText = toolTipText;
        }

        static /* synthetic */ Table access$1(TableAdapter tableAdapter) {
            return tableAdapter.Table.this;
        }
    }
}

