/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.internal.widgets.ITreeItemAdapter;
import org.eclipse.swt.internal.widgets.IWidgetColorAdapter;
import org.eclipse.swt.internal.widgets.IWidgetFontAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TreeItem
extends Item {
    private static final int IMAGE_TEXT_GAP = 2;
    private static final int INDENT_WIDTH = 19;
    private static final int ITEM_HEIGHT = 16;
    private final TreeItem parentItem;
    private final Tree parent;
    private final ItemHolder itemHolder;
    private final ITreeItemAdapter treeItemAdapter;
    private Font font;
    private boolean expanded;
    private boolean checked;
    private Color background;
    private Color foreground;
    private boolean grayed;
    private String[] texts;
    private Image[] images;
    Color[] cellForegrounds;
    Color[] cellBackgrounds;
    Font[] cellFonts;
    int depth;
    private final int index;
    boolean cached;
    int flatIndex;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public TreeItem(Tree parent, int style) {
        this(parent, null, style, parent == null ? 0 : parent.getItemCount());
    }

    public TreeItem(Tree parent, int style, int index) {
        this(parent, null, style, index);
    }

    public TreeItem(TreeItem parentItem, int style) {
        this(parentItem == null ? null : parentItem.parent, parentItem, style, parentItem == null ? 0 : parentItem.getItemCount());
    }

    public TreeItem(TreeItem parentItem, int style, int index) {
        this(parentItem == null ? null : parentItem.parent, parentItem, style, index);
    }

    private TreeItem(Tree parent, TreeItem parentItem, int style, int index) {
        super(parent, style);
        int numberOfItems = parentItem != null ? parentItem.getItemCount() : parent.getItemCount();
        if (index < 0 || index > numberOfItems) {
            this.error(6);
        }
        this.parent = parent;
        this.parentItem = parentItem;
        if (parentItem != null) {
            this.depth = parentItem.depth + 1;
        }
        if (parentItem != null) {
            ItemHolder.insertItem(parentItem, this, index);
        } else {
            ItemHolder.insertItem(parent, this, index);
        }
        this.index = index;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.TreeItem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.itemHolder = new ItemHolder(clazz);
        this.treeItemAdapter = new TreeItemAdapter();
        int columnCount = parent.columnHolder.size();
        this.texts = new String[columnCount];
        this.images = new Image[columnCount];
        parent.updateFlatIndices();
        parent.updateScrollBars();
    }

    public Object getAdapter(Class adapter) {
        Object result;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IItemHolderAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            result = this.itemHolder;
        } else {
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetFontAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz2) {
                result = this.treeItemAdapter;
            } else {
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetColorAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter == clazz3) {
                    result = this.treeItemAdapter;
                } else {
                    Class<?> clazz4 = class$4;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$4 = Class.forName("org.eclipse.swt.internal.widgets.ITreeItemAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    result = adapter == clazz4 ? this.treeItemAdapter : super.getAdapter(adapter);
                }
            }
        }
        return result;
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        if (!expanded || this.getItemCount() > 0) {
            this.expanded = expanded;
            this.parent.updateFlatIndices();
            this.parent.updateScrollBars();
        }
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.getBounds(0);
    }

    public Rectangle getBounds(int columnIndex) {
        return this.getBounds(columnIndex, true);
    }

    Rectangle getBounds(int columnIndex, boolean checkData) {
        Rectangle result;
        this.checkWidget();
        int columnCount = this.parent.getColumnCount();
        if (columnIndex < 0 || columnIndex > columnCount) {
            result = new Rectangle(0, 0, 0, 0);
        } else if (this.getParentItem() != null && !this.getParentItem().getExpanded()) {
            result = new Rectangle(0, 0, 0, 0);
        } else {
            int width;
            Rectangle imageBounds = this.getImageBounds(columnIndex);
            String text = this.getText(0, checkData);
            Point textWidth = TextSizeDetermination.stringExtent(this.getFont(), text);
            if (columnIndex == 0 && columnCount == 0) {
                int gap = this.getImageGap(columnIndex);
                width = 2 + imageBounds.width + gap + textWidth.x;
            } else {
                width = this.parent.getColumn(columnIndex).getWidth();
                if (columnIndex == 0) {
                    width -= (this.depth + 1) * 19;
                }
            }
            int left = columnIndex == 0 ? imageBounds.x : this.getItemLeft(columnIndex);
            result = new Rectangle(left, this.getItemTop(), width, this.getItemHeight());
        }
        return result;
    }

    private int getItemLeft(int columnIndex) {
        int result = 0;
        TreeColumn[] cols = this.parent.getColumns();
        int i = 0;
        while (i < columnIndex) {
            TreeColumn col = cols[i];
            result += col.getWidth();
            ++i;
        }
        return result;
    }

    private int getItemHeight() {
        return 16;
    }

    private int getItemTop() {
        int headerHeight = this.parent.getHeaderHeight();
        return headerHeight + this.flatIndex * 16 - this.parent.scrollTop;
    }

    private int getImageGap(int index) {
        int result = 0;
        Image image = this.getImage(index);
        if (image != null) {
            result = 2;
        }
        return result;
    }

    public Color getBackground(int columnIndex) {
        this.checkWidget();
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return this.getBackground();
        }
        if (this.cellBackgrounds == null || this.cellBackgrounds[columnIndex] == null) {
            return this.getBackground();
        }
        return this.cellBackgrounds[columnIndex];
    }

    public Font getFont(int columnIndex) {
        this.checkWidget();
        return this.getFont(columnIndex, true);
    }

    Font getFont(int columnIndex, boolean checkData) {
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return this.getFont(checkData);
        }
        if (this.cellFonts == null || this.cellFonts[columnIndex] == null) {
            return this.getFont(checkData);
        }
        return this.cellFonts[columnIndex];
    }

    public Color getForeground(int columnIndex) {
        this.checkWidget();
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return this.getForeground();
        }
        if (this.cellForegrounds == null || this.cellForegrounds[columnIndex] == null) {
            return this.getForeground();
        }
        return this.cellForegrounds[columnIndex];
    }

    public void setBackground(int columnIndex, Color value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            this.error(5);
        }
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        if (this.cellBackgrounds == null) {
            this.cellBackgrounds = new Color[validColumnCount];
        } else if (this.cellBackgrounds.length < validColumnCount) {
            Color[] newCellBackgrounds = new Color[validColumnCount];
            System.arraycopy(this.cellBackgrounds, 0, newCellBackgrounds, 0, this.cellBackgrounds.length);
            this.cellBackgrounds = newCellBackgrounds;
        }
        if (this.cellBackgrounds[columnIndex] == value) {
            return;
        }
        if (this.cellBackgrounds[columnIndex] != null && this.cellBackgrounds[columnIndex].equals(value)) {
            return;
        }
        this.cellBackgrounds[columnIndex] = value;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setFont(int columnIndex, Font value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            this.error(5);
        }
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        if (this.cellFonts == null) {
            if (value == null) {
                return;
            }
            this.cellFonts = new Font[validColumnCount];
        } else if (this.cellFonts.length < validColumnCount) {
            Font[] newCellFonts = new Font[validColumnCount];
            System.arraycopy(this.cellFonts, 0, newCellFonts, 0, this.cellFonts.length);
            this.cellFonts = newCellFonts;
        }
        if (this.cellFonts[columnIndex] == value) {
            return;
        }
        if (this.cellFonts[columnIndex] != null && this.cellFonts[columnIndex].equals(value)) {
            return;
        }
        this.cellFonts[columnIndex] = value;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setForeground(int columnIndex, Color value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            this.error(5);
        }
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        if (this.cellForegrounds == null) {
            this.cellForegrounds = new Color[validColumnCount];
        } else if (this.cellForegrounds.length < validColumnCount) {
            Color[] newCellForegrounds = new Color[validColumnCount];
            System.arraycopy(this.cellForegrounds, 0, newCellForegrounds, 0, this.cellForegrounds.length);
            this.cellForegrounds = newCellForegrounds;
        }
        if (this.cellForegrounds[columnIndex] == value) {
            return;
        }
        if (this.cellForegrounds[columnIndex] != null && this.cellForegrounds[columnIndex].equals(value)) {
            return;
        }
        this.cellForegrounds[columnIndex] = value;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public Font getFont() {
        this.checkWidget();
        Font result = this.font == null ? this.getParent().getFont() : this.font;
        return result;
    }

    Font getFont(boolean checkData) {
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public void setBackground(Color value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            this.error(5);
        }
        if (this.background == value) {
            return;
        }
        if (this.background != null && this.background.equals(value)) {
            return;
        }
        this.background = value;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.isDisposed()) {
            this.error(24);
        }
        if (this.background != null) {
            return this.background;
        }
        return this.parent.getBackground();
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.isDisposed()) {
            this.error(24);
        }
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.parent.getForeground();
    }

    public void setForeground(Color value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            this.error(5);
        }
        if (this.foreground == value) {
            return;
        }
        if (this.foreground != null && this.foreground.equals(value)) {
            return;
        }
        this.foreground = value;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) != 0) {
            this.checked = checked;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public boolean getChecked() {
        this.checkWidget();
        return this.checked;
    }

    public void setGrayed(boolean value) {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) == 0) {
            return;
        }
        if (this.grayed == value) {
            return;
        }
        this.grayed = value;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public boolean getGrayed() {
        this.checkWidget();
        return this.grayed;
    }

    public String getText(int columnIndex) {
        this.checkWidget();
        return this.getText(columnIndex, true);
    }

    public String getText() {
        this.checkWidget();
        if (!this.isCached()) {
            this.parent.checkData(this, this.index);
        }
        return super.getText();
    }

    String getText(int columnIndex, boolean checkData) {
        if (checkData && !this.isCached()) {
            this.parent.checkData(this, this.index);
        }
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return "";
        }
        if (columnIndex == 0) {
            return super.getText();
        }
        if (this.texts[columnIndex] == null) {
            return "";
        }
        return this.texts[columnIndex];
    }

    public void setText(String[] value) {
        this.checkWidget();
        if (value == null) {
            this.error(4);
        }
        int i = 0;
        while (i < value.length) {
            if (value[i] != null) {
                this.setText(i, value[i]);
            }
            ++i;
        }
    }

    public void setText(int columnIndex, String value) {
        this.checkWidget();
        if (value == null) {
            this.error(4);
        }
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        if (value.equals(this.getText(columnIndex, false))) {
            return;
        }
        if (columnIndex == 0) {
            super.setText(value);
        } else {
            this.texts[columnIndex] = value;
        }
        if (this.parent.getColumnCount() == 0) {
            this.parent.updateScrollBars();
        }
    }

    public void setText(String text) {
        this.checkWidget();
        this.setText(0, text);
    }

    public Image getImage(int columnIndex) {
        this.checkWidget();
        return this.getImage(columnIndex, true);
    }

    public Rectangle getImageBounds(int columnIndex) {
        this.checkWidget();
        Rectangle result = null;
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex >= 0 && columnIndex < validColumnCount) {
            Image image = this.getImage(this.index);
            result = image != null ? image.getBounds() : new Rectangle(0, 0, 0, 0);
            int indent = (this.depth + 1) * 19;
            result.x = columnIndex > 0 ? (result.x += this.getItemLeft(columnIndex)) : indent;
            result.y = this.getItemTop();
        } else {
            result = new Rectangle(0, 0, 0, 0);
        }
        return result;
    }

    Image getImage(int columnIndex, boolean checkData) {
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return null;
        }
        if (columnIndex == 0) {
            return super.getImage();
        }
        return this.images[columnIndex];
    }

    int getPreferredWidth(int columnIndex, boolean checkData) {
        int width = 0;
        width += TextSizeDetermination.stringExtent((Font)this.parent.getFont(), (String)this.getText((int)columnIndex, (boolean)checkData)).x;
        int orderedIndex = 0;
        if (this.parent.columnHolder.size() > 0) {
            TreeColumn column = (TreeColumn)this.parent.columnHolder.getItem(columnIndex);
            orderedIndex = column.getOrderIndex();
        }
        if (orderedIndex == 0) {
            width += 19;
            width += 3;
            Image image = this.getImage();
            if (image != null) {
                width += image.getBounds().width;
                width += 3;
            }
        }
        return width += this.getCheckWidth(columnIndex);
    }

    void clear() {
        this.grayed = false;
        this.checked = false;
        this.texts = null;
        this.images = null;
        this.background = null;
        this.foreground = null;
        this.cellBackgrounds = null;
        this.cellForegrounds = null;
        this.font = null;
        this.cellFonts = null;
        this.setText("");
        this.setImage((Image)null);
        int columnCount = this.parent.columnHolder.size();
        if (columnCount > 0 && columnCount > 1) {
            this.texts = new String[columnCount];
            this.images = new Image[columnCount];
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
        this.parent.updateScrollBars();
    }

    public void clear(int index, boolean recursive) {
        this.checkWidget();
        if (index < 0 || index >= this.itemHolder.size()) {
            this.error(6);
        }
        TreeItem item = (TreeItem)this.itemHolder.getItem(index);
        item.clear();
        if (recursive) {
            item.clearAll(true, false);
        }
        if ((this.parent.style & 0x10000000) == 0) {
            this.parent.checkData(item, index);
        }
    }

    void addColumn(TreeColumn column) {
        int index = column.getIndex();
        int columnCount = this.parent.columnHolder.size();
        if (columnCount > 1) {
            if (columnCount == 2) {
                this.texts = new String[2];
            } else {
                String[] newTexts = new String[columnCount];
                System.arraycopy(this.texts, 0, newTexts, 0, index);
                System.arraycopy(this.texts, index, newTexts, index + 1, columnCount - index - 1);
                this.texts = newTexts;
            }
            if (index == 0) {
                this.texts[1] = this.text;
                this.text = "";
            }
            if (columnCount == 2) {
                this.images = new Image[2];
            } else {
                Image[] newImages = new Image[columnCount];
                System.arraycopy(this.images, 0, newImages, 0, index);
                System.arraycopy(this.images, index, newImages, index + 1, columnCount - index - 1);
                this.images = newImages;
            }
            if (index == 0) {
                this.images[1] = this.image;
                this.image = null;
            }
        }
        int i = 0;
        while (i < this.itemHolder.size()) {
            TreeItem child = (TreeItem)this.itemHolder.getItem(i);
            child.addColumn(column);
            ++i;
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImage(int columnIndex, Image value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            this.error(5);
        }
        TreeColumn[] columns = (TreeColumn[])this.parent.columnHolder.getItems();
        int validColumnCount = Math.max(1, columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        Image image = this.getImage(columnIndex, false);
        if (value == image) {
            return;
        }
        if (value != null && value.equals(image)) {
            return;
        }
        if (columnIndex == 0) {
            super.setImage(value);
        } else {
            this.images[columnIndex] = value;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.parent.getColumnCount() == 0) {
            this.parent.updateScrollBars();
        }
    }

    public void setImage(Image[] value) {
        this.checkWidget();
        if (value == null) {
            this.error(4);
        }
        int i = 0;
        while (i < value.length) {
            if (value[i] != null && value[i].isDisposed()) {
                this.error(5);
            }
            ++i;
        }
        i = 0;
        while (i < value.length) {
            if (value[i] != null) {
                this.setImage(i, value[i]);
            }
            ++i;
        }
    }

    public void clearAll(boolean recursive) {
        this.clearAll(recursive, true);
    }

    void clearAll(boolean recursive, boolean doVisualUpdate) {
        this.checkWidget();
        if (this.itemHolder.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.itemHolder.size()) {
            TreeItem treeItem = (TreeItem)this.itemHolder.getItem(i);
            treeItem.clear();
            if (recursive) {
                treeItem.clearAll(true, false);
            }
            if ((this.parent.style & 0x10000000) == 0) {
                this.parent.checkData(treeItem, treeItem.index);
            }
            ++i;
        }
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return (TreeItem[])this.itemHolder.getItems();
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        return (TreeItem)this.itemHolder.getItem(index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemHolder.size();
    }

    public int indexOf(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        return this.itemHolder.indexOf(item);
    }

    public void removeAll() {
        this.checkWidget();
        TreeItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
    }

    public void setItemCount(int count) {
        this.checkWidget();
        this.parent.setItemCount(count, this);
    }

    boolean isCached() {
        boolean result = true;
        if ((this.parent.getStyle() & 0x10000000) != 0) {
            result = this.cached;
        }
        return result;
    }

    final void releaseChildren() {
        TreeItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
    }

    final void releaseParent() {
        if (this.parentItem != null) {
            ItemHolder.removeItem(this.parentItem, this);
        } else {
            ItemHolder.removeItem(this.parent, this);
        }
        this.parent.removeFromSelection(this);
        this.parent.updateScrollBars();
        super.releaseParent();
    }

    int getInnerHeight() {
        int innerHeight = this.getItemCount() * 16;
        int i = 0;
        while (i < this.getItemCount()) {
            TreeItem item = this.getItem(i);
            if (item.getExpanded()) {
                innerHeight += item.getInnerHeight();
            }
            ++i;
        }
        return innerHeight;
    }

    int getMaxInnerWidth(TreeItem[] items, int level) {
        int maxInnerWidth = 0;
        int i = 0;
        while (i < items.length) {
            if (items[i] != null && items[i].isCached()) {
                int itemWidth = items[i].getPreferredWidth(0, false) + level * 19;
                maxInnerWidth = Math.max(maxInnerWidth, itemWidth);
                if (items[i].getExpanded()) {
                    int innerWidth = this.getMaxInnerWidth(items[i].getItems(), level + 1);
                    maxInnerWidth = Math.max(maxInnerWidth, innerWidth);
                }
            }
            ++i;
        }
        return maxInnerWidth;
    }

    final int getCheckWidth(int index) {
        int result = 0;
        if (index == 0 && this.parent.getColumnCount() == 0) {
            result = this.parent.getCheckWidth();
        } else {
            int[] columnOrder = this.parent.getColumnOrder();
            if (columnOrder[0] == index) {
                result = this.parent.getCheckWidth();
            }
        }
        return result;
    }

    private final class TreeItemAdapter
    implements ITreeItemAdapter,
    IWidgetFontAdapter,
    IWidgetColorAdapter {
        private TreeItemAdapter() {
        }

        public Color getUserBackgound() {
            return TreeItem.this.background;
        }

        public Color getUserForegound() {
            return TreeItem.this.foreground;
        }

        public Font getUserFont() {
            return TreeItem.this.font;
        }

        public Color[] getCellBackgrounds() {
            Color[] backgrounds = null;
            if (TreeItem.this.cellBackgrounds != null) {
                backgrounds = (Color[])TreeItem.this.cellBackgrounds.clone();
            }
            return backgrounds;
        }

        public Color[] getCellForegrounds() {
            Color[] foregrounds = null;
            if (TreeItem.this.cellForegrounds != null) {
                foregrounds = (Color[])TreeItem.this.cellForegrounds.clone();
            }
            return foregrounds;
        }

        public Font[] getCellFonts() {
            Font[] fonts = null;
            if (TreeItem.this.cellFonts != null) {
                fonts = (Font[])TreeItem.this.cellFonts.clone();
            }
            return fonts;
        }
    }
}

