/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.common.utilities;

import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.sequoyah.device.common.utilities.logger.ILogger;
import org.eclipse.sequoyah.device.common.utilities.logger.LoggerFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePlugin
extends AbstractUIPlugin {
    private static BasePlugin baseInst = null;
    protected static ILogger log = null;
    private Hashtable<String, ImageDescriptor> imageDescriptorRegistry = null;
    private boolean headless;
    private boolean headlessSet;

    public static BasePlugin getBaseDefault() {
        return baseInst;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = BasePlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getShell();
        }
        Display display = Display.getCurrent();
        if (display != null) {
            return display.getActiveShell();
        }
        display = Display.getDefault();
        if (display != null) {
            return display.getActiveShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench iWorkbench = null;
        try {
            iWorkbench = BasePlugin.getBaseDefault().getWorkbench();
        }
        catch (Exception exception) {
            iWorkbench = null;
        }
        if (iWorkbench != null) {
            if (Display.getCurrent() != null) {
                return iWorkbench.getActiveWorkbenchWindow();
            }
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (iWorkbenchWindowArray != null && iWorkbenchWindowArray.length > 0) {
                return iWorkbenchWindowArray[0];
            }
            return null;
        }
        return null;
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return BasePlugin.getWorkspace().getRoot();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getIconPath() {
        return "icons/";
    }

    public static ImageDescriptor getPluginImage(Bundle bundle, String string) {
        URL uRL = bundle.getEntry("/" + string);
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
        return imageDescriptor;
    }

    public static void logInfo(String string) {
        BasePlugin.getLogger().info(string);
    }

    public static void logWarning(String string) {
        BasePlugin.getLogger().warn(string);
    }

    public static void logError(String string) {
        BasePlugin.getLogger().error(string);
    }

    public static void logError(String string, Throwable throwable) {
        BasePlugin.getLogger().error(string, throwable);
    }

    public static void logDebugMessage(String string, String string2) {
        BasePlugin.getLogger().debug(String.valueOf(string) + "-" + string2);
    }

    public BasePlugin() {
        if (baseInst == null) {
            baseInst = this;
        }
        this.headless = false;
        this.headlessSet = false;
    }

    public String getSymbolicName() {
        return this.getBundle().getSymbolicName();
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
    }

    public void setLogger(ILogger iLogger) {
        log = iLogger;
    }

    public static void setDefaultLogger() {
        if (log == null) {
            log = LoggerFactory.getLogger(-1);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        BasePlugin.logDebugMessage(((Object)((Object)this)).getClass().getName(), "SHUTDOWN");
        super.stop(bundleContext);
    }

    public IWorkbench getWorkbench() {
        IWorkbench iWorkbench = null;
        if (this.headlessSet && this.headless) {
            return iWorkbench;
        }
        try {
            iWorkbench = PlatformUI.getWorkbench();
            this.headless = false;
        }
        catch (Exception exception) {
            this.headless = true;
        }
        this.headlessSet = true;
        return iWorkbench;
    }

    protected abstract void initializeImageRegistry();

    protected ImageDescriptor putImageInRegistry(String string, String string2) {
        ImageDescriptor imageDescriptor = this.getPluginImage(string2);
        Hashtable<String, ImageDescriptor> hashtable = this.getImageDescriptorRegistry();
        hashtable.put(string, imageDescriptor);
        return imageDescriptor;
    }

    public ImageDescriptor getPluginImage(String string) {
        return BasePlugin.getPluginImage(this.getBundle(), string);
    }

    public Image getImage(String string) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(string);
        if (image == null) {
            ImageDescriptor imageDescriptor = this.getImageDescriptor(string);
            if (imageDescriptor != null) {
                imageRegistry.put(string, imageDescriptor);
                image = imageRegistry.get(string);
            } else {
                BasePlugin.logError("...error retrieving image for key: " + string);
            }
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String string) {
        Hashtable<String, ImageDescriptor> hashtable = this.getImageDescriptorRegistry();
        ImageDescriptor imageDescriptor = hashtable.get(string);
        return imageDescriptor;
    }

    private Hashtable<String, ImageDescriptor> getImageDescriptorRegistry() {
        if (this.imageDescriptorRegistry == null) {
            this.imageDescriptorRegistry = new Hashtable();
            this.initializeImageRegistry();
        }
        return this.imageDescriptorRegistry;
    }

    public ImageDescriptor getImageDescriptorFromIDE(String string) {
        Hashtable<String, ImageDescriptor> hashtable = this.getImageDescriptorRegistry();
        ImageDescriptor imageDescriptor = hashtable.get(string);
        if (imageDescriptor == null) {
            String string2 = "icons/full/";
            String string3 = String.valueOf(string2) + string;
            String[] stringArray = new String[]{"org.eclipse.ui", "org.eclipse.ui.ide"};
            int n = 0;
            while (n < stringArray.length && imageDescriptor == null) {
                String string4 = stringArray[n];
                Bundle bundle = Platform.getBundle((String)string4);
                URL uRL = bundle.getResource(string3);
                if (uRL != null) {
                    imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
                }
                ++n;
            }
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            hashtable.put(string, imageDescriptor);
        }
        return imageDescriptor;
    }

    public static ILogger getLogger() {
        if (log == null) {
            BasePlugin.setDefaultLogger();
        }
        return log;
    }

    public boolean isHeadless() {
        if (!this.headlessSet) {
            this.getWorkbench();
        }
        return this.headless;
    }
}

