/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem;

import java.io.BufferedReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.elements.IPMachine;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.MachineAttributes;
import org.eclipse.ptp.rm.core.rtsystem.AbstractRemoteCommandJob;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2MachineAttributes;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2NodeAttributes;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2Plugin;
import org.eclipse.ptp.rm.mpi.mpich2.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2HostMap;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2RuntimeSystem;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2TraceParser;

public class MPICH2DiscoverJob
extends AbstractRemoteCommandJob {
    MPICH2RuntimeSystem rts;

    public MPICH2DiscoverJob(MPICH2RuntimeSystem rts, IProgressMonitor monitor) {
        super((AbstractToolRuntimeSystem)rts, NLS.bind((String)Messages.MPICH2DiscoverJob_name, (Object)rts.getRmConfiguration().getName()), rts.retrieveEffectiveToolRmConfiguration().getDiscoverCmd(), Messages.MPICH2DiscoverJob_interruptedErrorMessage, Messages.MPICH2DiscoverJob_processErrorMessage, Messages.MPICH2DiscoverJob_parsingErrorMessage, monitor);
        this.rts = rts;
    }

    protected IStatus parse(BufferedReader output) {
        IResourceManager rm = PTPCorePlugin.getDefault().getUniverse().getResourceManager(this.rts.getRmID());
        String machineID = this.rts.createMachine(rm.getName());
        this.rts.setMachineID(machineID);
        String queueID = this.rts.createQueue(Messages.MPICH2DiscoverJob_defaultQueueName);
        this.rts.setQueueID(queueID);
        IPMachine machine = rm.getMachineById(machineID);
        assert (machine != null);
        try {
            MPICH2TraceParser parser = new MPICH2TraceParser();
            MPICH2HostMap hostMap = parser.parse(output);
            if (hostMap == null) {
                machine.addAttribute((IAttribute)MachineAttributes.getStateAttributeDefinition().create((Enum)MachineAttributes.State.ERROR));
                machine.addAttribute((IAttribute)MPICH2MachineAttributes.getStatusMessageAttributeDefinition().create(Messages.MPICH2DiscoverJob_Exception_HostFileParseError));
                return new Status(4, MPICH2Plugin.getDefault().getBundle().getSymbolicName(), parser.getErrorMessage());
            }
            int nodeCounter = 0;
            MPICH2HostMap.Host[] hostArray = hostMap.getHosts();
            int n = hostArray.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeManager attrManager;
                String nodeId;
                MPICH2HostMap.Host host;
                block8: {
                    host = hostArray[n2];
                    nodeId = this.rts.createNode(machineID, host.getName(), nodeCounter++);
                    attrManager = new AttributeManager();
                    if (host.getNumProcessors() != 0) {
                        try {
                            attrManager.addAttribute((IAttribute)MPICH2NodeAttributes.getNumberOfNodesAttributeDefinition().create(Integer.valueOf(host.getNumProcessors())));
                        }
                        catch (IllegalValueException illegalValueException) {
                            if ($assertionsDisabled) break block8;
                            throw new AssertionError();
                        }
                    }
                }
                this.rts.changeNode(nodeId, attrManager);
                this.rts.setNodeIDForName(host.getName(), nodeId);
                ++n2;
            }
        }
        catch (Exception e) {
            AttributeManager attrManager = new AttributeManager();
            attrManager.addAttribute((IAttribute)MachineAttributes.getStateAttributeDefinition().create((Enum)MachineAttributes.State.ERROR));
            attrManager.addAttribute((IAttribute)MPICH2MachineAttributes.getStatusMessageAttributeDefinition().create(NLS.bind((String)Messages.MPICH2DiscoverJob_Exception_DiscoverCommandInternalError, (Object)e.getMessage())));
            this.rts.changeMachine(machineID, attrManager);
            return new Status(4, MPICH2Plugin.getDefault().getBundle().getSymbolicName(), NLS.bind((String)Messages.MPICH2DiscoverJob_Exception_DiscoverCommandInternalError, (Object)e.getMessage()), (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

