/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.core.attributes.AttributeDefinitionManager;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ptp.rm.core.rmsystem.AbstractEffectiveToolRMConfiguration;
import org.eclipse.ptp.rm.core.rmsystem.IToolRMConfiguration;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.mpi.mpich2.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.mpich2.core.rmsystem.EffectiveMPICH2ResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpi.mpich2.core.rmsystem.IMPICH2ResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2DiscoverJob;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2PeriodicJob;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2RuntimeSystemJob;

public class MPICH2RuntimeSystem
extends AbstractToolRuntimeSystem {
    private String machineID;
    private String queueID;
    private Map<String, String> nodeNameToIDMap = new HashMap<String, String>();

    public MPICH2RuntimeSystem(Integer rmid, IMPICH2ResourceManagerConfiguration config, AttributeDefinitionManager attrDefMgr) {
        super(rmid, (IToolRMConfiguration)config, attrDefMgr);
    }

    public Job createRuntimeSystemJob(String jobID, String queueID, AttributeManager attrMgr) {
        return new MPICH2RuntimeSystemJob(jobID, queueID, Messages.MPICH2RuntimeSystem_JobName, this, attrMgr);
    }

    public String getMachineID() {
        return this.machineID;
    }

    public String getNodeIDforName(String hostname) {
        return this.nodeNameToIDMap.get(hostname);
    }

    public String getQueueID() {
        return this.queueID;
    }

    public AbstractEffectiveToolRMConfiguration retrieveEffectiveToolRmConfiguration() {
        return new EffectiveMPICH2ResourceManagerConfiguration(this.getRmConfiguration());
    }

    public void setNodeIDForName(String hostname, String nodeID) {
        this.nodeNameToIDMap.put(hostname, nodeID);
    }

    protected Job createContinuousMonitorJob(IProgressMonitor monitor) {
        return null;
    }

    protected Job createDiscoverJob(IProgressMonitor monitor) {
        if (!this.rmConfiguration.hasDiscoverCmd()) {
            return null;
        }
        MPICH2DiscoverJob job = new MPICH2DiscoverJob(this, monitor);
        job.setPriority(10);
        job.setSystem(false);
        job.setUser(false);
        return job;
    }

    protected Job createPeriodicMonitorJob(IProgressMonitor monitor) {
        if (!this.rmConfiguration.hasPeriodicMonitorCmd()) {
            return null;
        }
        MPICH2PeriodicJob job = new MPICH2PeriodicJob(this, monitor);
        job.setPriority(10);
        job.setSystem(false);
        job.setUser(false);
        return job;
    }

    protected void doFilterEvents(IPElement element, boolean filterChildren, AttributeManager filterAttributes) throws CoreException {
    }

    protected void doShutdown() throws CoreException {
    }

    protected void doStartEvents() throws CoreException {
    }

    protected void doStartup(IProgressMonitor monitor) throws CoreException {
    }

    protected void doStopEvents() throws CoreException {
    }

    protected void setMachineID(String machineID) {
        this.machineID = machineID;
    }

    protected void setQueueID(String queueID) {
        this.queueID = queueID;
    }
}

