/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.pulsar.internal.core;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sequoyah.pulsar.core.Activator;
import org.eclipse.sequoyah.pulsar.internal.core.Messages;
import org.eclipse.sequoyah.pulsar.internal.core.SDKRepository;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.IInstallationEnvironment;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.IInstallationInfo;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.ISDKRepository;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.ISDKRepositoryProvider;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSDKRepositoryProvider
implements ISDKRepositoryProvider {
    private static final String NAME_KEY_SUFFIX = ".name";
    private static final String METADATA_KEY_SUFFIX = ".metadata";
    private static final String ARTIFACTS_KEY_SUFFIX = ".artifacts";
    private static final String IMAGE_KEY_SUFFIX = ".image";
    private static final String INFO_URL_SUFFIX = ".info.url";
    private static final String INFO_IMAGE_SUFFIX = ".info.image";
    private static final String INFO_TEXT_SUFFIX = ".info.description";
    private URL repositoriesFileUrl;

    public DefaultSDKRepositoryProvider() {
        URL[] uRLArray = FileLocator.findEntries((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("repositories/repositories.properties"));
        this.repositoriesFileUrl = uRLArray[0];
    }

    @Override
    public Collection<ISDKRepository> getRepositories() {
        HashSet<ISDKRepository> hashSet = new HashSet<ISDKRepository>();
        try {
            Properties properties = new Properties();
            InputStream inputStream = this.repositoriesFileUrl.openStream();
            properties.load(inputStream);
            for (Object object : properties.keySet()) {
                String string = object.toString();
                if (!string.endsWith(NAME_KEY_SUFFIX)) continue;
                try {
                    String string2 = properties.getProperty(string);
                    String string3 = string.substring(0, string.lastIndexOf(NAME_KEY_SUFFIX));
                    URL uRL = new URL(properties.getProperty(String.valueOf(string3) + METADATA_KEY_SUFFIX));
                    URL uRL2 = new URL(properties.getProperty(String.valueOf(string3) + ARTIFACTS_KEY_SUFFIX));
                    SDKRepository sDKRepository = new SDKRepository(string2, uRL.toURI(), uRL2.toURI());
                    String string4 = properties.getProperty(String.valueOf(string3) + IMAGE_KEY_SUFFIX);
                    if (string4 != null) {
                        sDKRepository.setImageDescriptorURL(new URL(string4));
                    }
                    IInstallationInfo iInstallationInfo = this.readRepositoryInfo(string3, properties);
                    sDKRepository.setInstallationInfo(iInstallationInfo);
                    hashSet.add(sDKRepository);
                }
                catch (MalformedURLException malformedURLException) {
                    Activator.logError(Messages.DefaultSDKRepositoryProvider_URLError, malformedURLException);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Activator.logError(Messages.DefaultSDKRepositoryProvider_URLError, uRISyntaxException);
                }
            }
        }
        catch (Exception exception) {
            Activator.logError(Messages.DefaultSDKRepositoryProvider_FileReadError, exception);
        }
        return hashSet;
    }

    private IInstallationInfo readRepositoryInfo(String string, Properties properties) {
        StringBuffer stringBuffer = null;
        URL uRL = null;
        URL uRL2 = null;
        try {
            String string2 = properties.getProperty(String.valueOf(string) + INFO_IMAGE_SUFFIX);
            if (string2 != null) {
                uRL = new URL(string2);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        try {
            uRL2 = new URL(properties.getProperty(String.valueOf(string) + INFO_URL_SUFFIX));
        }
        catch (MalformedURLException malformedURLException) {}
        stringBuffer = new StringBuffer(properties.getProperty(String.valueOf(string) + INFO_TEXT_SUFFIX, ""));
        return new SDKRepositoryInfo(uRL2, uRL, stringBuffer);
    }

    private class SDKRepositoryInfo
    implements IInstallationInfo {
        private URL siteUrl;
        private URL imageUrl;
        private StringBuffer text;

        public SDKRepositoryInfo(URL uRL, URL uRL2, StringBuffer stringBuffer) {
            this.siteUrl = uRL;
            this.imageUrl = uRL2;
            this.text = stringBuffer;
        }

        public ImageDescriptor getImageDescriptor() {
            ImageDescriptor imageDescriptor = null;
            if (this.imageUrl != null) {
                imageDescriptor = ImageDescriptor.createFromURL((URL)this.imageUrl);
            }
            return imageDescriptor;
        }

        public StringBuffer getDescription() {
            return this.text;
        }

        public URI getWebSiteURI() {
            URI uRI = null;
            if (this.siteUrl != null) {
                try {
                    uRI = this.siteUrl.toURI();
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            return uRI;
        }

        public IInstallationEnvironment getTargetEnvironment() {
            return null;
        }
    }
}

