/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.pulsar.internal.core;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sequoyah.pulsar.core.Activator;
import org.eclipse.sequoyah.pulsar.internal.core.Messages;
import org.eclipse.sequoyah.pulsar.internal.core.P2Utils;
import org.eclipse.sequoyah.pulsar.internal.core.SDKCategory;
import org.eclipse.sequoyah.pulsar.internal.core.SDKRepository;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.IInstallationEnvironment;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.IInstallationInfo;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.ISDK;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.ISDKCategory;
import org.eclipse.sequoyah.pulsar.internal.provisional.core.IUInstallationEnvironment;

public class SDK
extends PlatformObject
implements ISDK {
    public static final String PROP_TYPE = "org.eclipse.pulsar.type";
    public static final String ZIPARCHIVE_TYPE = "ziparchive";
    public static final String EXECUTABLE_TYPE = "executable";
    public static final String OSGI_BUNDLE_TYPE = "osgi-bundle";
    public static final String PROP_CATEGORY = "org.eclipse.pulsar.category.name";
    public static final String PROP_CATEGORY_DESC = "org.eclipse.pulsar.category.description";
    public static final String PROP_DOC_URL = "org.eclipse.pulsar.documentation.url";
    public static final String PROP_DESCRIPTION = "org.eclipse.equinox.p2.description";
    private SDKRepository sdkRepository;
    private IInstallableUnit iu;
    private IInstallationInfo info;

    public SDK(SDKRepository sDKRepository, IInstallableUnit iInstallableUnit) {
        this.sdkRepository = sDKRepository;
        this.iu = iInstallableUnit;
    }

    public String getName() {
        return this.iu.getProperty("org.eclipse.equinox.p2.name");
    }

    public ISDK.EState getState() {
        return P2Utils.isInstalled(this.iu) ? ISDK.EState.INSTALLED : ISDK.EState.UNINSTALLED;
    }

    public Version getVersion() {
        return this.iu.getVersion();
    }

    public ISDK.EType getType() {
        String string = this.iu.getProperty(PROP_TYPE);
        if (string.equals(ZIPARCHIVE_TYPE)) {
            return ISDK.EType.ZIP_ARCHIVE;
        }
        if (string.equals(EXECUTABLE_TYPE)) {
            return ISDK.EType.EXECUTABLE;
        }
        if (string.equals(OSGI_BUNDLE_TYPE)) {
            return ISDK.EType.OSGI_BUNDLE;
        }
        return ISDK.EType.UNKNOWN;
    }

    public ISDKCategory getCategory() {
        String string = this.iu.getProperty(PROP_CATEGORY);
        if (string != null) {
            String string2 = this.iu.getProperty(PROP_CATEGORY_DESC);
            if (string2 == null && this.getRepository() != null && this.getRepository().getInstallationInfo() != null && this.getRepository().getInstallationInfo().getDescription() != null) {
                string2 = this.getRepository().getInstallationInfo().getDescription().toString();
            }
            return new SDKCategory(string, string2, this.getRepository().getInstallationInfo());
        }
        return null;
    }

    public URL getDocumentationURL() {
        String string = this.iu.getProperty(PROP_DOC_URL);
        if (string != null) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                Activator.logError(Messages.SDK_DocumentationURLError, malformedURLException);
            }
        }
        return null;
    }

    public IInstallableUnit getInstallableUnit() {
        return this.iu;
    }

    public SDKRepository getRepository() {
        return this.sdkRepository;
    }

    public IInstallationInfo getInstallationInfo() {
        if (this.info == null) {
            this.info = new SDKInfo(this);
        }
        return this.info;
    }

    private class SDKInfo
    implements IInstallationInfo {
        private SDK sdk;

        public SDKInfo(SDK sDK2) {
            if (sDK2 == null) {
                throw new IllegalArgumentException(Messages.SDK_InvalidSDKInstanceError);
            }
            this.sdk = sDK2;
        }

        public StringBuffer getDescription() {
            String string;
            StringBuffer stringBuffer = null;
            IInstallableUnit iInstallableUnit = this.sdk.getInstallableUnit();
            if (iInstallableUnit != null && (string = iInstallableUnit.getProperty(SDK.PROP_DESCRIPTION)) != null) {
                stringBuffer = new StringBuffer(string);
            }
            return stringBuffer;
        }

        public ImageDescriptor getImageDescriptor() {
            ImageDescriptor imageDescriptor = null;
            IInstallationInfo iInstallationInfo = this.sdk.getRepository().getInstallationInfo();
            if (iInstallationInfo != null) {
                imageDescriptor = iInstallationInfo.getImageDescriptor();
            }
            return imageDescriptor;
        }

        public URI getWebSiteURI() {
            URI uRI = null;
            try {
                URL uRL = this.sdk.getDocumentationURL();
                if (uRL != null) {
                    uRI = uRL.toURI();
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
            return uRI;
        }

        public IInstallationEnvironment getTargetEnvironment() {
            IMatchExpression iMatchExpression;
            IInstallableUnit iInstallableUnit = this.sdk.getInstallableUnit();
            if (iInstallableUnit != null && (iMatchExpression = iInstallableUnit.getFilter()) != null) {
                return new IUInstallationEnvironment(iMatchExpression.toString());
            }
            return null;
        }
    }
}

