/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.analysis;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.pldt.common.util.SourceInfo;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.BarrierExpression;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.BarrierTable;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPIBlock;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraph;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.IControlFlowGraph;
import org.eclipse.ptp.pldt.mpi.analysis.popup.actions.ShowMatchSet;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPIBarrierMatching {
    protected ICallGraph cg_;
    protected IControlFlowGraph cfg_;
    protected MPICallGraphNode currentFunc_;
    protected String currentComm_;
    protected Hashtable<BarrierExpression, List<BarrierExpression>> visited_;
    protected BarrierTable barrierTable_;
    protected List<ErrorMessage> barrierErrors_;
    protected boolean error;
    protected int mv = 0;
    protected int sv = 0;
    private static final boolean traceOn = false;
    private boolean changed = false;
    protected final int down = 0;
    protected final int up = 1;
    protected Stack<BarrierExpression> lstack_;
    protected Stack<BarrierExpression> sstack_;
    protected LinkedList<Work> workList_;

    public MPIBarrierMatching(ICallGraph cg, BarrierTable table) {
        this.cg_ = cg;
        this.barrierTable_ = table;
        this.visited_ = new Hashtable();
        this.barrierErrors_ = new ArrayList<ErrorMessage>();
    }

    public List<ErrorMessage> getErrors() {
        return this.barrierErrors_;
    }

    public void run() {
        boolean errorAlreadyReported = false;
        ICallGraphNode n = this.cg_.botEntry();
        while (n != null) {
            MPICallGraphNode node = (MPICallGraphNode)n;
            if (node.marked && node.barrierRelated()) {
                this.currentFunc_ = node;
                this.cfg_ = node.getCFG();
                Hashtable<String, BarrierExpression> barrierExpr = node.getBarrierExpr();
                Enumeration<String> e = barrierExpr.keys();
                while (e.hasMoreElements()) {
                    this.currentComm_ = e.nextElement();
                    BarrierExpression be = barrierExpr.get(this.currentComm_);
                    this.error = false;
                    this.fixedLength(be);
                    if (this.error && !errorAlreadyReported) {
                        errorAlreadyReported = true;
                        String errorMsg = "Found barrier synchronization error(s)!";
                        MessageDialog.openInformation((Shell)ShowMatchSet.getStandardDisplay().getActiveShell(), (String)"MPI Barrier Analysis", (String)errorMsg);
                    }
                    this.findMatches(be);
                }
            }
            n = n.botNext();
        }
    }

    protected void fixedLength(BarrierExpression BE) {
        BarrierExpression.BarrierExpressionOP OP = BE.getOP();
        if (OP == null) {
            if (BE.isBot()) {
                BE.setLength(0);
            } else if (BE.isBarrier()) {
                BE.setLength(1);
            } else {
                String funcName = BE.getFuncName();
                MPICallGraphNode fnode = (MPICallGraphNode)this.cg_.getNode(this.currentFunc_.getFileName(), funcName);
                if (fnode != null && fnode.barrierRelated()) {
                    if (fnode.isRecursive()) {
                        BE.setLength(-3);
                    } else {
                        BarrierExpression fBE = fnode.getBarrierExpr().get(this.currentComm_);
                        BE.setLength(fBE.getLength());
                    }
                } else {
                    BE.setLength(0);
                }
            }
        } else if (OP.getOperator() == 1) {
            BarrierExpression oprd1 = BE.getOP1();
            BarrierExpression oprd2 = BE.getOP2();
            this.fixedLength(oprd1);
            this.fixedLength(oprd2);
            int length1 = oprd1.getLength();
            int length2 = oprd2.getLength();
            if (length1 == -3 || length2 == -3) {
                BE.setLength(-3);
            } else {
                BE.setLength(length1 + length2);
            }
        } else if (OP.getOperator() == 3) {
            BarrierExpression oprd1 = BE.getOP1();
            BarrierExpression oprd2 = BE.getOP2();
            this.fixedLength(oprd1);
            this.fixedLength(oprd2);
            int length1 = oprd1.getLength();
            int length2 = oprd2.getLength();
            MPIBlock cond = (MPIBlock)this.cfg_.getBlock(OP.getCondition(), OP.getStatement());
            if (cond.getMV()) {
                ++this.mv;
            } else {
                ++this.sv;
            }
            if (length1 == -3 || length2 == -3) {
                BE.setLength(-3);
                if (cond.getMV()) {
                    BE.setErrorFlag(true);
                    if (!oprd1.getErrorFlag() && !oprd2.getErrorFlag()) {
                        this.reportWarning(BE);
                    }
                }
            } else if (length1 == length2) {
                BE.setLength(length1);
            } else {
                BE.setLength(-3);
                if (cond.getMV()) {
                    BE.setErrorFlag(true);
                    if (!oprd1.getErrorFlag() && !oprd2.getErrorFlag()) {
                        this.reportWarning(BE);
                    }
                }
            }
        } else {
            BarrierExpression oprd = BE.getOP1();
            this.fixedLength(oprd);
            MPIBlock cond = (MPIBlock)this.cfg_.getBlock(OP.getCondition(), OP.getStatement());
            if (cond.getMV()) {
                ++this.mv;
            } else {
                ++this.sv;
            }
            if (oprd.getLength() == 0) {
                BE.setLength(0);
            } else {
                BE.setLength(-3);
                if (cond.getMV()) {
                    BE.setErrorFlag(true);
                    if (!oprd.getErrorFlag()) {
                        this.reportWarning(BE);
                    }
                }
            }
        }
    }

    protected void reportWarning(BarrierExpression BE) {
        this.error = true;
        IASTStatement stmt = BE.getOP().getStatement();
        IASTExpression cond = null;
        if (stmt instanceof IASTIfStatement) {
            cond = ((IASTIfStatement)stmt).getConditionExpression();
        } else if (stmt instanceof IASTDoStatement) {
            cond = ((IASTDoStatement)stmt).getCondition();
        } else if (stmt instanceof IASTForStatement) {
            cond = ((IASTForStatement)stmt).getConditionExpression();
        } else if (stmt instanceof IASTWhileStatement) {
            cond = ((IASTWhileStatement)stmt).getCondition();
        } else if (stmt instanceof IASTSwitchStatement) {
            cond = ((IASTSwitchStatement)stmt).getControllerExpression();
        } else {
            System.out.println("Barrier Expression doesn't have valid condition");
            return;
        }
        int line = -1;
        IASTNodeLocation[] locations = cond.getNodeLocations();
        if (locations.length == 1) {
            IASTFileLocation astFileLocation = null;
            if (locations[0] instanceof IASTFileLocation) {
                astFileLocation = (IASTFileLocation)locations[0];
                line = astFileLocation.getStartingLineNumber();
            }
        }
        try {
            IMarker m = this.currentFunc_.getResource().createMarker("org.eclipse.ptp.pldt.mpi.analysis.errorMarker");
            m.setAttribute("lineNumber", line);
            m.setAttribute("message", (Object)"Barrier Synchronization Error");
            m.setAttribute("priority", 2);
            m.setAttribute("severity", 2);
        }
        catch (CoreException e) {
            System.out.println("RM: exception creating markers.");
            e.printStackTrace();
        }
        ErrorMessage err = new ErrorMessage(cond, stmt, this.currentFunc_.getFuncName(), this.currentFunc_.getFileName(), this.currentFunc_.getResource());
        this.counterExample(BE, err);
        this.barrierErrors_.add(err);
    }

    protected void counterExample(BarrierExpression BE, ErrorMessage err) {
        block8: {
            BarrierExpression.BarrierExpressionOP op;
            block7: {
                op = BE.getOP();
                if (op.getOperator() != 3) break block7;
                ArrayList<PathNode> path1 = new ArrayList<PathNode>();
                ArrayList<PathNode> path2 = new ArrayList<PathNode>();
                boolean first = true;
                while (true) {
                    this.changed = false;
                    this.traverseBarrierExpr(path1, BE.getOP1(), this.cfg_);
                    this.traverseBarrierExpr(path2, BE.getOP2(), this.cfg_);
                    if (this.differentLength(path1, path2)) break;
                    if (!this.changed && !first) {
                        System.out.println("We cannot find the counter example!");
                    }
                    if (first) {
                        first = true;
                    }
                    path1 = new ArrayList();
                    path2 = new ArrayList();
                }
                err.setPath1(path1);
                err.setPath2(path2);
                for (PathNode pn : path1) {
                    pn.print();
                }
                for (PathNode pn : path2) {
                    pn.print();
                }
                break block8;
            }
            if (op.getOperator() != 2) break block8;
            ArrayList<PathNode> path1 = new ArrayList<PathNode>();
            this.traverseBarrierExpr(path1, BE.getOP1(), this.cfg_);
            for (PathNode pn : path1) {
                pn.setRepeat(true);
            }
            err.setPath1(path1);
            for (PathNode pn : path1) {
                pn.print();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void traverseBarrierExpr(List<PathNode> path, BarrierExpression BE, IControlFlowGraph cfg) {
        BarrierExpression.BarrierExpressionOP op = BE.getOP();
        if (op == null) {
            if (BE.isBot()) {
                return;
            }
            if (BE.isBarrier()) {
                BarrierTable.BarrierInfo barrier = this.barrierTable_.searchBarrierbyID(BE.getBarrierID());
                PathNode pn = new PathNode(barrier, false);
                path.add(pn);
            } else {
                String funcName = BE.getFuncName();
                MPICallGraphNode fnode = (MPICallGraphNode)this.cg_.getNode(this.currentFunc_.getFileName(), funcName);
                if (fnode == null || !fnode.barrierRelated()) return;
                BarrierExpression fBE = fnode.getBarrierExpr().get(this.currentComm_);
                this.traverseBarrierExpr(path, fBE, fnode.getCFG());
            }
        } else if (op.getOperator() == 3) {
            MPIBlock cond = (MPIBlock)cfg.getBlock(op.getCondition(), op.getStatement());
            if (cond.getMV()) {
                this.traverseBarrierExpr(path, BE.getOP1(), cfg);
            } else if (BE.getLength() != -3) {
                this.traverseBarrierExpr(path, BE.getOP1(), cfg);
            } else if (this.changed) {
                if (BE.getOP2().ceVisited) {
                    this.traverseBarrierExpr(path, BE.getOP2(), cfg);
                } else {
                    this.traverseBarrierExpr(path, BE.getOP1(), cfg);
                }
            } else if (BE.getOP2().ceVisited) {
                this.traverseBarrierExpr(path, BE.getOP2(), cfg);
            } else if (BE.getOP1().ceVisited) {
                this.traverseBarrierExpr(path, BE.getOP2(), cfg);
                this.changed = true;
            } else {
                this.traverseBarrierExpr(path, BE.getOP1(), cfg);
            }
        } else if (op.getOperator() == 1) {
            this.traverseBarrierExpr(path, BE.getOP1(), cfg);
            this.traverseBarrierExpr(path, BE.getOP2(), cfg);
        } else if (op.getOperator() == 2) {
            this.traverseBarrierExpr(path, BE.getOP1(), cfg);
            for (PathNode pn : path) {
                pn.setRepeat(true);
            }
        }
        BE.ceVisited = true;
    }

    protected boolean differentLength(List<PathNode> path1, List<PathNode> path2) {
        if (path1.size() != path2.size()) {
            return true;
        }
        int i = 0;
        while (i < path1.size()) {
            if (path1.get(i).isRepeat() || path2.get(i).isRepeat()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void findMatches(BarrierExpression BE) {
        BarrierExpression.BarrierExpressionOP OP = BE.getOP();
        if (BE.visited) {
            return;
        }
        BE.visited = true;
        if (OP == null) {
            if (BE.isFunc()) {
                String funcName = BE.getFuncName();
                MPICallGraphNode fnode = (MPICallGraphNode)this.cg_.getNode(this.currentFunc_.getFileName(), funcName);
                if (fnode != null && fnode.barrierRelated()) {
                    BarrierExpression fBE = fnode.getBarrierExpr().get(this.currentComm_);
                    this.findMatches(fBE);
                }
            } else {
                this.lstack_ = new Stack();
                this.sstack_ = new Stack();
                this.workList_ = new LinkedList();
                this.match(BE, BE, 0);
                while (!this.workList_.isEmpty()) {
                    Work w = this.workList_.remove();
                    this.match(w.BE1_, w.BE2_, w.direction);
                }
            }
        } else if (OP.getOperator() == 1) {
            BarrierExpression oprd1 = BE.getOP1();
            BarrierExpression oprd2 = BE.getOP2();
            this.findMatches(oprd1);
            this.findMatches(oprd2);
        } else if (OP.getOperator() == 3) {
            BarrierExpression oprd1 = BE.getOP1();
            BarrierExpression oprd2 = BE.getOP2();
            MPIBlock cond = (MPIBlock)this.cfg_.getBlock(OP.getCondition(), OP.getStatement());
            if (cond.getMV() && !BE.getErrorFlag()) {
                this.lstack_ = new Stack();
                this.sstack_ = new Stack();
                this.workList_ = new LinkedList();
                this.match(oprd1, oprd2, 0);
                while (!this.workList_.isEmpty()) {
                    Work w = this.workList_.remove();
                    this.match(w.BE1_, w.BE2_, w.direction);
                }
            }
            if (!BE.getErrorFlag()) {
                this.findMatches(oprd1);
                this.findMatches(oprd2);
            }
        } else if (!BE.getErrorFlag()) {
            BarrierExpression oprd = BE.getOP1();
            this.findMatches(oprd);
        }
    }

    protected void match(BarrierExpression BE1, BarrierExpression BE2, int dir) {
        BarrierExpression T1 = BE1;
        BarrierExpression T2 = BE2;
        int direction = dir;
        while (true) {
            BarrierExpression fBE;
            MPICallGraphNode fnode;
            String funcName;
            if (direction == 0) {
                // empty if block
            }
            if (direction == 0 && !this.pairVisited(T1, T2)) {
                this.addVisitedPair(T1, T2);
            }
            BarrierExpression.BarrierExpressionOP OP1 = T1.getOP();
            BarrierExpression.BarrierExpressionOP OP2 = T2.getOP();
            if (direction == 1 && T1 == BE1 && T2 == BE2) break;
            if (direction == 0 && OP1 == null && OP2 == null && T1.isBot() && T2.isBot()) {
                direction = 1;
                continue;
            }
            if (direction == 0 && OP1 == null && OP2 == null && T1.isBarrier() && T2.isBarrier()) {
                this.addMatchedPair(T1, T2);
                this.addMatchedPair(T1, T1);
                this.addMatchedPair(T2, T2);
                direction = 1;
                continue;
            }
            if (direction == 0 && OP1 == null && T1.isFunc()) {
                funcName = T1.getFuncName();
                fnode = (MPICallGraphNode)this.cg_.getNode(this.currentFunc_.getFileName(), funcName);
                if (fnode == null || !fnode.barrierRelated()) {
                    System.out.println("Error in call graph");
                }
                fBE = fnode.getBarrierExpr().get(this.currentComm_);
                this.lstack_.push(T1);
                T1 = fBE;
                continue;
            }
            if (direction == 0 && OP2 == null && T2.isFunc()) {
                funcName = T2.getFuncName();
                fnode = (MPICallGraphNode)this.cg_.getNode(this.currentFunc_.getFileName(), funcName);
                if (fnode == null || !fnode.barrierRelated()) {
                    System.out.println("Error in call graph");
                }
                fBE = fnode.getBarrierExpr().get(this.currentComm_);
                this.sstack_.push(T2);
                T2 = fBE;
                continue;
            }
            if (direction == 0 && OP1 != null && OP1.getOperator() == 1) {
                T1 = T1.getOP1();
                continue;
            }
            if (direction == 0 && OP2 != null && OP2.getOperator() == 1) {
                T2 = T2.getOP1();
                continue;
            }
            if (direction == 1 && T1.getParent() == null) {
                T1 = this.lstack_.pop();
                continue;
            }
            if (direction == 1 && T2.getParent() == null) {
                T2 = this.sstack_.pop();
                continue;
            }
            if (direction == 1 && T1.getParent().getOP().getOperator() == 1 && T1 == T1.getParent().getOP2()) {
                T1 = T1.getParent();
                direction = 1;
                continue;
            }
            if (direction == 1 && T2.getParent().getOP().getOperator() == 1 && T2 == T2.getParent().getOP2()) {
                T2 = T2.getParent();
                direction = 1;
                continue;
            }
            if (direction == 1 && T1.getParent().getOP().getOperator() == 1 && T1 == T1.getParent().getOP1() && T2.getParent().getOP().getOperator() == 1 && T2 == T2.getParent().getOP1()) {
                T1 = T1.getParent().getOP2();
                T2 = T2.getParent().getOP2();
                direction = 0;
                continue;
            }
            if (direction == 0 && OP1 != null && OP1.getOperator() == 3) {
                this.workList_.add(new Work(T1.getOP2(), T2, 0));
                T1 = T1.getOP1();
                continue;
            }
            if (direction == 0 && OP2 != null && OP2.getOperator() == 3) {
                this.workList_.add(new Work(T1, T2.getOP2(), 0));
                T2 = T2.getOP1();
                continue;
            }
            if (direction == 1 && T1.getParent().getOP().getOperator() == 3) {
                T1 = T1.getParent();
                continue;
            }
            if (direction == 1 && T2.getParent().getOP().getOperator() == 3) {
                T2 = T2.getParent();
                continue;
            }
            System.out.println("cannot find rules for " + T1.prettyPrinter() + " and " + T2.prettyPrinter() + " and direction = " + direction);
        }
    }

    protected void addVisitedPair(BarrierExpression b1, BarrierExpression b2) {
        List<BarrierExpression> visitedPair = this.visited_.get(b1);
        if (visitedPair == null) {
            visitedPair = new ArrayList<BarrierExpression>();
            visitedPair.add(b2);
            this.visited_.put(b1, visitedPair);
        } else if (!visitedPair.contains(b2)) {
            visitedPair.add(b2);
        }
        visitedPair = this.visited_.get(b2);
        if (visitedPair == null) {
            visitedPair = new ArrayList<BarrierExpression>();
            visitedPair.add(b1);
            this.visited_.put(b2, visitedPair);
        } else if (!visitedPair.contains(b1)) {
            visitedPair.add(b1);
        }
    }

    protected boolean pairVisited(BarrierExpression b1, BarrierExpression b2) {
        List<BarrierExpression> pair = this.visited_.get(b1);
        return pair != null && pair.contains(b2);
    }

    protected void addMatchedPair(BarrierExpression b1, BarrierExpression b2) {
        BarrierTable.BarrierInfo bar1 = this.barrierTable_.searchBarrierbyID(b1.getBarrierID());
        BarrierTable.BarrierInfo bar2 = this.barrierTable_.searchBarrierbyID(b2.getBarrierID());
        List<BarrierTable.BarrierInfo> set1 = bar1.getMatchingSet();
        List<BarrierTable.BarrierInfo> set2 = bar2.getMatchingSet();
        if (!set1.contains(bar2)) {
            set1.add(bar2);
        }
        if (!set2.contains(bar1)) {
            set2.add(bar1);
        }
    }

    protected void symmMatches() {
        Enumeration<List<BarrierTable.BarrierInfo>> e = this.barrierTable_.getTable().elements();
        while (e.hasMoreElements()) {
            List<BarrierTable.BarrierInfo> list = e.nextElement();
            for (BarrierTable.BarrierInfo bar : list) {
                for (BarrierTable.BarrierInfo matchedBar : bar.getMatchingSet()) {
                    if (matchedBar.getMatchingSet().contains(bar)) continue;
                    matchedBar.getMatchingSet().add(bar);
                }
            }
        }
    }

    protected void printMatches() {
        Enumeration<List<BarrierTable.BarrierInfo>> e = this.barrierTable_.getTable().elements();
        while (e.hasMoreElements()) {
            List<BarrierTable.BarrierInfo> list = e.nextElement();
            for (BarrierTable.BarrierInfo bar : list) {
                Iterator<BarrierTable.BarrierInfo> ii = bar.getMatchingSet().iterator();
                while (ii.hasNext()) {
                    ii.next();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ErrorMessage {
        private IASTExpression position_;
        private IASTStatement errStmt_;
        private String funcName_;
        private String fileName_;
        private SourceInfo sourceInfo_;
        private SourceInfo path1SourceInfo_;
        private SourceInfo path2SourceInfo_;
        private IResource resource_;
        private List<PathNode> path1_ = null;
        private List<PathNode> path2_ = null;
        private int length1 = 0;
        private int length2 = 0;

        public ErrorMessage(IASTExpression pos, IASTStatement stmt, String funcName, String fileName, IResource res) {
            this.position_ = pos;
            this.errStmt_ = stmt;
            this.funcName_ = funcName;
            this.fileName_ = fileName;
            this.resource_ = res;
            this.sourceInfo_ = this.getSourceInfo((IASTNode)this.position_);
            if (this.errStmt_ instanceof IASTIfStatement) {
                IASTIfStatement ifS = (IASTIfStatement)this.errStmt_;
                this.path1SourceInfo_ = this.getSourceInfo((IASTNode)ifS.getThenClause());
                this.path2SourceInfo_ = this.getSourceInfo((IASTNode)ifS.getElseClause());
            } else if (this.errStmt_ instanceof IASTDoStatement) {
                IASTDoStatement doS = (IASTDoStatement)this.errStmt_;
                this.path1SourceInfo_ = this.getSourceInfo((IASTNode)doS.getBody());
                this.path2SourceInfo_ = null;
            } else if (this.errStmt_ instanceof IASTForStatement) {
                IASTForStatement forS = (IASTForStatement)this.errStmt_;
                this.path1SourceInfo_ = this.getSourceInfo((IASTNode)forS.getBody());
                this.path2SourceInfo_ = null;
            } else if (this.errStmt_ instanceof IASTWhileStatement) {
                IASTWhileStatement whileS = (IASTWhileStatement)this.errStmt_;
                this.path1SourceInfo_ = this.getSourceInfo((IASTNode)whileS.getBody());
                this.path2SourceInfo_ = null;
            } else if (this.errStmt_ instanceof IASTSwitchStatement) {
                IASTSwitchStatement switchS = (IASTSwitchStatement)this.errStmt_;
                this.path2SourceInfo_ = this.path1SourceInfo_ = this.getSourceInfo((IASTNode)switchS.getBody());
            }
        }

        SourceInfo getSourceInfo(IASTNode node) {
            SourceInfo sourceInfo = new SourceInfo();
            if (node == null) {
                return sourceInfo;
            }
            IASTNodeLocation[] locations = node.getNodeLocations();
            if (locations.length == 1) {
                IASTFileLocation astFileLocation = null;
                if (locations[0] instanceof IASTFileLocation) {
                    astFileLocation = (IASTFileLocation)locations[0];
                    sourceInfo.setStartingLine(astFileLocation.getStartingLineNumber());
                    sourceInfo.setStart(astFileLocation.getNodeOffset());
                    sourceInfo.setEnd(astFileLocation.getNodeOffset() + astFileLocation.getNodeLength());
                    sourceInfo.setConstructType(0);
                }
            }
            return sourceInfo;
        }

        public void setPath1(List<PathNode> path) {
            this.path1_ = path;
            int count = 0;
            for (PathNode pn : path) {
                if (pn.isRepeat()) {
                    this.length1 = -1;
                    return;
                }
                ++count;
            }
            this.length1 = count;
        }

        public void setPath2(List<PathNode> path) {
            this.path2_ = path;
            int count = 0;
            for (PathNode pn : path) {
                if (pn.isRepeat()) {
                    this.length2 = -1;
                    return;
                }
                ++count;
            }
            this.length2 = count;
        }

        public IASTExpression getPosition() {
            return this.position_;
        }

        public String getFuncName() {
            return this.funcName_;
        }

        public String getFileName() {
            return this.fileName_;
        }

        public SourceInfo getSourceInfo() {
            return this.sourceInfo_;
        }

        public SourceInfo getPath1SourceInfo() {
            return this.path1SourceInfo_;
        }

        public SourceInfo getPath2SourceInfo() {
            return this.path2SourceInfo_;
        }

        public IResource getResource() {
            return this.resource_;
        }

        public List<PathNode> getPath1() {
            return this.path1_;
        }

        public List<PathNode> getPath2() {
            return this.path2_;
        }

        public int getLength1() {
            return this.length1;
        }

        public int getLength2() {
            return this.length2;
        }
    }

    public class PathNode {
        private BarrierTable.BarrierInfo barrier_;
        private boolean repeat;

        public PathNode(BarrierTable.BarrierInfo barrier, boolean repeat) {
            this.barrier_ = barrier;
            this.repeat = repeat;
        }

        public PathNode(BarrierTable.BarrierInfo barrier) {
            this.barrier_ = barrier;
            this.repeat = false;
        }

        public void setRepeat(boolean val) {
            this.repeat = val;
        }

        public boolean isRepeat() {
            return this.repeat;
        }

        public BarrierTable.BarrierInfo getBarrier() {
            return this.barrier_;
        }

        public void print() {
            if (this.repeat) {
                // empty if block
            }
        }
    }

    class Work {
        BarrierExpression BE1_;
        BarrierExpression BE2_;
        int direction;

        Work(BarrierExpression be1, BarrierExpression be2, int direction) {
            this.BE1_ = be1;
            this.BE2_ = be2;
            this.direction = direction;
        }
    }
}

