/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor_vpg.contentassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.properties.SearchPathProperties;
import org.eclipse.photran.internal.ui.editor.AbstractFortranEditor;
import org.eclipse.photran.internal.ui.editor_vpg.FortranEditorTasks;
import org.eclipse.photran.internal.ui.editor_vpg.contentassist.FortranCompletionProcessorASTTask;
import org.eclipse.photran.internal.ui.editor_vpg.contentassist.FortranCompletionProcessorVPGTask;
import org.eclipse.photran.internal.ui.editor_vpg.contentassist.FortranCompletionProposalComputer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class FortranCompletionProcessor
implements IContentAssistProcessor {
    final ArrayList<String> scopes = new ArrayList();
    final HashMap<String, TreeSet<Definition>> defs = new HashMap();
    private String errorMessage = null;

    public IContentAssistant setup(AbstractFortranEditor editor) {
        String contentAssistEnabledProperty = SearchPathProperties.getProperty((IFile)editor.getIFile(), (String)"EnableContentAssist");
        if (contentAssistEnabledProperty != null && contentAssistEnabledProperty.equals("true")) {
            Color LIGHT_YELLOW = new Color(null, new RGB(255, 255, 191));
            FortranEditorTasks.instance(editor).addASTTask(new FortranCompletionProcessorASTTask(this));
            FortranEditorTasks.instance(editor).addVPGTask(new FortranCompletionProcessorVPGTask(this));
            ContentAssistant assistant = new ContentAssistant();
            String[] stringArray = AbstractFortranEditor.PARTITION_TYPES;
            int n = AbstractFortranEditor.PARTITION_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String partitionType = stringArray[n2];
                assistant.setContentAssistProcessor((IContentAssistProcessor)this, partitionType);
                ++n2;
            }
            assistant.enableAutoActivation(false);
            assistant.setProposalPopupOrientation(21);
            assistant.setContextInformationPopupBackground(LIGHT_YELLOW);
            assistant.setProposalSelectorBackground(LIGHT_YELLOW);
            return assistant;
        }
        return null;
    }

    public synchronized ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String scope;
        IDocument document;
        block6: {
            int line;
            block5: {
                if (this.defs == null) {
                    return null;
                }
                try {
                    this.errorMessage = null;
                    document = viewer.getDocument();
                    line = document.getLineOfOffset(offset);
                    if (line < this.scopes.size()) break block5;
                    return null;
                }
                catch (Exception e) {
                    this.errorMessage = String.valueOf(e.getClass().getName()) + " - " + e.getMessage();
                    return null;
                }
            }
            scope = this.scopes.get(line);
            if (scope != null) break block6;
            return null;
        }
        return new FortranCompletionProposalComputer(this.defs, scope, document, offset).compute();
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

