/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.search;

import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.FileOrIFile;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.ui.search.SearchMatch;
import org.eclipse.rephraserengine.ui.search.SearchQuery;
import org.eclipse.rephraserengine.ui.search.SearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.Workbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FortranSearchQuery
extends SearchQuery<SearchResult> {
    public static final int FIND_PROGRAM = 16;
    public static final int FIND_FUNCTION = 32;
    public static final int FIND_VARIABLE = 64;
    public static final int FIND_SUBROUTINE = 256;
    public static final int FIND_COMMON_BLOCK = 512;
    public static final int FIND_MODULE = 1024;
    public static final int FIND_ALL_TYPES = 1904;
    public static final int FIND_REFERENCES = 1;
    public static final int FIND_DECLARATIONS = 2;
    public static final int FIND_ALL_OCCURANCES = 3;
    private TreeSet<String> projectsWithRefactoringDisabled = new TreeSet();
    private TreeSet<PhotranTokenRef> matchesToAddLater;

    public FortranSearchQuery(List<IResource> scope, String scopeDesc, String patternDescription, String patternRegex, int flags) {
        super(scope, scopeDesc, patternDescription, patternRegex, flags);
    }

    protected SearchResult createInitialSearchResult() {
        return new SearchResult((ISearchQuery)this);
    }

    protected boolean shouldProcess(IResource resource) {
        return !this.shouldNotProcess(resource);
    }

    private boolean shouldNotProcess(IResource resource) {
        return resource == null || resource instanceof IProject && !PhotranVPG.getInstance().shouldProcessProject((IProject)resource) || resource instanceof IFile && !PhotranVPG.getInstance().shouldProcessFile((IFile)resource);
    }

    protected void prepareToSearch(IProgressMonitor monitor) {
        PhotranVPG.getInstance().ensureVPGIsUpToDate(monitor);
        this.matchesToAddLater = new TreeSet();
    }

    protected void search(IFile file) {
        IFortranAST ast = (IFortranAST)PhotranVPG.getInstance().acquireTransientAST(file);
        if (ast == null) {
            return;
        }
        Token searchToken = new Token(Terminal.T_IDENT, this.patternRegex);
        searchToken.setPhysicalFile(new FileOrIFile(file));
        searchToken.setLogicalFile(file);
        if (ast.getRoot().getEmptyProgram() == null) {
            for (ScopingNode sNode : ast.getRoot().getAllContainedScopes()) {
                List refs = sNode.manuallyResolve(searchToken);
                for (PhotranTokenRef ref : refs) {
                    if (ref.getOffset() < 0 || ref.getLength() < 0) continue;
                    this.foundDefinition(ref);
                }
            }
        }
    }

    private void foundDefinition(PhotranTokenRef ref) {
        Token token = ref.findToken();
        for (Definition def : token.resolveBinding()) {
            if (!this.shouldAccept(def)) continue;
            if ((this.searchFlags & 2) != 0) {
                this.foundMatch(token);
            }
            if ((this.searchFlags & 1) == 0) continue;
            for (PhotranTokenRef rref : def.findAllReferences(true)) {
                this.foundMatch(rref);
            }
        }
    }

    private boolean shouldAccept(Definition def) {
        if (!PhotranVPG.getInstance().doesProjectHaveRefactoringEnabled(def.getTokenRef().getFile())) {
            this.projectsWithRefactoringDisabled.add(def.getTokenRef().getFile().getProject().getName());
            return false;
        }
        if ((this.searchFlags & 0x10) != 0 && def.isMainProgram()) {
            return true;
        }
        if ((this.searchFlags & 0x20) != 0 && def.getClassification() == Definition.Classification.FUNCTION) {
            return true;
        }
        if ((this.searchFlags & 0x40) != 0 && def.isLocalVariable()) {
            return true;
        }
        if ((this.searchFlags & 0x100) != 0 && def.getClassification() == Definition.Classification.SUBROUTINE) {
            return true;
        }
        if ((this.searchFlags & 0x400) != 0 && def.getClassification() == Definition.Classification.MODULE) {
            return true;
        }
        return (this.searchFlags & 0x200) != 0 && def.isCommon();
    }

    private void foundMatch(Token token) {
        this.addSearchResultFromTokenRef(token.getTokenRef());
    }

    private void foundMatch(PhotranTokenRef ref) {
        this.matchesToAddLater.add(ref);
    }

    protected int numPasses() {
        return 2;
    }

    protected void runAdditionalSearchPass(int passNum, IProgressMonitor pm) {
        pm.beginTask("Adding references", this.matchesToAddLater.size());
        String lastFilename = null;
        for (PhotranTokenRef tokenRef : this.matchesToAddLater) {
            if (!tokenRef.getFilename().equals(lastFilename)) {
                lastFilename = tokenRef.getFilename();
                pm.subTask("Adding references in " + lastFilename.substring(lastFilename.lastIndexOf(47) + 1));
            }
            pm.worked(1);
            this.addSearchResultFromTokenRef(tokenRef);
        }
        pm.done();
    }

    private void addSearchResultFromTokenRef(PhotranTokenRef tokenRef) {
        FortranSearchQuery.addSearchResultFromTokenRef(tokenRef, (SearchResult)this.getSearchResult());
    }

    public static void addSearchResultFromTokenRef(PhotranTokenRef tokenRef, SearchResult searchResult) {
        Token token = tokenRef.findTokenOrReturnNull();
        if (token != null && token.getPhysicalFile() != null && token.getPhysicalFile().getIFile() != null) {
            SearchMatch match = new SearchMatch(token.getPhysicalFile().getIFile(), token.getFileOffset(), token.getLength());
            searchResult.addMatch((Match)match);
        }
    }

    protected void finishSearch() {
        if (!FortranCorePlugin.inTestingMode() && Workbench.getInstance().getWorkbenchWindowCount() > 0 && !this.projectsWithRefactoringDisabled.isEmpty()) {
            Workbench.getInstance().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    StringBuilder projects = new StringBuilder();
                    for (String project : FortranSearchQuery.this.projectsWithRefactoringDisabled) {
                        projects.append(project);
                        projects.append('\n');
                    }
                    MessageDialog.openWarning((Shell)Workbench.getInstance().getActiveWorkbenchWindow().getShell(), (String)"Warning", (String)("References in the following projects have been excluded from the search results because Fortran analysis/refactoring is disabled:\n\n" + projects + "\nPlease enable Fortran analysis/refactoring for these projects if you wish" + " for their references to show in search results."));
                }
            });
        }
    }
}

