/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.views.vpgproblems;

import org.eclipse.cdt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class RemoveMarkerAction
extends SelectionDispatchAction {
    public RemoveMarkerAction(IWorkbenchSite site) {
        super(site);
        this.setText("Delete");
        this.setToolTipText("Delete selected marker(s) from list");
    }

    public RemoveMarkerAction(IWorkbenchSite site, String text, String toolTipText) {
        super(site);
        this.setText(text);
        this.setToolTipText(toolTipText);
    }

    public ImageDescriptor getImageDescriptor() {
        Image img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        return ImageDescriptor.createFromImage((Image)img);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            if (element instanceof IMarker) continue;
            return false;
        }
        return true;
    }

    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        for (Object element : selection) {
            if (!(element instanceof IMarker)) continue;
            IMarker marker = (IMarker)element;
            try {
                marker.delete();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

