/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.internal.design.example.managers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MenuBarManager
extends MenuManager {
    private static final String MENU_BAR_VARIANT = "menuBar";
    private Composite menuParent;
    private List toolItemList = new ArrayList();
    private ToolBar toolbar;

    public void fill(Composite parent) {
        this.menuParent = parent;
        this.toolbar = new ToolBar(parent, 64);
        this.toolbar.setData("org.eclipse.rwt.themeVariant", (Object)MENU_BAR_VARIANT);
        this.update(false, false);
    }

    protected void update(boolean force, boolean recursive) {
        super.update(force, recursive);
        if (this.menuParent != null && (force || this.isDirty())) {
            this.disposeToolItems();
            IContributionItem[] items = this.getItems();
            if (items.length > 0 && this.menuParent != null) {
                int i = 0;
                while (i < items.length) {
                    IContributionItem item = items[i];
                    if (item.isVisible()) {
                        this.makeEntry(item);
                    }
                    ++i;
                }
            }
            this.menuParent.layout(true, true);
        }
    }

    private void disposeToolItems() {
        int i = 0;
        while (i < this.toolItemList.size()) {
            ToolItem item = (ToolItem)this.toolItemList.get(i);
            if (!item.isDisposed()) {
                Menu menu;
                Object data = item.getData();
                if (data != null && data instanceof Menu && !(menu = (Menu)data).isDisposed()) {
                    menu.dispose();
                }
                item.dispose();
            }
            ++i;
        }
    }

    private void makeEntry(IContributionItem item) {
        IContributionItem tempItem = null;
        if (item instanceof SubContributionItem) {
            SubContributionItem subItem = (SubContributionItem)item;
            tempItem = subItem.getInnerItem();
        } else if (item instanceof MenuManager) {
            tempItem = item;
        }
        if (tempItem != null && tempItem instanceof MenuManager) {
            final MenuManager manager = (MenuManager)tempItem;
            int style = 0;
            if (manager.getItems() != null && manager.getItems().length > 0) {
                style = 4;
            }
            final ToolItem toolItem = new ToolItem(this.toolbar, style);
            toolItem.setText(manager.getMenuText());
            toolItem.setData("org.eclipse.rwt.themeVariant", (Object)MENU_BAR_VARIANT);
            final Menu menu = new Menu((Control)this.menuParent);
            toolItem.setData((Object)menu);
            menu.setData("org.eclipse.rwt.themeVariant", (Object)MENU_BAR_VARIANT);
            toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem[] menuItems = menu.getItems();
                    int i = 0;
                    while (i < menuItems.length) {
                        menuItems[i].dispose();
                        ++i;
                    }
                    IContributionItem[] contribItems = manager.getItems();
                    if (contribItems != null && contribItems.length > 0) {
                        int i2 = 0;
                        while (i2 < contribItems.length) {
                            contribItems[i2].fill(menu, -1);
                            ++i2;
                        }
                    }
                    Display display = toolItem.getDisplay();
                    Rectangle bounds = toolItem.getBounds();
                    int leftIndent = bounds.x;
                    int topIndent = bounds.y + bounds.height;
                    Point indent = new Point(leftIndent, topIndent);
                    Point menuLocation = display.map((Control)MenuBarManager.this.toolbar, (Control)MenuBarManager.this.toolbar.getShell(), indent);
                    menu.setLocation(menuLocation);
                    menu.setData("org.eclipse.rwt.themeVariant", (Object)MenuBarManager.MENU_BAR_VARIANT);
                    MenuBarManager.this.styleMenuItems(menu);
                    menu.setVisible(true);
                }
            });
            this.toolItemList.add(toolItem);
        }
    }

    private void styleMenuItems(Menu menu) {
        MenuItem[] items = menu.getItems();
        if (items != null && items.length > 0) {
            int i = 0;
            while (i < items.length) {
                items[i].setData("org.eclipse.rwt.themeVariant", (Object)MENU_BAR_VARIANT);
                ++i;
            }
        }
    }

    public ToolBar getMenuToolBar() {
        return this.toolbar;
    }
}

