/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.parallel;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.launch.ui.ApplicationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ParallelToolRecompMainTab
extends ApplicationTab {
    private Combo buildConfCombo = null;
    protected ApplicationTab.WidgetListener listener = new PerfRecompWidgetListener();

    private void createAppControl(Composite comp) {
        Composite mainComp = new Composite(comp, 0);
        mainComp.setLayout((Layout)this.createGridLayout(2, false, 0, 0));
        mainComp.setLayoutData((Object)new GridData(768));
        Label appLabel = new Label(mainComp, 0);
        appLabel.setText("C/C++/Fortran Build Configuration");
        appLabel.setLayoutData((Object)this.spanGridData(-1, 2));
        this.buildConfCombo = new Combo(mainComp, 2060);
        this.buildConfCombo.setLayoutData((Object)new GridData(768));
        this.buildConfCombo.addModifyListener((ModifyListener)this.listener);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout());
        super.createControl(comp);
        this.setControl((Control)comp);
        this.createAppControl(comp);
    }

    protected void handleProjectButtonSelected() {
        IProject project = this.chooseProject();
        if (project == null) {
            return;
        }
        String projectName = project.getName();
        this.projText.setText(projectName);
        this.initConfCombo();
    }

    private void initializeConfCombo(ILaunchConfiguration configuration) {
        try {
            this.initConfCombo();
            String programName = configuration.getAttribute("ATTR_PERFORMANCEBUILD_CONFIGURATION_NAME", "");
            int progDex = this.buildConfCombo.indexOf(programName);
            if (!programName.equals("") && progDex >= 0) {
                this.buildConfCombo.select(progDex);
            } else {
                this.buildConfCombo.select(0);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        this.initializeConfCombo(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute("ATTR_PERFORMANCEBUILD_CONFIGURATION_NAME", this.buildConfCombo.getText());
    }

    protected ICProject getCProject() {
        String projectName = this.projText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return CoreModel.getDefault().getCModel().getCProject(projectName);
    }

    protected void initConfCombo() {
        this.buildConfCombo.removeAll();
        ICProject project = this.getCProject();
        if (project == null) {
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project.getResource());
        if (info == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)LaunchMessages.getString((String)"CMainTab.Project_required"), (String)LaunchMessages.getString((String)"CMainTab.Enter_project_before_searching_for_program"));
            return;
        }
        IConfiguration[] confs = info.getManagedProject().getConfigurations();
        int i = 0;
        while (i < confs.length) {
            this.buildConfCombo.add(confs[i].getName());
            ++i;
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        String name = null;
        boolean recompiles = false;
        try {
            recompiles = config.getAttribute("true_if_recompiling_for_analysis", false);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        boolean status = super.isValid(config);
        if (!recompiles) {
            return status;
        }
        name = this.getFieldContent(this.buildConfCombo.getText());
        if (name == null) {
            this.setErrorMessage("Build configuration not specified");
            return false;
        }
        return status;
    }

    protected class PerfRecompWidgetListener
    extends ApplicationTab.WidgetListener {
        protected PerfRecompWidgetListener() {
            super((ApplicationTab)ParallelToolRecompMainTab.this);
        }

        public void modifyText(ModifyEvent e) {
            super.modifyText(e);
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            Object source = e.getSource();
            if (source == ParallelToolRecompMainTab.this.projButton) {
                int bDex = ParallelToolRecompMainTab.this.buildConfCombo.getSelectionIndex();
                String bString = ParallelToolRecompMainTab.this.buildConfCombo.getText();
                ParallelToolRecompMainTab.this.initConfCombo();
                if (bDex >= 0 && ParallelToolRecompMainTab.this.buildConfCombo.getItemCount() > bDex && ParallelToolRecompMainTab.this.buildConfCombo.getItem(bDex).equals(bString)) {
                    ParallelToolRecompMainTab.this.buildConfCombo.select(bDex);
                } else if (ParallelToolRecompMainTab.this.buildConfCombo.getItemCount() > 0) {
                    ParallelToolRecompMainTab.this.buildConfCombo.select(0);
                }
            }
        }
    }
}

