/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static Activator plugin;
    private boolean traceVerbose;

    public static Activator getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    public static CoreException error(String message, Throwable thr) {
        return new CoreException((IStatus)new Status(4, Activator.getPluginId(), 0, message, thr));
    }

    public static void logError(String message, Throwable thr) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getPluginId(), 0, message, thr));
    }

    private static boolean isOptionSet(String optionId) {
        String option = String.valueOf(Activator.getPluginId()) + optionId;
        String value = Platform.getDebugOption((String)option);
        return value != null && value.equals("true");
    }

    public static void trace(String what) {
        if (Activator.getDefault().traceVerbose) {
            System.out.println("[" + Activator.getPluginId() + "] " + what);
        }
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.traceVerbose = Activator.isOptionSet("/trace/verbose");
        GitProjectData.reconfigureWindowCache();
        GitProjectData.attachToWorkspace(true);
    }

    public void stop(BundleContext context) throws Exception {
        GitProjectData.detachFromWorkspace();
        super.stop(context);
        plugin = null;
    }
}

