/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.ContainerTreeIterator;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;

public class AdaptableFileTreeIterator
extends FileTreeIterator {
    IWorkspaceRoot root;

    public AdaptableFileTreeIterator(File path, IWorkspaceRoot workspaceRoot) {
        super(path);
        this.root = workspaceRoot;
    }

    protected AdaptableFileTreeIterator(AdaptableFileTreeIterator parent, File path, IWorkspaceRoot workspaceRoot) {
        super((FileTreeIterator)parent, path);
        this.root = workspaceRoot;
    }

    public AbstractTreeIterator createSubtreeIterator(Repository repo) throws IncorrectObjectTypeException, IOException {
        File currentFile = ((FileTreeIterator.FileEntry)this.current()).getFile();
        IContainer[] containers = this.root.findContainersForLocation((IPath)new Path(currentFile.getAbsolutePath()));
        if (containers.length > 0) {
            return new ContainerTreeIterator((WorkingTreeIterator)this, containers[0]);
        }
        return new AdaptableFileTreeIterator(this, currentFile, this.root);
    }
}

