/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.Repository;

class GitMoveDeleteHook
implements IMoveDeleteHook {
    private static final boolean I_AM_DONE = true;
    private static final boolean FINISH_FOR_ME = false;
    private final GitProjectData data;

    GitMoveDeleteHook(GitProjectData d) {
        Assert.isNotNull((Object)d);
        this.data = d;
    }

    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        int first;
        DirCache dirc;
        block8: {
            boolean force;
            boolean bl = force = (updateFlags & 1) == 1;
            if (!force && !tree.isSynchronized((IResource)file, 0)) {
                return false;
            }
            RepositoryMapping map = RepositoryMapping.getMapping((IResource)file);
            if (map == null) {
                return false;
            }
            dirc = DirCache.lock((Repository)map.getRepository());
            first = dirc.findEntry(map.getRepoRelativePath((IResource)file));
            if (first >= 0) break block8;
            dirc.unlock();
            return false;
        }
        try {
            int next;
            DirCacheBuilder edit = dirc.builder();
            if (first > 0) {
                edit.keep(0, first);
            }
            if ((next = dirc.nextEntry(first)) < dirc.getEntryCount()) {
                edit.keep(next, dirc.getEntryCount() - next);
            }
            if (!edit.commit()) {
                tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_operationError, null));
            }
            tree.standardDeleteFile(file, updateFlags, monitor);
        }
        catch (IOException e) {
            tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_operationError, (Throwable)e));
        }
        return true;
    }

    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        if (this.data.isProtected((IResource)folder)) {
            return this.cannotModifyRepository(tree);
        }
        return false;
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    public boolean moveFile(IResourceTree tree, IFile srcf, IFile dstf, int updateFlags, IProgressMonitor monitor) {
        DirCacheEntry sEnt;
        DirCache sCache;
        RepositoryMapping dstm;
        RepositoryMapping srcm;
        block7: {
            boolean force;
            boolean bl = force = (updateFlags & 1) == 1;
            if (!force && !tree.isSynchronized((IResource)srcf, 0)) {
                return false;
            }
            srcm = RepositoryMapping.getMapping((IResource)srcf);
            if (srcm == null) {
                return false;
            }
            dstm = RepositoryMapping.getMapping((IResource)dstf);
            sCache = DirCache.lock((Repository)srcm.getRepository());
            String sPath = srcm.getRepoRelativePath((IResource)srcf);
            sEnt = sCache.getEntry(sPath);
            if (sEnt != null) break block7;
            sCache.unlock();
            return false;
        }
        try {
            DirCacheEditor sEdit = sCache.editor();
            sEdit.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(sEnt));
            if (dstm != null && dstm.getRepository() == srcm.getRepository()) {
                String dPath = srcm.getRepoRelativePath((IResource)dstf);
                sEdit.add(new DirCacheEditor.PathEdit(dPath){

                    public void apply(DirCacheEntry dEnt) {
                        dEnt.copyMetaData(sEnt);
                    }
                });
            }
            if (!sEdit.commit()) {
                tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_operationError, null));
            }
            tree.standardMoveFile(srcf, dstf, updateFlags, monitor);
        }
        catch (IOException e) {
            tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_operationError, (Throwable)e));
        }
        return true;
    }

    public boolean moveFolder(IResourceTree tree, IFolder srcf, IFolder dstf, int updateFlags, IProgressMonitor monitor) {
        DirCacheEntry[] sEnt;
        String sPath;
        DirCache sCache;
        RepositoryMapping dstm;
        RepositoryMapping srcm;
        block8: {
            boolean force;
            boolean bl = force = (updateFlags & 1) == 1;
            if (!force && !tree.isSynchronized((IResource)srcf, 0)) {
                return false;
            }
            srcm = RepositoryMapping.getMapping((IResource)srcf);
            if (srcm == null) {
                return false;
            }
            dstm = RepositoryMapping.getMapping((IResource)dstf);
            sCache = DirCache.lock((Repository)srcm.getRepository());
            sPath = srcm.getRepoRelativePath((IResource)srcf);
            sEnt = sCache.getEntriesWithin(sPath);
            if (sEnt.length != 0) break block8;
            sCache.unlock();
            return false;
        }
        try {
            DirCacheEditor sEdit = sCache.editor();
            sEdit.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeleteTree(sPath));
            if (dstm != null && dstm.getRepository() == srcm.getRepository()) {
                String dPath = String.valueOf(srcm.getRepoRelativePath((IResource)dstf)) + "/";
                int sPathLen = sPath.length() + 1;
                DirCacheEntry[] dirCacheEntryArray = sEnt;
                int n = sEnt.length;
                int n2 = 0;
                while (n2 < n) {
                    final DirCacheEntry se = dirCacheEntryArray[n2];
                    String p = se.getPathString().substring(sPathLen);
                    sEdit.add(new DirCacheEditor.PathEdit(String.valueOf(dPath) + p){

                        public void apply(DirCacheEntry dEnt) {
                            dEnt.copyMetaData(se);
                        }
                    });
                    ++n2;
                }
            }
            if (!sEdit.commit()) {
                tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_operationError, null));
            }
            tree.standardMoveFolder(srcf, dstf, updateFlags, monitor);
        }
        catch (IOException e) {
            tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_operationError, (Throwable)e));
        }
        return true;
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    private boolean cannotModifyRepository(IResourceTree tree) {
        tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_cannotModifyFolder, null));
        return true;
    }
}

