/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.ResourceRuleFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.GitMoveDeleteHook;
import org.eclipse.egit.core.internal.storage.GitFileHistoryProvider;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistoryProvider;

public class GitProvider
extends RepositoryProvider {
    private GitProjectData data;
    private GitMoveDeleteHook hook;
    private GitFileHistoryProvider historyProvider;
    private final IResourceRuleFactory resourceRuleFactory = new GitResourceRuleFactory();

    public String getID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void configureProject() throws CoreException {
        this.getData().markTeamPrivateResources();
    }

    public void deconfigure() throws CoreException {
        GitProjectData.delete(this.getProject());
    }

    public boolean canHandleLinkedResources() {
        return true;
    }

    public boolean canHandleLinkedResourceURI() {
        return true;
    }

    public synchronized IMoveDeleteHook getMoveDeleteHook() {
        GitProjectData _data;
        if (this.hook == null && (_data = this.getData()) != null) {
            this.hook = new GitMoveDeleteHook(_data);
        }
        return this.hook;
    }

    public synchronized GitProjectData getData() {
        if (this.data == null) {
            this.data = GitProjectData.get(this.getProject());
        }
        return this.data;
    }

    public synchronized IFileHistoryProvider getFileHistoryProvider() {
        if (this.historyProvider == null) {
            this.historyProvider = new GitFileHistoryProvider();
        }
        return this.historyProvider;
    }

    public IResourceRuleFactory getRuleFactory() {
        return this.resourceRuleFactory;
    }

    private static class GitResourceRuleFactory
    extends ResourceRuleFactory {
        private GitResourceRuleFactory() {
        }
    }
}

