/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;

class BlobStorage
implements IStorage {
    private final Repository db;
    private final String path;
    private final ObjectId blobId;

    BlobStorage(Repository repository, String fileName, ObjectId blob) {
        this.db = repository;
        this.path = fileName;
        this.blobId = blob;
    }

    public InputStream getContents() throws CoreException {
        try {
            return this.open();
        }
        catch (IOException e) {
            throw new ResourceException(271, this.getFullPath(), "IO error reading Git blob " + this.blobId + ".", (Throwable)e);
        }
    }

    private InputStream open() throws IOException, ResourceException, IncorrectObjectTypeException {
        ObjectLoader reader = this.db.openBlob(this.blobId);
        if (reader == null) {
            throw new ResourceException(271, this.getFullPath(), "Git blob " + this.blobId + " not found.", null);
        }
        byte[] data = reader.getBytes();
        if (reader.getType() != 3) {
            throw new IncorrectObjectTypeException(this.blobId, "blob");
        }
        return new ByteArrayInputStream(data);
    }

    public IPath getFullPath() {
        return Path.fromPortableString((String)this.path);
    }

    public String getName() {
        int last = this.path.lastIndexOf(47);
        return last >= 0 ? this.path.substring(last + 1) : this.path;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

