/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.GitTag;
import org.eclipse.egit.core.internal.storage.BlobStorage;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.team.core.history.ITag;

class CommitFileRevision
extends GitFileRevision {
    private final Repository db;
    private final RevCommit commit;
    private final PersonIdent author;
    private final String path;
    private ObjectId blobId;

    CommitFileRevision(Repository repo, RevCommit rc, String fileName) {
        this(repo, rc, fileName, null);
    }

    CommitFileRevision(Repository repo, RevCommit rc, String fileName, ObjectId blob) {
        super(fileName);
        this.db = repo;
        this.commit = rc;
        this.author = rc.getAuthorIdent();
        this.path = fileName;
        this.blobId = blob;
    }

    String getGitPath() {
        return this.path;
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        if (this.blobId == null) {
            this.blobId = this.locateBlobObjectId();
        }
        return new BlobStorage(this.db, this.path, this.blobId);
    }

    public long getTimestamp() {
        return this.author != null ? this.author.getWhen().getTime() : 0L;
    }

    public String getContentIdentifier() {
        return this.commit.getId().name();
    }

    public String getAuthor() {
        return this.author != null ? this.author.getName() : null;
    }

    public String getComment() {
        return this.commit.getShortMessage();
    }

    public String toString() {
        return this.commit.getId() + ":" + this.path;
    }

    public ITag[] getTags() {
        ArrayList<GitTag> ret = new ArrayList<GitTag>();
        for (Map.Entry tag : this.db.getTags().entrySet()) {
            ObjectId ref = ((Ref)tag.getValue()).getPeeledObjectId();
            if (ref == null || !AnyObjectId.equals((AnyObjectId)ref, (AnyObjectId)this.commit)) continue;
            ret.add(new GitTag((String)tag.getKey()));
        }
        return ret.toArray(new ITag[ret.size()]);
    }

    public RevCommit getRevCommit() {
        return this.commit;
    }

    private ObjectId locateBlobObjectId() throws CoreException {
        try {
            TreeWalk w = TreeWalk.forPath((Repository)this.db, (String)this.path, (RevTree)this.commit.getTree());
            if (w == null) {
                throw new ResourceException(271, Path.fromPortableString((String)this.path), "Path not in " + this.commit.getId() + ".", null);
            }
            return w.getObjectId(0);
        }
        catch (IOException e) {
            throw new ResourceException(271, Path.fromPortableString((String)this.path), "IO error looking up path in " + this.commit.getId() + ".", (Throwable)e);
        }
    }
}

