/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.storage;

import java.io.IOException;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.storage.BlobStorage;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.jgit.lib.GitIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.history.IFileRevision;

class IndexFileRevision
extends GitFileRevision
implements IFileRevision {
    private final Repository db;
    private final String path;
    private ObjectId blobId;

    IndexFileRevision(Repository repo, String fileName) {
        super(fileName);
        this.db = repo;
        this.path = fileName;
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        if (this.blobId == null) {
            this.blobId = this.locateBlobObjectId();
        }
        return new BlobStorage(this.db, this.path, this.blobId);
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
        return null;
    }

    public String getAuthor() {
        return "";
    }

    public long getTimestamp() {
        return -1L;
    }

    public String getComment() {
        return null;
    }

    public String getContentIdentifier() {
        return "Index";
    }

    private ObjectId locateBlobObjectId() throws CoreException {
        try {
            GitIndex idx = this.db.getIndex();
            GitIndex.Entry e = idx.getEntry(this.path);
            if (e == null) {
                throw new ResourceException(271, Path.fromPortableString((String)this.path), "Git index entry not found", null);
            }
            return e.getObjectId();
        }
        catch (IOException e) {
            throw new ResourceException(271, Path.fromPortableString((String)this.path), "IO error looking up path in index.", (Throwable)e);
        }
    }
}

