/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.lib.Commit;
import org.eclipse.jgit.lib.GitIndex;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.WorkDirCheckout;
import org.eclipse.team.core.TeamException;

public class BranchOperation
implements IWorkspaceRunnable {
    private final Repository repository;
    private final String refName;
    private Tree oldTree;
    private GitIndex index;
    private Tree newTree;
    private Commit oldCommit;
    private Commit newCommit;

    public BranchOperation(Repository repository, String refName) {
        this.repository = repository;
        this.refName = refName;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        this.lookupRefs();
        monitor.worked(1);
        this.mapObjects();
        monitor.worked(1);
        this.checkoutTree();
        monitor.worked(1);
        this.writeIndex();
        monitor.worked(1);
        this.updateHeadRef();
        monitor.worked(1);
        this.refreshProjects();
        monitor.worked(1);
        monitor.done();
    }

    private void refreshProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        File parentFile = this.repository.getWorkDir();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            File file = p.getLocation().toFile();
            if (file.getAbsolutePath().startsWith(parentFile.getAbsolutePath())) {
                try {
                    System.out.println("Refreshing " + p);
                    p.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private void updateHeadRef() throws TeamException {
        try {
            RefUpdate u = this.repository.updateRef("HEAD");
            u.setRefLogMessage("checkout: moving to " + this.refName, false);
            switch (u.link(this.refName)) {
                case NO_CHANGE: 
                case NEW: 
                case FORCED: {
                    break;
                }
                default: {
                    throw new IOException(u.getResult().name());
                }
            }
        }
        catch (IOException e) {
            throw new TeamException("Updating HEAD to ref: " + this.refName, (Throwable)e);
        }
    }

    private void writeIndex() throws TeamException {
        try {
            this.index.write();
        }
        catch (IOException e) {
            throw new TeamException("Writing index", (Throwable)e);
        }
    }

    private void checkoutTree() throws TeamException {
        try {
            new WorkDirCheckout(this.repository, this.repository.getWorkDir(), this.oldTree, this.index, this.newTree).checkout();
        }
        catch (CheckoutConflictException e) {
            TeamException teamException = new TeamException(e.getMessage());
            throw teamException;
        }
        catch (IOException e) {
            throw new TeamException("Problem while checking out:", (Throwable)e);
        }
    }

    private void mapObjects() throws TeamException {
        try {
            this.oldTree = this.oldCommit.getTree();
            this.index = this.repository.getIndex();
            this.newTree = this.newCommit.getTree();
        }
        catch (IOException e) {
            throw new TeamException("Mapping trees", (Throwable)e);
        }
    }

    private void lookupRefs() throws TeamException {
        try {
            this.newCommit = this.repository.mapCommit(this.refName);
        }
        catch (IOException e) {
            throw new TeamException("Mapping commit: " + this.refName, (Throwable)e);
        }
        try {
            this.oldCommit = this.repository.mapCommit("HEAD");
        }
        catch (IOException e) {
            throw new TeamException("Mapping commit HEAD commit", (Throwable)e);
        }
    }
}

