/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Commit;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.GitIndex;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.WorkDirCheckout;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneOperation
implements IRunnableWithProgress {
    private final URIish uri;
    private final boolean allSelected;
    private final Collection<Ref> selectedBranches;
    private final File workdir;
    private final File gitdir;
    private final String branch;
    private final String remoteName;
    private Repository local;
    private RemoteConfig remoteConfig;
    private FetchResult fetchResult;

    public CloneOperation(URIish uri, boolean allSelected, Collection<Ref> selectedBranches, File workdir, String branch, String remoteName) {
        this.uri = uri;
        this.allSelected = allSelected;
        this.selectedBranches = selectedBranches;
        this.workdir = workdir;
        this.gitdir = new File(workdir, ".git");
        this.branch = branch;
        this.remoteName = remoteName;
    }

    public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
        Object monitor = pm == null ? new NullProgressMonitor() : pm;
        try {
            try {
                monitor.beginTask(NLS.bind((String)CoreText.CloneOperation_title, (Object)this.uri), 5000);
                try {
                    this.doInit((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    this.doFetch((IProgressMonitor)new SubProgressMonitor(monitor, 4000));
                    this.doCheckout((IProgressMonitor)new SubProgressMonitor(monitor, 900));
                }
                finally {
                    this.closeLocal();
                }
            }
            catch (Exception e) {
                CloneOperation.delete(this.workdir);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public File getGitDir() {
        return this.gitdir;
    }

    private void closeLocal() {
        if (this.local != null) {
            this.local.close();
            this.local = null;
        }
    }

    private void doInit(IProgressMonitor monitor) throws URISyntaxException, IOException {
        monitor.setTaskName("Initializing local repository");
        this.local = new Repository(this.gitdir);
        this.local.create();
        RefUpdate head = this.local.updateRef("HEAD");
        head.disableRefLog();
        head.link(this.branch);
        this.remoteConfig = new RemoteConfig((Config)this.local.getConfig(), this.remoteName);
        this.remoteConfig.addURI(this.uri);
        String dst = "refs/remotes/" + this.remoteConfig.getName();
        RefSpec wcrs = new RefSpec();
        wcrs = wcrs.setForceUpdate(true);
        wcrs = wcrs.setSourceDestination("refs/heads/*", String.valueOf(dst) + "/*");
        if (this.allSelected) {
            this.remoteConfig.addFetchRefSpec(wcrs);
        } else {
            for (Ref ref : this.selectedBranches) {
                if (!wcrs.matchSource(ref)) continue;
                this.remoteConfig.addFetchRefSpec(wcrs.expandFromSource(ref));
            }
        }
        this.local.getConfig().setBoolean("core", null, "bare", false);
        this.remoteConfig.update((Config)this.local.getConfig());
        String branchName = this.branch.substring("refs/heads/".length());
        this.local.getConfig().setString("branch", branchName, "remote", this.remoteName);
        this.local.getConfig().setString("branch", branchName, "merge", this.branch);
        this.local.getConfig().save();
    }

    private void doFetch(IProgressMonitor monitor) throws NotSupportedException, TransportException {
        Transport tn = Transport.open((Repository)this.local, (RemoteConfig)this.remoteConfig);
        try {
            EclipseGitProgressTransformer pm = new EclipseGitProgressTransformer(monitor);
            this.fetchResult = tn.fetch((ProgressMonitor)pm, null);
        }
        finally {
            tn.close();
        }
    }

    private void doCheckout(IProgressMonitor monitor) throws IOException {
        Ref head = this.fetchResult.getAdvertisedRef(this.branch);
        if (head == null || head.getObjectId() == null) {
            return;
        }
        GitIndex index = new GitIndex(this.local);
        Commit mapCommit = this.local.mapCommit(head.getObjectId());
        Tree tree = mapCommit.getTree();
        RefUpdate u = this.local.updateRef("HEAD");
        u.setNewObjectId((AnyObjectId)mapCommit.getCommitId());
        u.forceUpdate();
        monitor.setTaskName("Checking out files");
        WorkDirCheckout co = new WorkDirCheckout(this.local, this.local.getWorkDir(), index, tree);
        co.checkout();
        monitor.setTaskName("Writing index");
        index.write();
    }

    private static void delete(File d) {
        File[] items;
        if (d.isDirectory() && (items = d.listFiles()) != null) {
            File[] fileArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                File c = fileArray[n2];
                CloneOperation.delete(c);
                ++n2;
            }
        }
        d.delete();
    }
}

