/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryFinder;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectProviderOperation
implements IWorkspaceRunnable {
    private final Map<IProject, File> projects = new HashMap<IProject, File>();

    public ConnectProviderOperation(IProject proj) {
        this(proj, proj.getLocation().append(".git").toFile());
    }

    public ConnectProviderOperation(IProject proj, File pathToRepo) {
        this.projects.put(proj, pathToRepo);
    }

    public ConnectProviderOperation(Map<IProject, File> projects) {
        this.projects.putAll(projects);
    }

    public void run(IProgressMonitor m) throws CoreException {
        if (m == null) {
            m = new NullProgressMonitor();
        }
        m.beginTask(CoreText.ConnectProviderOperation_connecting, 100 * this.projects.size());
        try {
            for (IProject project : this.projects.keySet()) {
                m.setTaskName(NLS.bind((String)CoreText.ConnectProviderOperation_ConnectingProject, (Object)project.getName()));
                Activator.trace("Locating repository for " + project);
                Collection<RepositoryMapping> repos = new RepositoryFinder(project).find((IProgressMonitor)new SubProgressMonitor(m, 40));
                File suggestedRepo = this.projects.get(project);
                RepositoryMapping actualMapping = this.findActualRepository(repos, suggestedRepo);
                if (actualMapping != null) {
                    GitProjectData projectData = new GitProjectData(project);
                    try {
                        projectData.setRepositoryMappings(Arrays.asList(actualMapping));
                        projectData.store();
                    }
                    catch (CoreException ce) {
                        GitProjectData.delete(project);
                        throw ce;
                    }
                    catch (RuntimeException ce) {
                        GitProjectData.delete(project);
                        throw ce;
                    }
                    RepositoryProvider.map((IProject)project, (String)GitProvider.class.getName());
                    projectData = GitProjectData.get(project);
                    project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(m, 50));
                    m.worked(10);
                    continue;
                }
                Activator.trace("Attempted to share project without repository ignored :" + project);
                m.worked(60);
            }
        }
        finally {
            m.done();
        }
    }

    private RepositoryMapping findActualRepository(Collection<RepositoryMapping> repos, File suggestedRepo) {
        for (RepositoryMapping rm : repos) {
            if (!rm.getGitDirAbsolutePath().equals((Object)Path.fromOSString((String)suggestedRepo.getPath()))) continue;
            return rm;
        }
        return null;
    }
}

