/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.team.core.RepositoryProvider;

public class DisconnectProviderOperation
implements IWorkspaceRunnable {
    private final Collection projectList;

    public DisconnectProviderOperation(Collection projs) {
        this.projectList = projs;
    }

    public void run(IProgressMonitor m) throws CoreException {
        if (m == null) {
            m = new NullProgressMonitor();
        }
        m.beginTask(CoreText.DisconnectProviderOperation_disconnecting, this.projectList.size() * 200);
        try {
            for (Object obj : this.projectList) {
                if ((obj = ((IAdaptable)obj).getAdapter(IResource.class)) instanceof IProject) {
                    IProject p = (IProject)obj;
                    Activator.trace("disconnect " + p.getName());
                    this.unmarkTeamPrivate((IContainer)p);
                    RepositoryProvider.unmap((IProject)p);
                    m.worked(100);
                    p.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(m, 100));
                    continue;
                }
                m.worked(200);
            }
        }
        finally {
            m.done();
        }
    }

    private void unmarkTeamPrivate(IContainer p) throws CoreException {
        IResource[] c = p.members(2);
        if (c != null) {
            int k = 0;
            while (k < c.length) {
                if (c[k] instanceof IContainer) {
                    this.unmarkTeamPrivate((IContainer)c[k]);
                }
                if (c[k].isTeamPrivateMember()) {
                    Activator.trace("notTeamPrivate " + c[k]);
                    c[k].setTeamPrivateMember(false);
                }
                ++k;
            }
        }
    }
}

