/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;

public class PushOperation
implements IRunnableWithProgress {
    private static final int WORK_UNITS_PER_TRANSPORT = 10;
    private final Repository localDb;
    private final PushOperationSpecification specification;
    private final boolean dryRun;
    private final RemoteConfig rc;
    private final PushOperationResult operationResult = new PushOperationResult();

    public PushOperation(Repository localDb, PushOperationSpecification specification, boolean dryRun, RemoteConfig rc) {
        this.localDb = localDb;
        this.specification = specification;
        this.dryRun = dryRun;
        this.rc = rc;
    }

    public PushOperationResult getOperationResult() {
        return this.operationResult;
    }

    public PushOperationSpecification getSpecification() {
        return this.specification;
    }

    /*
     * Loose catch block
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int totalWork = this.specification.getURIsNumber() * 10;
        if (this.dryRun) {
            monitor.beginTask(CoreText.PushOperation_taskNameDryRun, totalWork);
        } else {
            monitor.beginTask(CoreText.PushOperation_taskNameNormalRun, totalWork);
        }
        for (URIish uri : this.specification.getURIs()) {
            SubProgressMonitor subMonitor;
            block20: {
                Transport transport;
                block17: {
                    block18: {
                        subMonitor = new SubProgressMonitor(monitor, 10, 4);
                        transport = null;
                        if (!monitor.isCanceled()) break block17;
                        this.operationResult.addOperationResult(uri, CoreText.PushOperation_resultCancelled);
                        if (transport == null) break block18;
                        transport.close();
                    }
                    subMonitor.beginTask("", 10);
                    subMonitor.done();
                    subMonitor.done();
                    continue;
                }
                try {
                    transport = Transport.open((Repository)this.localDb, (URIish)uri);
                    if (this.rc != null) {
                        transport.applyConfig(this.rc);
                    }
                    transport.setDryRun(this.dryRun);
                    EclipseGitProgressTransformer gitSubMonitor = new EclipseGitProgressTransformer((IProgressMonitor)subMonitor);
                    PushResult pr = transport.push((ProgressMonitor)gitSubMonitor, this.specification.getRefUpdates(uri));
                    this.operationResult.addOperationResult(uri, pr);
                }
                catch (NoRemoteRepositoryException e) {
                    this.operationResult.addOperationResult(uri, NLS.bind((String)CoreText.PushOperation_resultNoServiceError, (Object)e.getMessage()));
                    if (transport != null) {
                        transport.close();
                    }
                    subMonitor.beginTask("", 10);
                    subMonitor.done();
                    subMonitor.done();
                    continue;
                }
                catch (TransportException e) {
                    this.operationResult.addOperationResult(uri, NLS.bind((String)CoreText.PushOperation_resultTransportError, (Object)e.getMessage()));
                    continue;
                }
                catch (NotSupportedException e) {
                    block19: {
                        this.operationResult.addOperationResult(uri, NLS.bind((String)CoreText.PushOperation_resultNotSupported, (Object)e.getMessage()));
                        if (transport == null) break block19;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        transport.close();
                    }
                    subMonitor.beginTask("", 10);
                    subMonitor.done();
                    subMonitor.done();
                    continue;
                }
                {
                    finally {
                        if (transport != null) {
                            transport.close();
                        }
                        subMonitor.beginTask("", 10);
                        subMonitor.done();
                        subMonitor.done();
                    }
                }
                if (transport == null) break block20;
                transport.close();
            }
            subMonitor.beginTask("", 10);
            subMonitor.done();
            subMonitor.done();
        }
        monitor.done();
    }
}

