/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Commit;
import org.eclipse.jgit.lib.GitIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.Tag;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.WorkDirCheckout;
import org.eclipse.team.core.TeamException;

public class ResetOperation
implements IWorkspaceRunnable {
    private final Repository repository;
    private final String refName;
    private final ResetType type;
    private Commit commit;
    private Tree newTree;
    private GitIndex index;

    public ResetOperation(Repository repository, String refName, ResetType type) {
        this.repository = repository;
        this.refName = refName;
        this.type = type;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Performing " + this.type.toString().toLowerCase() + " reset to " + this.refName, 7);
        this.mapObjects();
        monitor.worked(1);
        this.writeRef();
        monitor.worked(1);
        if (this.type != ResetType.SOFT) {
            if (this.type == ResetType.MIXED) {
                this.resetIndex();
            } else {
                this.readIndex();
            }
            this.writeIndex();
        }
        monitor.worked(1);
        if (this.type == ResetType.HARD) {
            this.checkoutIndex();
        }
        monitor.worked(1);
        if (this.type != ResetType.SOFT) {
            this.refreshIndex();
        }
        monitor.worked(1);
        monitor.worked(1);
        this.refreshProjects();
        monitor.done();
    }

    private void refreshIndex() throws TeamException {
        try {
            this.index.write();
        }
        catch (IOException e1) {
            throw new TeamException("Writing index", (Throwable)e1);
        }
    }

    private void refreshProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        File parentFile = this.repository.getWorkDir();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            File file = p.getLocation().toFile();
            if (file.getAbsolutePath().startsWith(parentFile.getAbsolutePath())) {
                try {
                    System.out.println("Refreshing " + p);
                    p.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private void mapObjects() throws TeamException {
        ObjectId commitId;
        try {
            commitId = this.repository.resolve(this.refName);
        }
        catch (IOException e) {
            throw new TeamException("looking up ref " + this.refName, (Throwable)e);
        }
        try {
            this.commit = this.repository.mapCommit(commitId);
        }
        catch (IOException iOException) {
            try {
                Tag t = this.repository.mapTag(this.refName, commitId);
                this.commit = this.repository.mapCommit(t.getObjId());
            }
            catch (IOException e2) {
                throw new TeamException("looking up commit " + commitId, (Throwable)e2);
            }
        }
    }

    private void writeRef() throws TeamException {
        try {
            RefUpdate ru = this.repository.updateRef("HEAD");
            ru.setNewObjectId((AnyObjectId)this.commit.getCommitId());
            String name = this.refName;
            if (name.startsWith("refs/heads/")) {
                name = name.substring(11);
            }
            if (name.startsWith("refs/remotes/")) {
                name = name.substring(13);
            }
            String message = "reset --" + this.type.toString().toLowerCase() + " " + name;
            ru.setRefLogMessage(message, false);
            if (ru.forceUpdate() == RefUpdate.Result.LOCK_FAILURE) {
                throw new TeamException("Can't update " + ru.getName());
            }
        }
        catch (IOException e) {
            throw new TeamException("Updating HEAD failed", (Throwable)e);
        }
    }

    private void readIndex() throws TeamException {
        try {
            this.newTree = this.commit.getTree();
            this.index = this.repository.getIndex();
        }
        catch (IOException e) {
            throw new TeamException("Reading index", (Throwable)e);
        }
    }

    private void resetIndex() throws TeamException {
        try {
            this.newTree = this.commit.getTree();
            this.index = this.repository.getIndex();
            this.index.readTree(this.newTree);
        }
        catch (IOException e) {
            throw new TeamException("Reading index", (Throwable)e);
        }
    }

    private void writeIndex() throws CoreException {
        try {
            this.index.write();
        }
        catch (IOException e) {
            throw new TeamException("Writing index", (Throwable)e);
        }
    }

    private void checkoutIndex() throws TeamException {
        File parentFile = this.repository.getWorkDir();
        try {
            WorkDirCheckout workDirCheckout = new WorkDirCheckout(this.repository, parentFile, this.index, this.newTree);
            workDirCheckout.setFailOnConflict(false);
            workDirCheckout.checkout();
        }
        catch (IOException e) {
            throw new TeamException("mapping tree for commit", (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResetType {
        SOFT,
        MIXED,
        HARD;

    }
}

