/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.IdentityHashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.GitIndex;
import org.eclipse.team.core.Team;

public class TrackOperation
implements IWorkspaceRunnable {
    private final Collection rsrcList;

    public TrackOperation(Collection rsrcs) {
        this.rsrcList = rsrcs;
    }

    public void run(IProgressMonitor m) throws CoreException {
        if (m == null) {
            m = new NullProgressMonitor();
        }
        IdentityHashMap<RepositoryMapping, Boolean> tomerge = new IdentityHashMap<RepositoryMapping, Boolean>();
        m.beginTask(CoreText.AddOperation_adding, this.rsrcList.size() * 200);
        try {
            try {
                for (Object obj : this.rsrcList) {
                    if ((obj = ((IAdaptable)obj).getAdapter(IResource.class)) instanceof IResource) {
                        String repoPath;
                        GitIndex.Entry entry;
                        IResource toAdd = (IResource)obj;
                        final RepositoryMapping rm = RepositoryMapping.getMapping(toAdd);
                        final GitIndex index = rm.getRepository().getIndex();
                        if (obj instanceof IFile && (entry = index.getEntry(repoPath = rm.getRepoRelativePath((IResource)obj))) != null && !entry.isAssumedValid()) {
                            System.out.println("Already tracked - skipping");
                            continue;
                        }
                        tomerge.put(rm, Boolean.TRUE);
                        if (toAdd instanceof IContainer) {
                            ((IContainer)toAdd).accept(new IResourceVisitor(){

                                public boolean visit(IResource resource) throws CoreException {
                                    try {
                                        String repoPath = rm.getRepoRelativePath(resource);
                                        boolean isIgnored = Team.isIgnoredHint((IResource)resource);
                                        if (resource.getType() == 1) {
                                            GitIndex.Entry entry = index.getEntry(repoPath);
                                            if (!isIgnored || entry != null && entry.isAssumedValid()) {
                                                entry = index.add(rm.getWorkDir(), new File(rm.getWorkDir(), repoPath));
                                                entry.setAssumeValid(false);
                                            }
                                        }
                                        return !isIgnored;
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        throw Activator.error(CoreText.AddOperation_failed, e);
                                    }
                                }
                            }, 2, 4);
                        } else {
                            GitIndex.Entry entry2 = index.add(rm.getWorkDir(), new File(rm.getWorkDir(), rm.getRepoRelativePath(toAdd)));
                            entry2.setAssumeValid(false);
                        }
                    }
                    m.worked(200);
                }
                for (RepositoryMapping rm : tomerge.keySet()) {
                    m.setTaskName("Writing index for " + rm.getRepository().getDirectory());
                    rm.getRepository().getIndex().write();
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw Activator.error(CoreText.AddOperation_failed, e);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw Activator.error(CoreText.AddOperation_failed, e);
            }
        }
        finally {
            try {
                try {
                    for (RepositoryMapping r : tomerge.keySet()) {
                        r.getRepository().getIndex().read();
                        r.fireRepositoryChanged();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    m.done();
                }
            }
            finally {
                m.done();
            }
        }
    }
}

