/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.lib.Repository;

public class UntrackOperation
implements IWorkspaceRunnable {
    private final Collection rsrcList;
    private final IdentityHashMap<Repository, DirCacheEditor> edits;
    private final IdentityHashMap<RepositoryMapping, Object> mappings;

    public UntrackOperation(Collection rsrcs) {
        this.rsrcList = rsrcs;
        this.edits = new IdentityHashMap();
        this.mappings = new IdentityHashMap();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void run(IProgressMonitor m) throws CoreException {
        if (m == null) {
            m = new NullProgressMonitor();
        }
        this.edits.clear();
        this.mappings.clear();
        m.beginTask(CoreText.AddOperation_adding, this.rsrcList.size() * 200);
        try {
            try {
                for (E obj : this.rsrcList) {
                    if ((obj /* !! */  = ((IAdaptable)obj /* !! */ ).getAdapter(IResource.class)) instanceof IResource) {
                        this.remove((IResource)obj /* !! */ );
                    }
                    m.worked(200);
                }
                for (Map.Entry e : this.edits.entrySet()) {
                    db = (Repository)e.getKey();
                    editor = (DirCacheEditor)e.getValue();
                    m.setTaskName("Writing index for " + db.getDirectory());
                    editor.commit();
                }
            }
            catch (RuntimeException e) {
                throw Activator.error(CoreText.UntrackOperation_failed, e);
            }
            catch (IOException e) {
                throw Activator.error(CoreText.UntrackOperation_failed, e);
            }
        }
        finally {
            ** for (rm : this.mappings.keySet())
        }
lbl-1000:
        // 1 sources

        {
            rm.fireRepositoryChanged();
            continue;
        }
lbl29:
        // 1 sources

        this.edits.clear();
        this.mappings.clear();
        m.done();
    }

    private void remove(IResource path) throws CoreException {
        IProject proj = path.getProject();
        GitProjectData pd = GitProjectData.get(proj);
        if (pd == null) {
            return;
        }
        RepositoryMapping rm = pd.getRepositoryMapping(path);
        if (rm == null) {
            return;
        }
        Repository db = rm.getRepository();
        DirCacheEditor e = this.edits.get(db);
        if (e == null) {
            try {
                e = DirCache.lock((Repository)db).editor();
            }
            catch (IOException err) {
                throw Activator.error(CoreText.UntrackOperation_failed, err);
            }
            this.edits.put(db, e);
            this.mappings.put(rm, rm);
        }
        if (path instanceof IContainer) {
            e.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeleteTree(rm.getRepoRelativePath(path)));
        } else {
            e.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(rm.getRepoRelativePath(path)));
        }
    }
}

