/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.project;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.project.RepositoryChangeListener;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.WindowCache;
import org.eclipse.jgit.lib.WindowCacheConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitProjectData {
    private static final Map<IProject, GitProjectData> projectDataCache = new HashMap<IProject, GitProjectData>();
    private static final Map<File, WeakReference> repositoryCache = new HashMap<File, WeakReference>();
    private static Set<RepositoryChangeListener> repositoryChangeListeners = new HashSet<RepositoryChangeListener>();
    private static final IResourceChangeListener rcl = new RCL();
    private static QualifiedName MAPPING_KEY = new QualifiedName(GitProjectData.class.getName(), "RepositoryMapping");
    private final IProject project;
    private final Collection<RepositoryMapping> mappings = new ArrayList<RepositoryMapping>();
    private final Set<IResource> protectedResources = new HashSet<IResource>();

    public static void attachToWorkspace(boolean includeChange) {
        GitProjectData.trace("attachToWorkspace - addResourceChangeListener");
        ResourcesPlugin.getWorkspace().addResourceChangeListener(rcl, (includeChange ? 1 : 0) | 2 | 4);
    }

    public static void detachFromWorkspace() {
        GitProjectData.trace("detachFromWorkspace - removeResourceChangeListener");
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(rcl);
    }

    public static synchronized void addRepositoryChangeListener(RepositoryChangeListener objectThatCares) {
        if (objectThatCares == null) {
            throw new NullPointerException();
        }
        repositoryChangeListeners.add(objectThatCares);
    }

    public static synchronized void removeRepositoryChangeListener(RepositoryChangeListener objectThatCares) {
        repositoryChangeListeners.remove(objectThatCares);
    }

    static void fireRepositoryChanged(RepositoryMapping which) {
        RepositoryChangeListener[] repositoryChangeListenerArray = GitProjectData.getRepositoryChangeListeners();
        int n = repositoryChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            RepositoryChangeListener listener = repositoryChangeListenerArray[n2];
            listener.repositoryChanged(which);
            ++n2;
        }
    }

    private static synchronized RepositoryChangeListener[] getRepositoryChangeListeners() {
        return repositoryChangeListeners.toArray(new RepositoryChangeListener[repositoryChangeListeners.size()]);
    }

    public static synchronized GitProjectData get(IProject p) {
        try {
            GitProjectData d = GitProjectData.lookup(p);
            if (d == null && RepositoryProvider.getProvider((IProject)p) instanceof GitProvider) {
                d = new GitProjectData(p).load();
                GitProjectData.cache(p, d);
            }
            return d;
        }
        catch (IOException err) {
            Activator.logError(CoreText.GitProjectData_missing, err);
            return null;
        }
    }

    public static void delete(IProject p) {
        GitProjectData.trace("delete(" + p.getName() + ")");
        GitProjectData d = GitProjectData.lookup(p);
        if (d == null) {
            try {
                d = new GitProjectData(p).load();
            }
            catch (IOException iOException) {
                d = new GitProjectData(p);
            }
        }
        d.delete();
    }

    static void trace(String m) {
        Activator.trace("(GitProjectData) " + m);
    }

    private static synchronized void cache(IProject p, GitProjectData d) {
        projectDataCache.put(p, d);
    }

    private static synchronized void uncache(IProject p) {
        if (projectDataCache.remove(p) != null) {
            GitProjectData.trace("uncacheDataFor(" + p.getName() + ")");
        }
    }

    private static synchronized GitProjectData lookup(IProject p) {
        return projectDataCache.get(p);
    }

    private static synchronized Repository lookupRepository(File gitDir) throws IOException {
        Repository d;
        Iterator<Map.Entry<File, WeakReference>> i = repositoryCache.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<File, WeakReference> e = i.next();
            if (((Reference)e.getValue()).get() != null) continue;
            i.remove();
        }
        Reference r = repositoryCache.get(gitDir);
        Repository repository = d = r != null ? (Repository)r.get() : null;
        if (d == null) {
            d = new Repository(gitDir);
            repositoryCache.put(gitDir, new WeakReference<Repository>(d));
        }
        return d;
    }

    public static void reconfigureWindowCache() {
        WindowCacheConfig c = new WindowCacheConfig();
        Preferences p = Activator.getDefault().getPluginPreferences();
        c.setPackedGitLimit((long)p.getInt("core_packedGitLimit"));
        c.setPackedGitWindowSize(p.getInt("core_packedGitWindowSize"));
        c.setPackedGitMMAP(p.getBoolean("core_packedGitMMAP"));
        c.setDeltaBaseCacheLimit(p.getInt("core_deltaBaseCacheLimit"));
        WindowCache.reconfigure((WindowCacheConfig)c);
    }

    public GitProjectData(IProject p) {
        this.project = p;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setRepositoryMappings(Collection<RepositoryMapping> newMappings) {
        this.mappings.clear();
        this.mappings.addAll(newMappings);
        this.remapAll();
    }

    public void markTeamPrivateResources() throws CoreException {
        for (RepositoryMapping rmObj : this.mappings) {
            IResource dotGit;
            RepositoryMapping rm = rmObj;
            IContainer c = rm.getContainer();
            if (c == null || (dotGit = c.findMember(".git")) == null) continue;
            try {
                Repository r = rm.getRepository();
                File dotGitDir = dotGit.getLocation().toFile().getCanonicalFile();
                if (!dotGitDir.equals(r.getDirectory())) continue;
                GitProjectData.trace("teamPrivate " + dotGit);
                dotGit.setTeamPrivateMember(true);
            }
            catch (IOException err) {
                throw Activator.error(CoreText.Error_CanonicalFile, err);
            }
        }
    }

    public boolean isProtected(IResource f) {
        return this.protectedResources.contains(f);
    }

    public RepositoryMapping getRepositoryMapping(IResource r) {
        try {
            while (r != null) {
                RepositoryMapping m;
                if (r.isAccessible() && (m = (RepositoryMapping)r.getSessionProperty(MAPPING_KEY)) != null) {
                    return m;
                }
                r = r.getParent();
            }
        }
        catch (CoreException err) {
            Activator.logError("Failed finding RepositoryMapping", err);
        }
        return null;
    }

    private void delete() {
        File dir = this.propertyFile().getParentFile();
        File[] todel = dir.listFiles();
        if (todel != null) {
            int k = 0;
            while (k < todel.length) {
                if (todel[k].isFile()) {
                    todel[k].delete();
                }
                ++k;
            }
        }
        dir.delete();
        GitProjectData.trace("deleteDataFor(" + this.getProject().getName() + ")");
        GitProjectData.uncache(this.getProject());
    }

    public void store() throws CoreException {
        File tmp;
        File dat = this.propertyFile();
        boolean ok = false;
        try {
            GitProjectData.trace("save " + dat);
            tmp = File.createTempFile("gpd_", ".prop", dat.getParentFile());
            FileOutputStream o = new FileOutputStream(tmp);
            try {
                Properties p = new Properties();
                Iterator<RepositoryMapping> i = this.mappings.iterator();
                while (i.hasNext()) {
                    i.next().store(p);
                }
                p.store(o, "GitProjectData");
                ok = true;
            }
            finally {
                o.close();
                if (!ok) {
                    tmp.delete();
                }
            }
        }
        catch (IOException ioe) {
            throw Activator.error(NLS.bind((String)CoreText.GitProjectData_saveFailed, (Object)dat), ioe);
        }
        dat.delete();
        if (!tmp.renameTo(dat)) {
            tmp.delete();
            throw Activator.error(NLS.bind((String)CoreText.GitProjectData_saveFailed, (Object)dat), null);
        }
    }

    private File propertyFile() {
        return new File(this.getProject().getWorkingLocation(Activator.getPluginId()).toFile(), "GitProjectData.properties");
    }

    private GitProjectData load() throws IOException {
        File dat = this.propertyFile();
        GitProjectData.trace("load " + dat);
        FileInputStream o = new FileInputStream(dat);
        try {
            Properties p = new Properties();
            p.load(o);
            this.mappings.clear();
            Iterator<Object> keyItr = p.keySet().iterator();
            while (keyItr.hasNext()) {
                String key = keyItr.next().toString();
                if (!RepositoryMapping.isInitialKey(key)) continue;
                this.mappings.add(new RepositoryMapping(p, key));
            }
        }
        finally {
            o.close();
        }
        this.remapAll();
        return this;
    }

    private void remapAll() {
        this.protectedResources.clear();
        Iterator<RepositoryMapping> i = this.mappings.iterator();
        while (i.hasNext()) {
            this.map(i.next());
        }
    }

    private void map(RepositoryMapping m) {
        IContainer c = null;
        m.clear();
        IResource r = this.getProject().findMember(m.getContainerPath());
        c = r instanceof IContainer ? (IContainer)r : (IContainer)r.getAdapter(IContainer.class);
        if (c == null) {
            Activator.logError(CoreText.GitProjectData_mappedResourceGone, new FileNotFoundException(m.getContainerPath().toString()));
            m.clear();
            return;
        }
        m.setContainer(c);
        File git = c.getLocation().append(m.getGitDirPath()).toFile();
        if (!git.isDirectory() || !new File(git, "config").isFile()) {
            Activator.logError(CoreText.GitProjectData_mappedResourceGone, new FileNotFoundException(m.getContainerPath().toString()));
            m.clear();
            return;
        }
        try {
            m.setRepository(GitProjectData.lookupRepository(git));
        }
        catch (IOException iOException) {
            Activator.logError(CoreText.GitProjectData_mappedResourceGone, new FileNotFoundException(m.getContainerPath().toString()));
            m.clear();
            return;
        }
        m.fireRepositoryChanged();
        GitProjectData.trace("map " + c + " -> " + m.getRepository());
        try {
            c.setSessionProperty(MAPPING_KEY, (Object)m);
        }
        catch (CoreException err) {
            Activator.logError("Failed to cache RepositoryMapping", err);
        }
        IResource dotGit = c.findMember(".git");
        if (dotGit != null && dotGit.getLocation().toFile().equals(git)) {
            this.protect(dotGit);
        }
    }

    private void protect(IResource c) {
        while (c != null && !c.equals((Object)this.getProject())) {
            GitProjectData.trace("protect " + c);
            this.protectedResources.add(c);
            c = c.getParent();
        }
    }

    private static class RCL
    implements IResourceChangeListener {
        private RCL() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 2: {
                    GitProjectData.uncache((IProject)event.getResource());
                    break;
                }
                case 4: {
                    GitProjectData.delete((IProject)event.getResource());
                    break;
                }
            }
        }
    }
}

