/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.project;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.GitIndex;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.TreeEntry;
import org.eclipse.team.core.RepositoryProvider;

public class RepositoryMapping {
    private final String containerPath;
    private final String gitdirPath;
    private Repository db;
    private String workdirPrefix;
    private IContainer container;

    static boolean isInitialKey(String key) {
        return key.endsWith(".gitdir");
    }

    public RepositoryMapping(Properties p, String initialKey) {
        int dot = initialKey.lastIndexOf(46);
        this.containerPath = initialKey.substring(0, dot);
        this.gitdirPath = p.getProperty(initialKey);
    }

    public RepositoryMapping(IContainer mappedContainer, File gitDir) {
        IPath cLoc = mappedContainer.getLocation().removeTrailingSeparator();
        IPath gLoc = Path.fromOSString((String)gitDir.getAbsolutePath()).removeTrailingSeparator();
        IPath gLocParent = gLoc.removeLastSegments(1);
        this.container = mappedContainer;
        this.containerPath = this.container.getProjectRelativePath().toPortableString();
        if (cLoc.isPrefixOf(gLoc)) {
            int matchingSegments = gLoc.matchingFirstSegments(cLoc);
            IPath remainder = gLoc.removeFirstSegments(matchingSegments);
            String device = remainder.getDevice();
            this.gitdirPath = device == null ? remainder.toPortableString() : remainder.toPortableString().substring(device.length());
        } else if (gLocParent.isPrefixOf(cLoc)) {
            int cnt = cLoc.segmentCount() - cLoc.matchingFirstSegments(gLocParent);
            String p = "";
            while (cnt-- > 0) {
                p = String.valueOf(p) + "../";
            }
            this.gitdirPath = p = String.valueOf(p) + gLoc.segment(gLoc.segmentCount() - 1);
        } else {
            this.gitdirPath = gLoc.toPortableString();
        }
    }

    public IPath getContainerPath() {
        return Path.fromPortableString((String)this.containerPath);
    }

    IPath getGitDirPath() {
        return Path.fromPortableString((String)this.gitdirPath);
    }

    public File getWorkDir() {
        return this.getRepository().getWorkDir();
    }

    synchronized void clear() {
        this.db = null;
        this.workdirPrefix = null;
        this.container = null;
    }

    public synchronized Repository getRepository() {
        return this.db;
    }

    synchronized void setRepository(Repository r) {
        this.db = r;
        try {
            this.workdirPrefix = this.getWorkDir().getCanonicalPath();
        }
        catch (IOException iOException) {
            this.workdirPrefix = this.getWorkDir().getAbsolutePath();
        }
        this.workdirPrefix = this.workdirPrefix.replace('\\', '/');
        if (!this.workdirPrefix.endsWith("/")) {
            this.workdirPrefix = String.valueOf(this.workdirPrefix) + "/";
        }
    }

    public synchronized IContainer getContainer() {
        return this.container;
    }

    synchronized void setContainer(IContainer c) {
        this.container = c;
    }

    public void fireRepositoryChanged() {
        GitProjectData.fireRepositoryChanged(this);
    }

    synchronized void store(Properties p) {
        p.setProperty(String.valueOf(this.containerPath) + ".gitdir", this.gitdirPath);
    }

    public String toString() {
        return "RepositoryMapping[" + this.containerPath + " -> " + this.gitdirPath + "]";
    }

    public boolean isResourceChanged(IResource rsrc) throws IOException, UnsupportedEncodingException {
        boolean hashesDiffer;
        Repository repository = this.getRepository();
        GitIndex index = repository.getIndex();
        String repoRelativePath = this.getRepoRelativePath(rsrc);
        Tree headTree = repository.mapTree("HEAD");
        TreeEntry blob = headTree != null ? headTree.findBlobMember(repoRelativePath) : null;
        GitIndex.Entry entry = index.getEntry(repoRelativePath);
        if (rsrc instanceof IFile && entry == null && blob == null) {
            return false;
        }
        if (entry == null) {
            return true;
        }
        if (blob == null) {
            return true;
        }
        boolean bl = hashesDiffer = !entry.getObjectId().equals((AnyObjectId)blob.getId());
        return hashesDiffer || entry.isModified(this.getWorkDir());
    }

    public String getRepoRelativePath(IResource rsrc) {
        int pfxLen = this.workdirPrefix.length();
        String p = rsrc.getLocation().toString();
        int pLen = p.length();
        if (pLen > pfxLen) {
            return p.substring(pfxLen);
        }
        if (p.length() == pfxLen - 1) {
            return "";
        }
        return null;
    }

    public static RepositoryMapping getMapping(IResource resource) {
        IProject project = resource.getProject();
        if (project == null) {
            return null;
        }
        RepositoryProvider rp = RepositoryProvider.getProvider((IProject)project);
        if (!(rp instanceof GitProvider)) {
            return null;
        }
        if (((GitProvider)rp).getData() == null) {
            return null;
        }
        return ((GitProvider)rp).getData().getRepositoryMapping(resource);
    }

    public String getGitDir() {
        return this.gitdirPath;
    }

    public IPath getGitDirAbsolutePath() {
        return this.container.getLocation().append(this.getGitDirPath());
    }
}

