/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.contentassist;

import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ptp.internal.rdt.core.contentassist.RemoteContentAssistInvocationContext;

public class ContentAssistUtil {
    public static RemoteContentAssistInvocationContext adaptContext(CContentAssistInvocationContext context) {
        RemoteContentAssistInvocationContext result = new RemoteContentAssistInvocationContext();
        result.setParseOffset(context.getParseOffset());
        result.setCompletionNode(context.getCompletionNode());
        result.setInPreprocessorDirective(ContentAssistUtil.inPreprocessorDirective(context));
        result.setInPreprocessorKeyword(ContentAssistUtil.inPreprocessorKeyword(context));
        result.setContextInformationOffset(context.getContextInformationOffset());
        result.setInvocationOffset(context.getInvocationOffset());
        result.setIsContextInformationStyle(context.isContextInformationStyle());
        try {
            result.setIdentifierPrefix(context.computeIdentifierPrefix());
        }
        catch (BadLocationException badLocationException) {}
        return result;
    }

    public static boolean inPreprocessorDirective(CContentAssistInvocationContext context) {
        IDocument doc = context.getViewer().getDocument();
        int offset = context.getParseOffset();
        if (offset > 0 && offset == doc.getLength()) {
            --offset;
        }
        try {
            return "__c_preprocessor".equals(TextUtilities.getContentType((IDocument)doc, (String)"___c_partitioning", (int)offset, (boolean)false));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static boolean inPreprocessorKeyword(CContentAssistInvocationContext context) {
        IDocument doc = context.getDocument();
        int offset = context.getInvocationOffset();
        try {
            String ppPrefix;
            ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)offset, (boolean)true);
            if ("__c_preprocessor".equals(partition.getType()) && (ppPrefix = doc.get(partition.getOffset(), offset - partition.getOffset())).matches("\\s*#\\s*\\w*")) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }
}

